/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.variables.values;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugValue;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugVariable;
import org.eclipse.viatra.query.tooling.debug.variables.NameConstants;
import org.eclipse.viatra.query.tooling.debug.variables.ValueWrapper;
import org.eclipse.viatra.query.tooling.debug.variables.values.MatcherValue;

public class EngineValue
extends ViatraQueryDebugValue
implements Comparable<EngineValue> {
    private String cachedLabel;

    public EngineValue(JDIDebugTarget debugTarget, ValueWrapper value) {
        super(debugTarget, value, new String[0]);
    }

    @Override
    protected synchronized List<IJavaVariable> getVariablesList() throws DebugException {
        if (this.fVariables != null) {
            return this.fVariables;
        }
        try {
            this.fVariables = new ArrayList();
            ValueWrapper matchers = this.fValue.get("matchers").get("table");
            if (matchers.isArray()) {
                for (Value val : ((ArrayReference)matchers.getValue()).getValues()) {
                    if (val == null) continue;
                    ValueWrapper wrappedValue = ValueWrapper.wrap(val, this.fValue.getThreadReference());
                    ValueWrapper valueFieldValue = wrappedValue.get("value");
                    ViatraQueryDebugVariable var = new ViatraQueryDebugVariable(this.getJavaDebugTarget());
                    MatcherValue value = new MatcherValue(this.debugTarget, valueFieldValue);
                    var.setValue((IValue)value);
                    this.fVariables.add(var);
                }
            }
            return this.fVariables;
        }
        catch (Exception e) {
            ViatraQueryLoggingUtil.getLogger(EngineValue.class).error((Object)"Couldn't retrieve the list of debug variables!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getLabel() {
        if (this.cachedLabel == null) {
            try {
                ValueWrapper isManaged = this.fValue.invoke("isManaged");
                ValueWrapper scope = this.fValue.get("scope");
                StringBuilder sb = new StringBuilder();
                if (!((BooleanValue)isManaged.getValue()).booleanValue()) {
                    sb.append("Advanced");
                }
                sb.append("ViatraQueryEngine on ");
                if (scope.getValue().type().name().matches(NameConstants.EMF_SCOPE_NAME)) {
                    ValueWrapper emfRoot = scope.get("scopeRoot");
                    ValueWrapper resourceSet = null;
                    resourceSet = this.isResourceSet(emfRoot) ? emfRoot : (this.isResource(emfRoot) ? emfRoot.invoke("getResourceSet") : emfRoot.invoke("eResource").invoke("getResourceSet"));
                    ValueWrapper resources = resourceSet.get("resources").get("data");
                    if (resources.isArray()) {
                        for (Value resource : ((ArrayReference)resources.getValue()).getValues()) {
                            if (resource == null) continue;
                            ValueWrapper wrappedResource = ValueWrapper.wrap(resource, this.fValue.getThreadReference());
                            ValueWrapper segments = wrappedResource.get("uri").get("segments");
                            int length = ((ArrayReference)segments.getValue()).length();
                            int j = 0;
                            for (Value value : ((ArrayReference)segments.getValue()).getValues()) {
                                sb.append(((StringReference)value).value());
                                if (j < length) {
                                    sb.append("/");
                                }
                                ++j;
                            }
                            sb.append(" ");
                        }
                    }
                } else {
                    ValueWrapper wrappedValue = scope.invoke("toString");
                    sb.append(((StringReference)wrappedValue.getValue()).value());
                }
                this.cachedLabel = sb.toString();
            }
            catch (Exception e) {
                ViatraQueryLoggingUtil.getLogger(EngineValue.class).error((Object)"Label initialization has failed!", (Throwable)e);
            }
        }
        return this.cachedLabel;
    }

    private boolean isResourceSet(ValueWrapper value) {
        return value.get("resources").getValue() != null;
    }

    private boolean isResource(ValueWrapper value) {
        return value.invoke("getResourceSet").getValue() != null;
    }

    @Override
    public int compareTo(EngineValue that) {
        return this.fValue.compareTo(that.fValue);
    }

    public int hashCode() {
        return this.fValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EngineValue that = (EngineValue)obj;
        return this.fValue.equals(that.fValue);
    }
}

