/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.common;

import com.sun.jdi.StackFrame;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.common.VariablesFactory;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugUtil;

public class StackFrameWrapper
extends JDIStackFrame {
    protected List<IJavaVariable> fVariables;
    protected JDIThread wrappedThread;
    protected JDIStackFrame wrappedStackFrame;
    protected StackFrame fStackFrame;
    private static Map<JDIStackFrame, StackFrameWrapper> stackFrameMap = new WeakHashMap<JDIStackFrame, StackFrameWrapper>();
    protected VariablesFactory variablesFactory;

    public static StackFrameWrapper transform(JDIStackFrame frame) {
        if (stackFrameMap.get(frame) != null) {
            return stackFrameMap.get(frame);
        }
        try {
            StackFrameWrapper transformed = new StackFrameWrapper(frame, (JDIThread)frame.getThread(), (StackFrame)ViatraQueryDebugUtil.getField(frame, "fStackFrame"), (Integer)ViatraQueryDebugUtil.getField(frame, "fDepth"));
            stackFrameMap.put(frame, transformed);
            return transformed;
        }
        catch (Exception e) {
            ViatraQueryLoggingUtil.getLogger(StackFrameWrapper.class).error((Object)"Stack frame transformation has failed!", (Throwable)e);
            return null;
        }
    }

    public StackFrameWrapper(JDIStackFrame jdiStackFrame, JDIThread thread, StackFrame frame, int depth) {
        super(thread, frame, depth);
        this.fStackFrame = frame;
        this.wrappedThread = thread;
        this.wrappedStackFrame = jdiStackFrame;
    }

    public void setVariablesFactory(VariablesFactory variablesFactory) {
        this.variablesFactory = variablesFactory;
    }

    public VariablesFactory getVariablesFactory() {
        return this.variablesFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IJavaVariable> getVariables0() throws DebugException {
        JDIThread jDIThread = this.wrappedThread;
        synchronized (jDIThread) {
            if (this.fVariables == null) {
                if (this.wrappedStackFrame.isNative()) {
                    this.requestFailed(JDIDebugModelMessages.JDIStackFrame_Variable_information_unavailable_for_native_methods, null);
                }
                this.fVariables = this.variablesFactory.getVariables(this.wrappedStackFrame, this.fStackFrame.thread());
            }
            this.updateVariables();
            return this.fVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUnderlyingStackFrame(StackFrame frame) {
        JDIThread jDIThread = this.wrappedThread;
        synchronized (jDIThread) {
            this.fStackFrame = frame;
        }
    }

    protected void setVariables(List<IJavaVariable> variables) {
        this.fVariables = variables;
    }

    protected void updateVariables() throws DebugException {
        if (this.fVariables != null) {
            this.fVariables.clear();
            for (IJavaVariable variable : this.variablesFactory.getVariables(this.wrappedStackFrame, this.fStackFrame.thread())) {
                this.fVariables.add(variable);
            }
        }
    }
}

