/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis.requirements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class TmfAbstractAnalysisRequirement
implements Predicate<ITmfTrace> {
    private final Set<@NonNull String> fValues = new HashSet<String>();
    private final Set<@NonNull String> fInformation = new HashSet<String>();
    private final PriorityLevel fLevel;

    public TmfAbstractAnalysisRequirement(Collection<String> values, PriorityLevel level) {
        this.fLevel = level;
        this.fValues.addAll(values);
    }

    public void addInformation(String information) {
        this.fInformation.add(information);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getValues() {
        Set<String> set = this.fValues;
        synchronized (set) {
            return ImmutableSet.copyOf(this.fValues);
        }
    }

    public Set<@NonNull String> getInformation() {
        return this.fInformation;
    }

    public PriorityLevel getPriorityLevel() {
        return this.fLevel;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.fValues;
    }

    public static enum PriorityLevel {
        OPTIONAL,
        ALL_OR_NOTHING,
        AT_LEAST_ONE,
        MANDATORY;

    }
}

