/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapNgFile;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapOldFile;

public final class PcapHelper {
    private PcapHelper() {
    }

    public static PcapFile getPcapFile(Path filePath) throws IOException, BadPcapFileException {
        if (Files.notExists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0]) || Files.size(filePath) < 24L) {
            throw new BadPcapFileException("Bad Pcap File.");
        }
        if (!Files.isReadable(filePath)) {
            throw new BadPcapFileException("File is not readable.");
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileChannel fileChannel = (FileChannel)NonNullUtils.checkNotNull((Object)Files.newByteChannel(filePath, new OpenOption[0]));){
            ByteBuffer header = ByteBuffer.allocate(8);
            fileChannel.read(header);
            header.flip();
            int blockType = header.getInt();
            if (blockType == 0xA0D0D0A) {
                return new PcapNgFile(filePath);
            }
            return new PcapOldFile(filePath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

