/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.base;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;

public class TmfEdge {
    private final TmfVertex fVertexFrom;
    private final TmfVertex fVertexTo;
    private EdgeType fType;
    private @Nullable String fQualifier = null;

    public TmfEdge(TmfVertex from, TmfVertex to) {
        this.fVertexFrom = from;
        this.fVertexTo = to;
        this.fType = EdgeType.DEFAULT;
    }

    public TmfVertex getVertexFrom() {
        return this.fVertexFrom;
    }

    public TmfVertex getVertexTo() {
        return this.fVertexTo;
    }

    public EdgeType getType() {
        return this.fType;
    }

    public void setType(EdgeType type) {
        this.fType = type;
    }

    public void setType(EdgeType type, @Nullable String linkQualifier) {
        this.fType = type;
        this.fQualifier = linkQualifier;
    }

    public @Nullable String getLinkQualifier() {
        return this.fQualifier;
    }

    public long getDuration() {
        return this.fVertexTo.getTs() - this.fVertexFrom.getTs();
    }

    public String toString() {
        return "[" + this.fVertexFrom + "--" + (Object)((Object)this.fType) + "->" + this.fVertexTo + "]";
    }

    public static enum EdgeType {
        EPS,
        UNKNOWN,
        DEFAULT,
        RUNNING,
        BLOCKED,
        INTERRUPTED,
        PREEMPTED,
        TIMER,
        NETWORK,
        USER_INPUT,
        BLOCK_DEVICE,
        IPI;

    }
}

