/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public abstract class OpCopyBase<D>
extends AbstractOperation {
    private IConfirmCallback fConfirmCallback;
    private LinkedList<WorkItem<D>> fWork = new LinkedList();
    private long fStartTime;

    public OpCopyBase(List<? extends IFSTreeNode> nodes, D dest, IConfirmCallback confirmCallback) {
        this.fConfirmCallback = confirmCallback;
        nodes = this.dropNestedNodes(nodes);
        this.fWork.add(new WorkItem<D>(nodes.toArray(new FSTreeNode[nodes.size()]), dest, true));
    }

    protected abstract void notifyChange(D var1);

    protected abstract IStatus refreshDestination(D var1, long var2, IProgressMonitor var4);

    protected abstract D findChild(D var1, String var2);

    protected abstract boolean isDirectory(D var1);

    protected abstract boolean isFile(D var1);

    protected abstract String getLocation(D var1);

    protected abstract IStatus performCopy(FSTreeNode var1, D var2, String var3, D var4, IProgressMonitor var5);

    protected void addWorkItem(FSTreeNode[] nodes, D dest) {
        this.fWork.addFirst(new WorkItem<D>(nodes, dest, false));
    }

    @Override
    public final IStatus doRun(IProgressMonitor monitor) {
        this.fStartTime = System.currentTimeMillis();
        monitor.beginTask(this.getName(), -1);
        WorkItem<D> lastTop = null;
        while (!this.fWork.isEmpty()) {
            IStatus s;
            WorkItem<D> item = this.fWork.remove();
            if (item.fTop) {
                if (lastTop != null) {
                    this.notifyChange(lastTop.fDestination);
                }
                lastTop = item;
            }
            if ((s = this.runWorkItem(item, monitor)).isOK()) continue;
            if (lastTop != null) {
                this.notifyChange(lastTop.fDestination);
            }
            return s;
        }
        if (lastTop != null) {
            this.notifyChange(lastTop.fDestination);
        }
        return Status.OK_STATUS;
    }

    protected IStatus runWorkItem(WorkItem<D> item, IProgressMonitor monitor) {
        Object destination = item.fDestination;
        IStatus status = this.refreshDestination(destination, this.fStartTime, monitor);
        if (!status.isOK()) {
            return status;
        }
        FSTreeNode[] fSTreeNodeArray = item.fSources;
        int n = item.fSources.length;
        int n2 = 0;
        while (n2 < n) {
            FSTreeNode source = fSTreeNodeArray[n2];
            status = this.refresh(source, this.fStartTime, monitor);
            if (!status.isOK()) {
                return status;
            }
            status = this.performCopy(source, destination, monitor);
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private IStatus performCopy(FSTreeNode source, D destination, IProgressMonitor monitor) {
        String newName = new File(source.getName().replace(':', '$')).getName();
        D existing = this.findChild(destination, newName);
        if (existing != null) {
            if (source == existing) {
                newName = this.createNewNameForCopy(destination, newName);
                existing = null;
            } else {
                if (source.isDirectory()) {
                    if (!this.isDirectory(existing)) {
                        return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noDirectory, this.getLocation(existing)), null);
                    }
                    int replace = this.confirmCallback(existing, this.fConfirmCallback);
                    if (replace == 2) {
                        return Status.OK_STATUS;
                    }
                    if (replace != 0) {
                        return Status.CANCEL_STATUS;
                    }
                    this.fWork.addFirst(new WorkItem<D>(source.getChildren(), existing, false));
                    return Status.OK_STATUS;
                }
                if (source.isFile()) {
                    if (!this.isFile(existing)) {
                        return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noFile, this.getLocation(existing)), null);
                    }
                    int replace = this.confirmCallback(existing, this.fConfirmCallback);
                    if (replace == 2) {
                        return Status.OK_STATUS;
                    }
                    if (replace != 0) {
                        return Status.CANCEL_STATUS;
                    }
                } else {
                    return Status.OK_STATUS;
                }
            }
        }
        return this.performCopy(source, destination, newName, existing, monitor);
    }

    private String createNewNameForCopy(D node, String origName) {
        String name = origName;
        int n = 0;
        while (this.findChild(node, name) != null) {
            name = n > 0 ? NLS.bind((String)Messages.Operation_CopyNOfFile, (Object)n, (Object)origName) : NLS.bind((String)Messages.Operation_CopyOfFile, (Object)origName);
            ++n;
        }
        return name;
    }

    @Override
    public String getName() {
        return Messages.OpCopy_CopyingFile;
    }

    private static class WorkItem<D> {
        final boolean fTop;
        final D fDestination;
        final FSTreeNode[] fSources;

        WorkItem(FSTreeNode[] sources, D destination, boolean top) {
            this.fSources = sources;
            this.fDestination = destination;
            this.fTop = top;
        }
    }
}

