/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.model.internal.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactoryDelegate;
import org.eclipse.tcf.te.runtime.model.nls.Messages;
import org.osgi.framework.Bundle;

public class FactoryDelegateProxy
extends ExecutableExtensionProxy<IFactoryDelegate> {
    private final List<Class<? extends IModelNode>> nodeTypes = new ArrayList<Class<? extends IModelNode>>();
    private boolean nodeTypesLoaded = false;

    public FactoryDelegateProxy(IConfigurationElement element) throws CoreException {
        super(element);
    }

    public FactoryDelegateProxy(String id, IFactoryDelegate instance) {
        super(id, (Object)instance);
    }

    public List<Class<? extends IModelNode>> getNodeTypes() {
        if (!this.nodeTypesLoaded) {
            this.loadNodeTypes();
        }
        return Collections.unmodifiableList(this.nodeTypes);
    }

    protected void loadNodeTypes() {
        IConfigurationElement element = this.getConfigurationElement();
        Assert.isNotNull((Object)element);
        this.nodeTypes.clear();
        IConfigurationElement[] nodeTypeElements = element.getChildren("nodeType");
        if (nodeTypeElements != null && nodeTypeElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = nodeTypeElements;
            int n = nodeTypeElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement nodeTypeElement = iConfigurationElementArray[n2];
                try {
                    Bundle bundle;
                    String type = nodeTypeElement.getAttribute("class");
                    String bundleId = nodeTypeElement.getAttribute("bundleId");
                    Bundle bundle2 = bundle = bundleId != null ? (bundle = Platform.getBundle((String)bundleId)) : null;
                    if (bundle == null) {
                        bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
                    }
                    if (bundle == null) {
                        bundle = CoreBundleActivator.getContext().getBundle();
                    }
                    Class typeClass = bundle != null ? bundle.loadClass(type) : Class.forName(type);
                    this.nodeTypes.add(typeClass);
                }
                catch (Exception e) {
                    Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.FactoryDelegateProxy_warning_failedToLoadNodeType, (Object)nodeTypeElement.getAttribute("class"), (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                ++n2;
            }
        }
        this.nodeTypesLoaded = true;
    }
}

