/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.MoveInDiagramDragTracker;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class SnapToAllDragEditPartsTracker
extends DragEditPartsTrackerEx
implements MoveInDiagramDragTracker {
    public static final String SNAP_TO_ALL_SHAPE_KEY = "snapToAllShape";
    public static final boolean DEFAULT_SNAP_TO_SHAPE_MODE = false;
    public static final int SNAP_TO_ALL = 0x100000D;
    boolean snapToAllShape = false;
    private Point previousMouseLocation;

    public SnapToAllDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void snapPoint(ChangeBoundsRequest request) {
        if (this.snapToAllShape) {
            this.getTargetRequest().getExtendedData().put(SNAP_TO_ALL_SHAPE_KEY, Boolean.TRUE);
        } else {
            this.getTargetRequest().getExtendedData().put(SNAP_TO_ALL_SHAPE_KEY, Boolean.FALSE);
        }
        super.snapPoint(request);
    }

    protected boolean handleKeyDown(KeyEvent event) {
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = true;
            return true;
        }
        return super.handleKeyDown(event);
    }

    protected boolean handleKeyUp(KeyEvent event) {
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = false;
            return true;
        }
        return super.handleKeyUp(event);
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.snapToAllShape = false;
        return result;
    }

    protected boolean handleButtonDown(int button) {
        if (button == 2) {
            this.setCursor(SharedCursors.HAND);
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.previousMouseLocation = this.getCurrentInput().getMouseLocation().getCopy();
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDragStarted() {
        if (this.isInState(64)) {
            return this.stateTransition(64, 128);
        }
        return super.handleDragStarted();
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)this.getCurrentViewer().getControl();
                Point currentMouseLocation = this.getCurrentInput().getMouseLocation();
                Dimension difference = this.previousMouseLocation.getDifference(currentMouseLocation);
                Point location = figureCanvas.getViewport().getViewLocation();
                figureCanvas.scrollTo(location.x + difference.width, location.y + difference.height);
            }
            return true;
        }
        return super.handleDragInProgress();
    }
}

