/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.validators;

import java.util.Collection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorUserActionName
extends ValidatorUniqueString
implements ISystemValidator {
    public static final int MAX_UDANAME_LENGTH = 256;
    protected boolean fUnique;
    protected SystemMessage msg_Invalid;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public ValidatorUserActionName(Collection existingNameList) {
        super(existingNameList, true);
        this.init();
    }

    public ValidatorUserActionName(String[] existingNameList) {
        super(existingNameList, true);
        this.init();
    }

    public ValidatorUserActionName() {
        super(new String[0], true);
        this.init();
    }

    private void init() {
        String msg1Txt = UserActionsResources.MSG_VALIDATE_UDANAME_EMPTY;
        String msg1Details = UserActionsResources.MSG_VALIDATE_UDANAME_EMPTY_DETAILS;
        SimpleSystemMessage msg1 = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1180", 4, msg1Txt, msg1Details);
        String msg2Txt = UserActionsResources.MSG_VALIDATE_UDANAME_NOTUNIQUE;
        String msg2Details = UserActionsResources.MSG_VALIDATE_UDANAME_NOTUNIQUE_DETAILS;
        SimpleSystemMessage msg2 = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1181", 4, msg2Txt, msg2Details);
        super.setErrorMessages((SystemMessage)msg1, (SystemMessage)msg2);
        this.fUnique = true;
        String msg3Txt = UserActionsResources.MSG_VALIDATE_UDANAME_NOTVALID;
        String msg3Details = UserActionsResources.MSG_VALIDATE_UDANAME_NOTVALID_DETAILS;
        SimpleSystemMessage msg3 = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1182", 4, msg3Txt, msg3Details);
        this.msg_Invalid = msg3;
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    protected boolean checkForBadCharacters(String newText) {
        return newText.indexOf(38) == -1 && newText.indexOf(64) == -1;
    }

    public String toString() {
        return "UserActionNameValidator class";
    }

    public SystemMessage isSyntaxOk(String newText) {
        this.currentMessage = newText.length() > this.getMaximumNameLength() ? this.msg_Invalid : (this.checkForBadCharacters(newText) ? null : this.msg_Invalid);
        return this.currentMessage;
    }

    public int getMaximumNameLength() {
        return 256;
    }
}

