/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.UserActionsIcon;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.swt.graphics.Image;

public class SystemUDTypeManager
extends SystemUDBaseManager {
    private static final String XE_ROOT = "FileTypes";
    public static final String XE_TYPE = "Type";
    public static final String ALL_TYPE = "ALL";

    public SystemUDTypeManager(SystemUDActionSubsystem udas) {
        super(udas);
    }

    protected boolean isUserActionsManager() {
        return false;
    }

    public Image getNewImage() {
        return UserActionsIcon.USERTYPE_NEW.getImage();
    }

    protected boolean doMigration(ISystemProfile profile, String oldRelease) {
        return this.getActionSubSystem().doTypesMigration(profile, oldRelease);
    }

    protected String getNewNodeLabel() {
        return this.getActionSubSystem().getNewNodeTypeLabel();
    }

    public String getTagName() {
        return XE_TYPE;
    }

    public SystemXMLElementWrapper createElementWrapper(IPropertySet xmlElementToWrap, ISystemProfile profile, int domain) {
        SystemUDTypeElement elementWrapper = new SystemUDTypeElement(xmlElementToWrap, this, domain);
        return elementWrapper;
    }

    public String getDocumentRootTagName() {
        return XE_ROOT;
    }

    protected boolean uppercaseName() {
        return true;
    }

    public boolean supportsProfiles() {
        return false;
    }

    public SystemXMLElementWrapper[] primeDocument(ISystemProfile profile) {
        return this.getActionSubSystem().primeDefaultTypes(this);
    }

    protected void dataChanged(ISystemProfile profile) {
        this._udas.resetResolvedTypes();
    }

    public String getTypesForTypeName(String typeName, int domain) {
        ISystemProfile profile = this.getSubSystem().getSystemProfile();
        SystemUDTypeElement element = (SystemUDTypeElement)this.findByName(profile, typeName, domain);
        if (element != null) {
            return element.getTypes();
        }
        return null;
    }

    public SystemUDTypeElement[] getTypes(Vector v, int domain) {
        if ((v = super.getXMLWrappers(v, domain, this._udas.getSubsystem().getSystemProfile())) == null) {
            return new SystemUDTypeElement[0];
        }
        SystemUDTypeElement[] types = new SystemUDTypeElement[v.size()];
        int idx = 0;
        while (idx < types.length) {
            types[idx] = (SystemUDTypeElement)v.elementAt(idx);
            ++idx;
        }
        return types;
    }

    public String[] getTypeNames(int domain) {
        Vector v = new Vector();
        if (domain != -1) {
            SystemUDTypeElement parentDomainElement = (SystemUDTypeElement)this.getDomainWrapper(null, domain);
            v = parentDomainElement.getExistingNames();
            String[] names = new String[v.size()];
            int idx = 0;
            while (idx < names.length) {
                names[idx] = (String)v.elementAt(idx);
                ++idx;
            }
            return names;
        }
        v = SystemXMLElementWrapper.getExistingNames(null, this.getDocument(null), XE_TYPE);
        String[] names = new String[v.size()];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return names;
    }

    public SystemUDTypeElement addType(int domain, String name) {
        ISystemProfile profile = this.getSubSystem().getSystemProfile();
        return (SystemUDTypeElement)super.addElement(profile, domain, name);
    }

    public void delete(SystemUDTypeElement typeElement) {
        super.delete(null, typeElement);
    }

    public void saveUserData() {
        ISystemProfile profile = this.getActionSubSystem().getSubsystem().getSystemProfile();
        super.saveUserData(profile);
    }
}

