/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui;

import java.io.PrintWriter;
import java.util.Arrays;
import org.eclipse.rse.internal.useractions.ui.ISystemSubstitutor;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVar;

public class SystemCmdSubstVarList {
    private SystemCmdSubstVar[] list;
    private SystemCmdSubstVar[] sortedList;
    private char prefix = (char)32;
    private boolean usingDelimiters = false;
    public static final char SUBST_PREFIX_AMP = '&';
    public static final char SUBST_PREFIX_DOLLAR = '$';
    public static final char SUBST_PREFIX_BRACE = '}';
    public static final String SUBST_PREFIX = "${";
    public static final char SUBST_SUFFIX_BRACE = '}';

    public SystemCmdSubstVarList(char prefix, String[] names, String[] descriptions) {
        this(null, prefix, names, descriptions);
    }

    public SystemCmdSubstVarList(SystemCmdSubstVarList commonList, char prefix, String[] names, String[] descriptions) {
        this.prefix = prefix;
        this.init(commonList, names, descriptions);
    }

    public SystemCmdSubstVarList(String[] names, String[] descriptions) {
        this(null, names, descriptions);
    }

    public SystemCmdSubstVarList(SystemCmdSubstVarList commonList, String[] names, String[] descriptions) {
        this.usingDelimiters = true;
        this.prefix = (char)36;
        this.init(commonList, names, descriptions);
    }

    public void init(SystemCmdSubstVarList commonList, String[] names, String[] descriptions) {
        SystemCmdSubstVar[] commonArray = null;
        int idx = 0;
        if (commonList == null) {
            this.list = new SystemCmdSubstVar[names.length];
        } else {
            commonArray = commonList.getListAsArray();
            this.list = new SystemCmdSubstVar[commonArray.length + names.length];
            while (idx < commonArray.length) {
                this.list[idx] = commonArray[idx];
                ++idx;
            }
        }
        String varName = null;
        String description = null;
        int jdx = 0;
        while (jdx < names.length) {
            varName = !this.usingDelimiters ? String.valueOf(this.prefix) + names[jdx] : SUBST_PREFIX + names[jdx] + '}';
            description = descriptions[jdx];
            this.list[idx] = new SystemCmdSubstVar(varName, description);
            ++idx;
            ++jdx;
        }
        Arrays.sort(this.list);
    }

    public SystemCmdSubstVar[] getListAsArray() {
        return this.list;
    }

    public String[] getDisplayStrings() {
        String[] strings = new String[this.list.length];
        int idx = 0;
        while (idx < strings.length) {
            strings[idx] = this.list[idx].getDisplayString();
            ++idx;
        }
        return strings;
    }

    public void printDisplayStrings() {
        System.out.println("Substitution Variables for " + this.getClass().getName());
        String[] strings = this.getDisplayStrings();
        int idx = 0;
        while (idx < strings.length) {
            System.out.println(strings[idx]);
            ++idx;
        }
        System.out.println();
    }

    public void printDisplayStrings(PrintWriter stream) {
        stream.println("Substitution Variables for " + this.getClass().getName());
        String[] strings = this.getDisplayStrings();
        int idx = 0;
        while (idx < strings.length) {
            stream.println(strings[idx]);
            ++idx;
        }
        stream.println();
    }

    public String doSubstitutions(String commandString, Object context, ISystemSubstitutor substitutor) {
        int index = 0;
        int lastindex = 0;
        while ((index = commandString.indexOf(this.prefix, lastindex)) >= 0) {
            String replacement;
            lastindex = index + 1;
            if (commandString.length() < index + 1) continue;
            char sc = commandString.charAt(index + 1);
            if (sc == this.prefix) {
                ++lastindex;
                continue;
            }
            String var = this.findMatchingVar(commandString, index);
            if (var == null || (replacement = substitutor.getSubstitutionValue(var, context)) == null) continue;
            if (index == 0) {
                commandString = commandString.substring(index + var.length());
            } else {
                String part1 = commandString.substring(0, index);
                String part2 = commandString.substring(index + var.length());
                commandString = String.valueOf(part1) + replacement + part2;
            }
            lastindex = index + replacement.length();
        }
        return commandString;
    }

    public String[] doAllSubstitutions(Object context, ISystemSubstitutor substitutor) {
        String[] substitutedVariables = new String[this.list.length];
        String currVar = null;
        int idx = 0;
        while (idx < this.list.length) {
            currVar = this.list[idx].getVariable();
            substitutedVariables[idx] = String.valueOf(currVar) + " = " + this.doSubstitutions("\"" + currVar + "\"", context, substitutor);
            ++idx;
        }
        return substitutedVariables;
    }

    private String findMatchingVar(String cmd, int indexOfPrefix) {
        if (this.sortedList == null) {
            this.sortedList = this.list;
        }
        int cmdlen = cmd.length();
        int idx = 0;
        while (idx < this.sortedList.length) {
            String var = this.sortedList[idx].getVariable();
            int varlen = var.length();
            if (indexOfPrefix + varlen <= cmdlen && var.equals(cmd.substring(indexOfPrefix, indexOfPrefix + varlen))) {
                return var;
            }
            ++idx;
        }
        return null;
    }

    public void testForDuplicates() {
        String currname = null;
        int idx = 0;
        while (idx < this.list.length) {
            currname = this.list[idx].getVariable();
            int i = 0;
            while (i < this.list.length) {
                if (i != idx && this.list[i].equals(currname)) {
                    System.out.println("duplicate subs var " + currname + " in list " + this.getClass().getName());
                }
                ++i;
            }
            ++idx;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

