/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.matcher;

import java.util.stream.Collectors;
import org.eclipse.reddeer.common.matcher.VersionComparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class VersionMatcher
extends TypeSafeMatcher<String> {
    private String matchingValue;

    public VersionMatcher(String matchingValue) {
        this.matchingValue = matchingValue;
    }

    private static String extractOperator(String matchedValue) {
        if (matchedValue.startsWith(">") || matchedValue.startsWith("<")) {
            if (matchedValue.substring(1, 2).equals("=")) {
                return matchedValue.substring(0, 2);
            }
            return matchedValue.substring(0, 1);
        }
        if ((matchedValue.startsWith("[") || matchedValue.startsWith("(")) && (matchedValue.endsWith("]") || matchedValue.endsWith(")"))) {
            return String.valueOf(matchedValue.substring(0, 1)) + matchedValue.substring(matchedValue.length() - 1);
        }
        return "";
    }

    private static String[] extractOperands(String matchedValue) {
        String numbers = matchedValue.chars().filter(c -> !"<>=[()]".contains(String.valueOf((char)c))).mapToObj(c -> Character.toString((char)c)).collect(Collectors.joining());
        return numbers.split(";");
    }

    private static boolean compareVersions(String version, String[] operands, String operator) {
        VersionComparator comparator = new VersionComparator();
        switch (operator) {
            case ">": {
                return comparator.compare(version, operands[0]) > 0;
            }
            case ">=": {
                return comparator.compare(version, operands[0]) >= 0;
            }
            case "<": {
                return comparator.compare(version, operands[0]) < 0;
            }
            case "<=": {
                return comparator.compare(version, operands[0]) <= 0;
            }
            case "[]": {
                return comparator.compare(version, operands[0]) >= 0 && comparator.compare(version, operands[1]) <= 0;
            }
            case "[)": {
                return comparator.compare(version, operands[0]) >= 0 && comparator.compare(version, operands[1]) < 0;
            }
            case "(]": {
                return comparator.compare(version, operands[0]) > 0 && comparator.compare(version, operands[1]) <= 0;
            }
            case "()": {
                return comparator.compare(version, operands[0]) > 0 && comparator.compare(version, operands[1]) < 0;
            }
            case "": {
                return version.equals(operands[0]);
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText(" matches string to version '" + this.matchingValue + "'.");
    }

    protected boolean matchesSafely(String attributeValue) {
        return VersionMatcher.compareVersions(attributeValue, VersionMatcher.extractOperands(this.matchingValue), VersionMatcher.extractOperator(this.matchingValue));
    }
}

