/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractSlotState;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Execution;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractObjectState;
import org.eclipse.qvtd.runtime.internal.evaluation.EOppositeReferenceImpl;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class IncrementalObjectManager
extends AbstractObjectManager<IncrementalSlotState> {
    public IncrementalObjectManager(@NonNull IncrementalInvocationManager invocationManager) {
        super(invocationManager);
    }

    @Override
    public void assigned(@NonNull Invocation.Incremental invocation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        assert (eFeature != null);
        IncrementalSlotState slotState = (IncrementalSlotState)this.updateSlotState(eObject, eFeature, ecoreValue, isPartial);
        invocation.addWriteSlot(slotState);
    }

    public @NonNull IncrementalObjectState createObjectState(@NonNull Object eObject) {
        return new IncrementalObjectState(this, eObject);
    }

    @Override
    public void created(@NonNull Invocation.Incremental invocation, @NonNull Object eObject) {
        invocation.addCreatedObject(eObject);
    }

    @Override
    public synchronized void getting(@NonNull Object eObject, EStructuralFeature eFeature, boolean isOpposite) {
        assert (eFeature != null);
        if (this.debugGettings) {
            AbstractTransformer.GETTINGS.println("getting " + IncrementalObjectManager.toDebugString(eObject) + "." + (isOpposite ? "~" : "") + eFeature.getName());
        }
        if (isOpposite) {
            eFeature = this.getEOppositeReference((EReference)eFeature);
        }
        Object slotState = this.updateSlotState(eObject, eFeature, NOT_A_VALUE, false);
        slotState.getting(eObject, eFeature);
    }

    @Override
    public void got(@NonNull Execution.Incremental execution, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        assert (eFeature != null);
        Object slotState = this.gotSlotState(eObject, eFeature, ecoreValue);
        execution.addReadSlot((SlotState.Incremental)slotState);
    }

    public void modified(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        SlotState.Incremental slotState = (SlotState.Incremental)this.basicGetSlotState(eObject, eFeature);
        if (slotState != null) {
            for (Execution.Incremental execution : slotState.getTargets()) {
                execution.revoke();
            }
        }
    }

    public static class IncrementalObjectState
    extends AbstractObjectState<IncrementalSlotState> {
        public IncrementalObjectState(@NonNull IncrementalObjectManager objectManager, @NonNull Object eObject) {
            super(objectManager, eObject);
        }

        @Override
        protected @NonNull ManyToManySlotState createManyToManySlotState(@NonNull EReference eReference) {
            return new ManyToManySlotState(this, eReference);
        }

        @Override
        protected @NonNull IncrementalSlotState createOclContainerSlotState(@NonNull EReference eReference, @NonNull Object eContainer) {
            return new OclContainerSlotState((AbstractObjectState<IncrementalSlotState>)this, eReference, eContainer);
        }

        @Override
        protected @NonNull IncrementalSlotState createOneToManyAggregatorSlotState(@NonNull EReference eReference, @NonNull Object eContents) {
            return new OneToManyAggregatorSlotState(this, eReference, eContents);
        }

        @Override
        protected @NonNull OneToManyElementSlotState createOneToManyElementSlotState(@NonNull EReference eReference, @NonNull EReference eOppositeReference, @NonNull Object eAggregator) {
            return new OneToManyElementSlotState(this, eReference, eOppositeReference, eAggregator);
        }

        @Override
        protected @NonNull IncrementalSlotState createOneToOneSlotState(@NonNull EReference eReference, @Nullable Object ecoreValue) {
            return new OneToOneSlotState(this, eReference, ecoreValue);
        }

        @Override
        protected @NonNull SimpleSlotState createSimpleSlotState(@NonNull EAttribute eFeature, @Nullable Object ecoreValue) {
            return new SimpleSlotState((AbstractObjectState<IncrementalSlotState>)this, eFeature, ecoreValue);
        }
    }

    public static abstract class IncrementalSlotState
    extends AbstractSlotState.Incremental {
        protected final @NonNull EStructuralFeature eFeature;
        private @Nullable Object value;

        protected IncrementalSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            super(objectState, ecoreValue != NOT_A_VALUE ? AbstractSlotState.SlotMode.ASSIGNED : AbstractSlotState.SlotMode.ASSIGNABLE);
            this.eFeature = eFeature;
            this.value = ecoreValue;
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.value = ecoreValue;
                    break;
                }
                case ASSIGNED: {
                    if (eFeature instanceof EOppositeReferenceImpl) break;
                    QVTruntimeUtil.errPrintln("Re-assignment of \"" + IncrementalObjectManager.toDebugString(eObject) + "\"." + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " with \"" + ecoreValue + "\"");
                    break;
                }
                case REASSIGNABLE: {
                    if (this.value == ecoreValue) break;
                    this.value = ecoreValue;
                    this.revokeTargets();
                }
            }
            this.assignedSlot();
        }

        @Override
        public final void assignedSlot() {
            switch (this.mode) {
                case ASSIGNABLE: 
                case REASSIGNABLE: {
                    this.mode = AbstractSlotState.SlotMode.ASSIGNED;
                    this.unblock();
                    break;
                }
            }
        }

        @Override
        public void debugUnblock() {
            Object eObject2 = this.objectState.getObject();
            if (eObject2 instanceof EObject) {
                Object eProxy = null;
                EObject eObject = (EObject)eObject2;
                EClassifier eType = this.eFeature.getEType();
                if (eType instanceof EClass) {
                    EClass eClass = (EClass)eType;
                    for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
                        EClass eClass2;
                        if (!(eClassifier instanceof EClass) || (eClass2 = (EClass)eClassifier).isAbstract() || !eClass2.getEAllSuperTypes().contains((Object)eClass)) continue;
                        eClass = eClass2;
                    }
                    eProxy = eType.getEPackage().getEFactoryInstance().create(eClass);
                    if (eProxy instanceof InternalEObject) {
                        ((InternalEObject)eProxy).eSetProxyURI(URI.createURI((String)"blocked"));
                    }
                } else {
                    try {
                        eProxy = eType.getEPackage().getEFactoryInstance().createFromString((EDataType)eType, "");
                    }
                    catch (Throwable eClass) {
                        // empty catch block
                    }
                }
                if (this.eFeature.isMany()) {
                    List list = (List)eObject.eGet(this.eFeature);
                    list.add(eProxy);
                } else if (!(this.eFeature instanceof EOppositeReferenceImpl)) {
                    eObject.eSet(this.eFeature, eProxy);
                }
            }
        }

        @Override
        public @NonNull EStructuralFeature getEFeature() {
            return this.eFeature;
        }

        protected @NonNull IncrementalObjectManager getObjectManager() {
            return (IncrementalObjectManager)this.objectState.getObjectManager();
        }

        @Override
        public @NonNull SlotState.Incremental getPrimarySlotState() {
            return this;
        }

        @Override
        public @Nullable Object getValue() {
            return this.value;
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: 
                case REASSIGNABLE: {
                    throw new InvocationFailedException(this);
                }
            }
        }

        @Override
        public void revokeAssigned() {
            AbstractSlotState.SlotMode mode2 = this.mode;
            this.mode = AbstractSlotState.SlotMode.REASSIGNABLE;
            if (mode2 == AbstractSlotState.SlotMode.ASSIGNED) {
                this.revokeTargets();
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(IncrementalObjectManager.toDebugString(this.objectState.getObject()));
            s.append(".");
            s.append(this.eFeature.getEContainingClass().getName());
            s.append("::");
            s.append(this.eFeature.getName());
            s.append(" ");
            s.append(this.getClass().getSimpleName());
            s.append("@");
            s.append(Integer.toHexString(System.identityHashCode(this)));
            s.append(" ");
            s.append((Object)this.mode);
            return s.toString();
        }
    }

    static class ManyToManySlotState
    extends IncrementalSlotState {
        public ManyToManySlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EReference eReference) {
            super(objectState, (EStructuralFeature)eReference, NOT_A_VALUE);
            assert (eReference.isMany());
            assert (this.getObjectManager().getEOppositeReference(eReference).isMany());
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            IncrementalObjectManager objectManager = this.getObjectManager();
            assert (ecoreValue != null);
            List ecoreValues = (List)ecoreValue;
            EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
            for (EObject element : ecoreValues) {
                if (element == null) continue;
                AbstractObjectState<@NonNull ManyToManySlotState> elementObjectState = objectManager.getObjectState(element);
                elementObjectState.putSlotState((EStructuralFeature)eOppositeReference, this);
            }
            this.assignedSlot();
        }
    }

    static class OclContainerSlotState
    extends IncrementalSlotState {
        public OclContainerSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EReference eReference, @NonNull Object eContainer) {
            super(objectState, (EStructuralFeature)eReference, eContainer);
            assert (!eReference.isMany());
            assert (this.getObjectManager().getEOppositeReference(eReference).isMany());
            assert (eReference == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER);
            assert (eReference.getEOpposite() == null);
            assert (eContainer == NOT_A_VALUE || ((EObject)objectState.getObject()).eContainer() == eContainer);
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object eContainer, boolean isPartial) {
            if (!this.isAssigned() && eContainer != null) {
                IncrementalObjectManager objectManager = this.getObjectManager();
                EObject eOpposite = (EObject)eContainer;
                EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
                eOppositeReference = ((EObject)eObject).eContainmentFeature();
                assert (eOppositeReference != null);
                Object aggregatorSlotState = objectManager.updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, eContainer, isPartial);
                aggregatorSlotState.assigned(eOpposite, (EStructuralFeature)eOppositeReference, eObject, isPartial);
            }
            super.assigned(eObject, eFeature, eContainer, isPartial);
        }

        @Override
        public @NonNull IncrementalSlotState getPrimarySlotState() {
            EObject eOpposite = (EObject)this.getValue();
            assert (eOpposite != null);
            EReference eOppositeReference = ((EReference)this.eFeature).getEOpposite();
            eOppositeReference = ((EObject)this.objectState.getObject()).eContainmentFeature();
            assert (eOppositeReference != null);
            return (IncrementalSlotState)this.getObjectManager().updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, NOT_A_VALUE, false);
        }
    }

    static class OneToManyAggregatorSlotState
    extends IncrementalSlotState {
        private OneToManyAggregatorSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EReference eReference, @Nullable Object eContents) {
            super(objectState, (EStructuralFeature)eReference, eContents);
            assert (eReference.isMany());
            assert (eContents == NOT_A_VALUE || ((EObject)objectState.getObject()).eGet((EStructuralFeature)eReference).equals(eContents));
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            assert (ecoreValue != null);
            IncrementalObjectManager objectManager = this.getObjectManager();
            EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
            if (isPartial) {
                AbstractObjectState<@NonNull SS> elementObjectState = objectManager.getObjectState(ecoreValue);
                elementObjectState.gotSlotState((EStructuralFeature)eOppositeReference, eObject);
            } else {
                Iterable ecoreValues = (Iterable)ecoreValue;
                for (EObject element : ecoreValues) {
                    if (element == null) continue;
                    AbstractObjectState<@NonNull SS> elementObjectState = objectManager.getObjectState(element);
                    elementObjectState.gotSlotState((EStructuralFeature)eOppositeReference, eObject);
                }
            }
            this.assignedSlot();
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            this.assignedSlot();
        }
    }

    static class OneToManyElementSlotState
    extends IncrementalSlotState {
        public OneToManyElementSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EReference eReference, @NonNull EReference eOppositeReference, @NonNull Object eAggregator) {
            super(objectState, (EStructuralFeature)eReference, eAggregator);
            assert (!eReference.isMany());
            assert (eOppositeReference.isMany());
            assert (eReference != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER);
            assert (eAggregator == NOT_A_VALUE || eReference instanceof EOppositeReferenceImpl || ((EObject)objectState.getObject()).eGet((EStructuralFeature)eReference) == eAggregator);
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            if (!this.isAssigned() && ecoreValue != null) {
                IncrementalObjectManager objectManager = this.getObjectManager();
                EObject eOpposite = (EObject)ecoreValue;
                EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
                assert (eOppositeReference != null);
                OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)objectManager.updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, NOT_A_VALUE, isPartial);
                aggregatorSlotState.assignedSlot();
            }
            super.assigned(eObject, eFeature, ecoreValue, isPartial);
        }

        @Override
        public @NonNull IncrementalSlotState getPrimarySlotState() {
            EObject eOpposite = (EObject)this.getValue();
            assert (eOpposite != null);
            EReference eOppositeReference = ((EReference)this.eFeature).getEOpposite();
            assert (eOppositeReference != null);
            return (IncrementalSlotState)this.getObjectManager().updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, NOT_A_VALUE, false);
        }
    }

    static class OneToOneSlotState
    extends IncrementalSlotState {
        private OneToOneSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EReference eFeature, @Nullable Object eOpposite) {
            super(objectState, (EStructuralFeature)eFeature, eOpposite);
            Object eObject = objectState.getObject();
            assert (!eFeature.isMany());
            IncrementalObjectManager objectManager = this.getObjectManager();
            if (eFeature instanceof EOppositeReferenceImpl) {
                assert (!((EOppositeReferenceImpl)eFeature).getEOpposite().isMany());
            } else {
                assert (!eFeature.isMany());
                if (!eFeature.isContainer() && !eFeature.isContainment() && eFeature != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) assert (!objectManager.getEOppositeReference(eFeature).isMany());
            }
            if (eFeature.isContainer()) {
                assert (((EObject)eObject).eContainer() == eOpposite);
            } else if (eFeature.isContainment()) {
                assert (eOpposite == null || eObject == ((EObject)eOpposite).eContainer());
            } else {
                assert (!objectManager.getEOppositeReference(eFeature).isMany());
                assert (eOpposite == NOT_A_VALUE || !(eFeature == this.eFeature ? ((EObject)eObject).eGet((EStructuralFeature)eFeature) != eOpposite : eOpposite != null && ((EObject)eOpposite).eGet((EStructuralFeature)objectManager.getEOppositeReference(eFeature)) != eObject));
            }
        }
    }

    static class SimpleSlotState
    extends IncrementalSlotState {
        public SimpleSlotState(@NonNull AbstractObjectState<@NonNull IncrementalSlotState> objectState, @NonNull EAttribute eFeature, @Nullable Object ecoreValue) {
            super(objectState, (EStructuralFeature)eFeature, ecoreValue);
        }
    }
}

