/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.AbstractRelation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.AbstractTracingStrategy;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2SuccessProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceInterface;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.TracingStrategy;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class Relation2TraceClass
extends AbstractRelation2MiddleType {
    private @Nullable Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> invocationAnalysis2relation2traceProperty = null;
    private final @NonNull Map<@NonNull String, Element2MiddleProperty> name2element2traceProperty = new HashMap<String, Element2MiddleProperty>();

    public Relation2TraceClass(@NonNull Relation2TraceGroup relation2traceGroup, @NonNull String middleClassName) {
        super(relation2traceGroup, middleClassName);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void analyzePatternNodes(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups, @NonNull RelationAnalysis relationAnalysis) {
        boolean manyTracesPerHead = headNodeGroups.size() > 2;
        HashSet<@NonNull Node> allHeadGroupNodes = new HashSet<Node>();
        for (HeadNodeGroup headNodeGroup : headNodeGroups) {
            Iterables.addAll(allHeadGroupNodes, headNodeGroup.getHeadNodes());
        }
        @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)this.relation);
        for (Node node : QVTscheduleUtil.getOwnedNodes(relationAnalysis.getRegion())) {
            if (node.isThis()) continue;
            if (node.isPattern() && !node.isConditional()) {
                this.createVariableDeclaration2TraceProperty(node, rootVariables, allHeadGroupNodes, manyTracesPerHead);
                continue;
            }
            if (node.isConditional() || node.isConstant()) continue;
            this.createVariableDeclaration2TraceProperty(node, rootVariables, allHeadGroupNodes, manyTracesPerHead);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges(relationAnalysis.getRegion())) {
            if (!edge.isRealized()) continue;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            if (sourceNode.isPredicated()) {
                this.createVariableDeclaration2TraceProperty(sourceNode, rootVariables, allHeadGroupNodes, manyTracesPerHead);
            }
            if (!targetNode.isPredicated()) continue;
            this.createVariableDeclaration2TraceProperty(targetNode, rootVariables, allHeadGroupNodes, manyTracesPerHead);
        }
    }

    @Override
    public void analyzeTraceElements(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups, @NonNull RuleAnalysis ruleAnalysis) throws CompilerChainException {
        Iterable<InvocationAnalysis> outgoingWhenInvocationAnalyses;
        Relation2TraceGroup baseRelation2traceGroup = ((RelationAnalysis)ruleAnalysis).getRule2TraceGroup().getBaseRelation2TraceGroup();
        Relation2TraceInterface baseRelation2traceInterface = baseRelation2traceGroup.basicGetRule2TraceInterface();
        if (baseRelation2traceInterface != null) {
            this.middleClass.getSuperClasses().add(baseRelation2traceInterface.getMiddleClass());
        } else {
            this.middleClass.getSuperClasses().add(this.getTransformation2TracePackage().getExecutionClass());
        }
        Iterable<@Nullable InvocationAnalysis> outgoingWhereInvocationAnalyses = ((RelationAnalysis)ruleAnalysis).basicGetOutgoingWhereInvocationAnalyses();
        if (outgoingWhereInvocationAnalyses != null) {
            for (InvocationAnalysis outgoingWhereInvocationAnalysis : outgoingWhereInvocationAnalyses) {
                assert (outgoingWhereInvocationAnalysis != null);
                if (!outgoingWhereInvocationAnalysis.needsInvocationTraceProperty()) continue;
                this.createInvocation2TraceProperty(outgoingWhereInvocationAnalysis);
            }
        }
        if ((outgoingWhenInvocationAnalyses = ((RelationAnalysis)ruleAnalysis).basicGetOutgoingWhenInvocationAnalyses()) != null) {
            for (InvocationAnalysis outgoingWhenInvocationAnalysis : outgoingWhenInvocationAnalyses) {
                assert (outgoingWhenInvocationAnalysis != null);
                if (!outgoingWhenInvocationAnalysis.needsInvocationTraceProperty()) continue;
                this.createInvocation2TraceProperty(outgoingWhenInvocationAnalysis);
            }
        }
        if (!QVTrelationUtil.hasOverrides((Relation)this.relation)) {
            this.analyzeRootTemplateVariables(headNodeGroups);
        }
        this.analyzePatternNodes(headNodeGroups, (RelationAnalysis)ruleAnalysis);
        this.analyzeGlobalSuccessNode(baseRelation2traceInterface, (RelationAnalysis)ruleAnalysis, this.scheduleManager);
    }

    protected void analyzeGlobalSuccessNode(@Nullable Relation2TraceInterface baseRelation2traceInterface, @NonNull RelationAnalysis relationAnalysis, @NonNull ScheduleManager scheduleManager) {
        boolean hasPredicatedElement;
        boolean hasTraceInterface2;
        boolean bl = hasTraceInterface2 = baseRelation2traceInterface != null;
        if (hasTraceInterface2) {
            return;
        }
        boolean hasWhenInvocation = relationAnalysis.hasIncomingWhenInvocations();
        if (hasWhenInvocation) {
            this.relation2traceGroup.addTracingStrategy(AbstractTracingStrategy.HasWhenInvocationTracingStrategy.INSTANCE);
        }
        if (hasPredicatedElement = this.hasPredicatedElement(relationAnalysis)) {
            this.relation2traceGroup.addTracingStrategy(AbstractTracingStrategy.HasPredicatedElementTracingStrategy.INSTANCE);
        }
        boolean needsGlobalSuccess = false;
        for (TracingStrategy tracingStrategy : this.relation2traceGroup.getTracingStrategies()) {
            if (!tracingStrategy.needsGlobalSuccess(this)) continue;
            needsGlobalSuccess = true;
        }
        if (needsGlobalSuccess) {
            this.getRelation2GlobalSuccessProperty();
        }
    }

    @Override
    public @Nullable Relation2SuccessProperty basicGetRelation2GlobalSuccessProperty() {
        Relation2SuccessProperty relation2SuccessProperty = super.basicGetRelation2GlobalSuccessProperty();
        if (relation2SuccessProperty != null) {
            return relation2SuccessProperty;
        }
        Relation2TraceGroup baseRelation2traceGroup = this.getRule2TraceGroup().getBaseRelation2TraceGroup();
        Relation2TraceInterface baseRelation2traceInterface = baseRelation2traceGroup.basicGetRule2TraceInterface();
        if (baseRelation2traceInterface != null) {
            return baseRelation2traceInterface.basicGetRelation2GlobalSuccessProperty();
        }
        return null;
    }

    @Override
    public @Nullable Relation2SuccessProperty basicGetRelation2LocalSuccessProperty() {
        Relation2SuccessProperty relation2SuccessProperty = super.basicGetRelation2LocalSuccessProperty();
        if (relation2SuccessProperty != null) {
            return relation2SuccessProperty;
        }
        Relation2TraceGroup baseRelation2traceGroup = this.getRule2TraceGroup().getBaseRelation2TraceGroup();
        Relation2TraceInterface baseRelation2traceInterface = baseRelation2traceGroup.basicGetRule2TraceInterface();
        if (baseRelation2traceInterface != null) {
            return baseRelation2traceInterface.basicGetRelation2LocalSuccessProperty();
        }
        return null;
    }

    public @NonNull Invocation2TraceProperty createInvocation2TraceProperty(@NonNull InvocationAnalysis invocationAnalysis) {
        Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> invocationAnalysis2relation2traceProperty2 = this.invocationAnalysis2relation2traceProperty;
        if (invocationAnalysis2relation2traceProperty2 == null) {
            this.invocationAnalysis2relation2traceProperty = invocationAnalysis2relation2traceProperty2 = new HashMap<InvocationAnalysis, Invocation2TraceProperty>();
        }
        Relation2TraceGroup invokedRule2TraceGroup = invocationAnalysis.getInvokedRelationAnalysis().getRule2TraceGroup().getBaseRelation2TraceGroup();
        String nameHint = this.relation2traceGroup.getNameGenerator().createInvocationTraceProperty(invokedRule2TraceGroup.getRule());
        boolean isRequired = !invocationAnalysis.isOptional();
        Class invocationClass = invokedRule2TraceGroup.getInvocationClass();
        Invocation2TraceProperty relation2traceProperty = new Invocation2TraceProperty(this, nameHint, invocationClass, isRequired);
        Invocation2TraceProperty oldRelation2traceProperty = invocationAnalysis2relation2traceProperty2.put(invocationAnalysis, relation2traceProperty);
        assert (oldRelation2traceProperty == null);
        return relation2traceProperty;
    }

    public @NonNull Property createProperty(@NonNull String name, @NonNull Type type) {
        String uniqueName = QVTrelationNameGenerator.getUniqueName(this.name2element2traceProperty.keySet(), name);
        Property property = PivotUtil.createProperty((String)uniqueName, (Type)type);
        return property;
    }

    @Override
    protected @NonNull String createTracePropertyName(@Nullable TypedModel typedModel, @NonNull VariableDeclaration variable) {
        return this.getTransformation2TracePackage().getNameGenerator().createTraceClassPropertyName(typedModel, variable);
    }

    protected void createVariableDeclaration2TraceProperty(@NonNull Node node, @NonNull List<@NonNull VariableDeclaration> rootVariables, @NonNull Set<@NonNull Node> allHeadGroupNodes, boolean manyTracesPerHead) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty;
        boolean unitOpposite = allHeadGroupNodes.contains(node) && !manyTracesPerHead;
        TypedModel typedModel = QVTscheduleUtil.getTypedModel((Node)node);
        VariableDeclaration variable = node.basicGetOriginatingVariable();
        if (variable != null && !rootVariables.contains(variable) && (variableDeclaration2traceProperty = this.basicGetVariableDeclaration2TraceProperty(variable)) == null) {
            this.getVariableDeclaration2TraceProperty(typedModel, variable, unitOpposite);
        }
    }

    public @NonNull Invocation2TraceProperty getInvocation2TraceProperty(@NonNull InvocationAnalysis invocationAnalysis) {
        return (Invocation2TraceProperty)ClassUtil.nonNullState((Object)((Invocation2TraceProperty)((Map)ClassUtil.nonNullState(this.invocationAnalysis2relation2traceProperty)).get(invocationAnalysis)));
    }

    @Override
    public @NonNull String getUniquePropertyName(@NonNull Element2MiddleProperty element2traceProperty, @NonNull String name) {
        return QVTrelationNameGenerator.getUniqueName(this.name2element2traceProperty, name, element2traceProperty);
    }

    private boolean hasPredicatedElement(@NonNull RelationAnalysis relationAnalysis) {
        if (!QVTrelationUtil.hasOverrides((Relation)this.relation)) {
            boolean hasPredicatedElement = false;
            RuleRegion region = (RuleRegion)relationAnalysis.getRegion();
            for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
                if (!node.isPredicated()) continue;
                return true;
            }
            if (!hasPredicatedElement) {
                for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
                    if (!edge.isPredicated()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void reservePropertyName(@NonNull String name) {
        assert (!this.name2element2traceProperty.containsKey(name));
        this.name2element2traceProperty.put(name, null);
    }

    @Override
    public void synthesizeTraceModel(@NonNull RuleAnalysis ruleAnalysis) {
        Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> incomingInvocationAnalysis2relation2traceProperty2 = this.invocationAnalysis2relation2traceProperty;
        if (incomingInvocationAnalysis2relation2traceProperty2 != null) {
            for (Invocation2TraceProperty relation2traceProperty : incomingInvocationAnalysis2relation2traceProperty2.values()) {
                relation2traceProperty.synthesizeTraceModel();
            }
        }
        super.synthesizeTraceModel(ruleAnalysis);
    }
}

