/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.ptp.rm.lml.internal.ui.LMLUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class LguiSelectionPersistence {
    private static final String TAG_DEFAULT_LGUI = "DefaultLgui";
    private static final String TAG_LGUI = "Lgui";
    private static final String TAG_LGUI_ID = "LguiID";
    private static final String MEMENTO_FILE = "defaultLgui.xml";
    private static final String NULL_ID = "null";

    public String getDefaultLguiID() {
        FileReader reader = null;
        String rmId = null;
        File file = this.getPersistenceFile();
        try {
            try {
                reader = new FileReader(file);
                XMLMemento rmSelectionInfo = XMLMemento.createReadRoot((Reader)reader);
                IMemento child = rmSelectionInfo.getChild(TAG_LGUI);
                if (child != null) {
                    rmId = child.getString(TAG_LGUI_ID);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    LMLUIPlugin.log(e);
                }
            }
            catch (WorkbenchException workbenchException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    LMLUIPlugin.log(e);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LMLUIPlugin.log(e);
            }
        }
        return rmId;
    }

    public void saveDefaultLguiID(String rmId) {
        File file = this.getPersistenceFile();
        XMLMemento memento = this.createMemento(rmId);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                memento.save((Writer)writer);
            }
            catch (IOException e) {
                LMLUIPlugin.log(e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    LMLUIPlugin.log(e2);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                LMLUIPlugin.log(e);
            }
        }
    }

    private XMLMemento createMemento(String rmId) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_DEFAULT_LGUI);
        IMemento child = memento.createChild(TAG_LGUI);
        if (rmId == null) {
            child.putString(TAG_LGUI_ID, NULL_ID);
        } else {
            child.putString(TAG_LGUI_ID, rmId);
        }
        return memento;
    }

    private File getPersistenceFile() {
        LMLUIPlugin plugin = LMLUIPlugin.getDefault();
        return plugin.getStateLocation().append(MEMENTO_FILE).toFile();
    }
}

