/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.core.model;

import java.util.ArrayList;
import java.util.List;

public class Node<T> {
    private List<Node<T>> children = new ArrayList<Node<T>>();
    private T data;

    public Node() {
    }

    public Node(T data) {
        this();
        this.data = data;
    }

    public void add(Node<T> child) {
        this.children.add(child);
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public int getChildrenCountTillLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level == 1) {
            return this.children.size();
        }
        int count = this.children.size();
        for (Node<T> child : this.children) {
            count += child.getChildrenCountTillLevel(level - 1);
        }
        return count;
    }

    public T getData() {
        return this.data;
    }

    public int getFullChildrenCount() {
        int count = this.children.size();
        for (Node<T> child : this.children) {
            count += child.getFullChildrenCount();
        }
        return count;
    }

    public int getLowerLevelCount() {
        if (this.children.size() == 0) {
            return 0;
        }
        int max = 0;
        for (Node<T> child : this.children) {
            if (child.getLowerLevelCount() <= max) continue;
            max = child.getLowerLevelCount();
        }
        return max + 1;
    }

    public boolean remove(Node<T> child) {
        return this.children.remove(child);
    }

    public void setData(T data) {
        this.data = data;
    }
}

