/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util.compression.huffmancoder;

import java.nio.ByteBuffer;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ISymbolDefiner;

final class ByteSymbolTable
implements ISymbolDefiner {
    private final byte[][] symbolIndex = new byte[256][];
    private int curr;

    ByteSymbolTable() {
        int i = 0;
        while (i < 256) {
            this.symbolIndex[i] = new byte[1];
            this.symbolIndex[i][0] = (byte)i;
            ++i;
        }
        this.curr = 0;
    }

    public byte[] getSymbolRepresentation(int index) {
        return this.symbolIndex[index];
    }

    public int nextSymbol(byte[] in) {
        if (this.curr < in.length) {
            return in[this.curr++] & 0xFF;
        }
        return -1;
    }

    public int nextSymbol(byte[] in, int at) {
        if (at < in.length) {
            this.curr = at + 1;
            return in[at] & 0xFF;
        }
        return -1;
    }

    public int nextSymbol(ByteBuffer in) {
        if (in.position() < in.limit()) {
            return in.get() & 0xFF;
        }
        return -1;
    }
}

