/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.internal.ui.wizards.types.TextTemplate;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.osgi.framework.Bundle;

public abstract class TestTemplate
extends TextTemplate {
    private static final String TEST_SUPER_CLASS_NAME = "TestSuperClassName";
    private static final String TEST_CLASS_NAME = "TestClassName";
    private static final String IGNORE_STRUCT = "Ignore";
    protected static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String REQUIRE_VAR = "RequireLocation";
    private static final String REQUIRES_STRUCT = "Requires";
    private static final String REQUIRES_COMPILED = "RequiresCompiled";
    private List<String> requires;

    public void addRequire(String location) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>(1);
        }
        this.requires.add(location.replace('\\', '/'));
    }

    protected void compileRequires() {
        this.extract(INPUT, REQUIRES_STRUCT, REQUIRES_COMPILED);
        if (this.requires == null || this.requires.isEmpty()) {
            this.set(REQUIRES_STRUCT, "");
            return;
        }
        for (String require : this.requires) {
            this.set(REQUIRE_VAR, require);
            this.compile(REQUIRES_COMPILED, REQUIRES_STRUCT, true);
        }
    }

    public String compileTemplate() {
        this.compileRequires();
        this.removeIgnore();
        return this.compile(INPUT, OUTPUT, false);
    }

    protected abstract String getTemplatePath();

    private String readTemplate() throws IOException {
        String line;
        URL url = FileLocator.find((Bundle)PHPUnitPlugin.getDefault().getBundle(), (IPath)new Path(this.getTemplatePath()), null);
        url = FileLocator.resolve((URL)url);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void removeIgnore() {
        this.extract(INPUT, IGNORE_STRUCT, "");
        this.set(IGNORE_STRUCT, "");
    }

    public String resolveTemplate() throws IOException {
        return this.set(INPUT, this.readTemplate());
    }

    public void setTestClassParams(String name, String location) {
        this.set(TEST_CLASS_NAME, name);
    }

    public void setTestSuperClass(IType superClass, String superClassName, IProject project) {
        String superClassFileName = null;
        if (superClass == null) {
            superClassFileName = null;
        } else {
            IScriptProject create = DLTKCore.create((IProject)project);
            IPath relative = IncludePathUtils.getRelativeLocationFromIncludePath((IScriptProject)create, (IModelElement)superClass);
            if (!relative.isEmpty()) {
                superClassFileName = relative.toOSString();
            }
        }
        this.setTestSuperClassParams(superClassName, superClassFileName);
    }

    private void setTestSuperClassParams(String name, String relativeLocation) {
        this.set(TEST_SUPER_CLASS_NAME, name);
    }
}

