/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationTab;
import org.eclipse.php.internal.debug.ui.launching.DebuggerLaunchSettingsSectionAdapter;
import org.eclipse.php.internal.debug.ui.launching.DebuggerLaunchSettingsSectionRegistry;
import org.eclipse.php.internal.debug.ui.launching.IDebuggerLaunchSettingsSection;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPHPLaunchConfigurationDebuggerTab
extends AbstractPHPLaunchConfigurationTab {
    protected Button validateDebuggerBtn;
    protected IDebugServerConnectionTest[] debugTesters;
    private Label debuggerName;
    private Button configureDebugger;
    private Composite mainComposite;
    private Composite settingsComposite;
    private Map<String, IDebuggerLaunchSettingsSection> currentSection = new HashMap<String, IDebuggerLaunchSettingsSection>();

    public String getName() {
        return Messages.AbstractPHPLaunchConfigurationDebuggerTab_Debugger_tab_name;
    }

    public Image getImage() {
        return PHPDebugUIImages.get("IMG_OBJ_DEBUG_CONF");
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)mainLayout);
        this.createDebuggerSelectionControl(this.mainComposite);
        this.settingsComposite = new Composite(this.mainComposite, 0);
        Dialog.applyDialogFont((Control)this.mainComposite);
        this.setControl((Control)this.mainComposite);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        try {
            if (!configuration.hasAttribute("firstLineBreakpoint")) {
                configuration.setAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine());
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        this.getSection().setDefaults(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getCurrentDebuggerId());
        this.getSection().performApply(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setWarningMessage(null);
        this.setErrorMessage(null);
        StatusMessage status = this.getSection().isValid(launchConfig);
        switch (status.getMessageType()) {
            case 3: {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            case 2: {
                this.setWarningMessage(status.getMessage());
                return true;
            }
        }
        return true;
    }

    @Override
    protected void initialize(ILaunchConfiguration configuration) {
        this.getSection().initialize(configuration);
    }

    protected abstract void handleConfigureDebugger();

    protected abstract String getCurrentDebuggerId();

    protected abstract String getNoDebuggerMessage();

    protected abstract void updateDebugTest();

    protected abstract void performDebugTest();

    private void createDebuggerSelectionControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout mcLayout = new GridLayout(1, false);
        mcLayout.marginHeight = 0;
        mcLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)mcLayout);
        mainComposite.setLayoutData((Object)new GridData(768));
        Composite debuggerChoiceComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout(5, false);
        debuggerChoiceComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        debuggerChoiceComposite.setLayoutData((Object)data);
        Font font = parent.getFont();
        debuggerChoiceComposite.setFont(font);
        Label label = new Label(debuggerChoiceComposite, 64);
        data = new GridData(1);
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText(Messages.AbstractPHPLaunchConfigurationDebuggerTab_Debugger_type);
        this.debuggerName = new Label(debuggerChoiceComposite, 0);
        Label separator = new Label(debuggerChoiceComposite, 0);
        data = new GridData(1);
        data.widthHint = 20;
        separator.setLayoutData((Object)data);
        this.configureDebugger = this.createPushButton(debuggerChoiceComposite, Messages.AbstractPHPLaunchConfigurationDebuggerTab_Configure, null);
        this.configureDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPHPLaunchConfigurationDebuggerTab.this.handleConfigureDebugger();
            }
        });
        this.configureDebugger.addSelectionListener((SelectionListener)new WidgetListener());
        this.validateDebuggerBtn = this.createPushButton(debuggerChoiceComposite, Messages.AbstractPHPLaunchConfigurationDebuggerTab_Test, null);
        this.validateDebuggerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractPHPLaunchConfigurationDebuggerTab.this.performDebugTest();
            }
        });
        Label lineSeparator = new Label(mainComposite, 258);
        lineSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private IDebuggerLaunchSettingsSection getSection() {
        try {
            String launchTypeId = this.getConfiguration().getType().getIdentifier();
            String debuggerId = this.getCurrentDebuggerId();
            IDebuggerLaunchSettingsSection section = this.currentSection.get(debuggerId);
            if (section == null) {
                if ("org.eclipse.php.debug.core.noneDebugger".equals(debuggerId)) {
                    section = new NoneDebuggerSection();
                } else {
                    section = DebuggerLaunchSettingsSectionRegistry.getSection(debuggerId, launchTypeId);
                    if (section == null) {
                        section = new UnsupportedDebuggerSection();
                    }
                }
                if (this.settingsComposite != null) {
                    this.buildSection(debuggerId, section);
                }
            }
            return section;
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
            return null;
        }
    }

    private void buildSection(String debuggerId, IDebuggerLaunchSettingsSection section) {
        this.updateDebugger(debuggerId);
        this.currentSection.clear();
        this.currentSection.put(debuggerId, section);
        this.settingsComposite.dispose();
        this.settingsComposite = new Composite(this.mainComposite, 0);
        this.settingsComposite.setLayout((Layout)new GridLayout());
        GridData dscData = new GridData(4, 4, true, true);
        this.settingsComposite.setLayoutData((Object)dscData);
        section.createSection(this.settingsComposite, new WidgetListener());
        this.mainComposite.layout();
        section.initialize(this.getConfiguration());
    }

    private void updateDebugger(String debuggerId) {
        this.debuggerName.setText(PHPDebuggersRegistry.getDebuggerName((String)debuggerId));
        try {
            if (this.getOriginalConfiguration().contentsEqual(this.getConfiguration())) {
                ILaunchConfigurationWorkingCopy wc = this.getOriginalConfiguration().getWorkingCopy();
                wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId);
                wc.doSave();
            }
            if (this.getConfiguration() instanceof ILaunchConfigurationWorkingCopy) {
                ((ILaunchConfigurationWorkingCopy)this.getConfiguration()).setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId);
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        this.updateDebugTest();
    }

    private final class NoneDebuggerSection
    extends DebuggerLaunchSettingsSectionAdapter {
        private NoneDebuggerSection() {
        }

        @Override
        public StatusMessage isValid(ILaunchConfiguration configuration) {
            return new StatusMessage(3, AbstractPHPLaunchConfigurationDebuggerTab.this.getNoDebuggerMessage());
        }
    }

    public static final class StatusMessage
    implements IMessageProvider {
        private int type;
        private String message;

        public StatusMessage(int type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }
    }

    private final class UnsupportedDebuggerSection
    extends DebuggerLaunchSettingsSectionAdapter {
        private UnsupportedDebuggerSection() {
        }

        @Override
        public void createSection(Composite parent, WidgetListener widgetListener) {
            Label info = new Label(parent, 0);
            info.setText(Messages.AbstractPHPLaunchConfigurationDebuggerTab_Unsupported_debugger_type);
        }

        @Override
        public StatusMessage isValid(ILaunchConfiguration configuration) {
            return new StatusMessage(3, Messages.AbstractPHPLaunchConfigurationDebuggerTab_Unsupported_debugger_type);
        }
    }

    public final class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            AbstractPHPLaunchConfigurationDebuggerTab.this.setDirty(true);
            AbstractPHPLaunchConfigurationDebuggerTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractPHPLaunchConfigurationDebuggerTab.this.setDirty(true);
            AbstractPHPLaunchConfigurationDebuggerTab.this.updateLaunchConfigurationDialog();
        }
    }
}

