/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.php.composer.api.annotation.Name;
import org.eclipse.php.composer.api.entities.AbstractJsonObject;
import org.eclipse.php.composer.api.entities.Entity;
import org.eclipse.php.composer.api.entities.JsonCollection;
import org.eclipse.php.composer.api.entities.JsonValue;
import org.eclipse.php.composer.api.json.JsonFormatter;
import org.eclipse.php.composer.api.json.JsonParser;
import org.eclipse.php.composer.api.json.ParseException;

public abstract class JsonEntity
extends Entity {
    private transient Set<String> listening = new HashSet<String>();
    private transient Map<Class, Map<String, Field>> fieldNameCache = new HashMap<Class, Map<String, Field>>();
    private transient Log log = LogFactory.getLog(JsonEntity.class);
    protected transient LinkedList<String> sortOrder = new LinkedList();

    public JsonEntity() {
        this.listen();
        this.initialize();
    }

    protected void initialize() {
    }

    protected void listen() {
        try {
            for (Field field : this.getFields(this.getClass())) {
                if (!JsonCollection.class.isAssignableFrom(field.getType())) continue;
                final String prop = this.getFieldName(field);
                final JsonEntity sender = this;
                if (this.listening.contains(prop)) continue;
                field.setAccessible(true);
                JsonEntity obj = (JsonEntity)field.get(this);
                if (obj == null) continue;
                obj.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        JsonEntity.this.firePropertyChange(String.valueOf(prop) + "." + e.getPropertyName(), e.getOldValue(), e.getNewValue());
                        if (sender instanceof AbstractJsonObject) {
                            try {
                                Method mtd = JsonEntity.class.getDeclaredMethod("appendSortOrder", String.class);
                                mtd.setAccessible(true);
                                mtd.invoke((Object)sender, prop);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                this.listening.add(prop);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    protected ArrayList<Field> getFields(Class entity) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class superClass = entity;
        while (superClass != null) {
            Field[] fieldArray = superClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if ((field.getModifiers() & 0x80) != 128) {
                    fields.add(field);
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return fields;
    }

    protected String getFieldName(Field field) {
        String name = field.getName();
        Annotation[] annotationArray = field.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno.annotationType() == Name.class) {
                name = ((Name)anno).value();
            }
            ++n2;
        }
        return name;
    }

    protected List<String> getFieldNames(Class entity) {
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : this.getFields(entity)) {
            names.add(this.getFieldName(field));
        }
        return names;
    }

    protected Field getFieldByName(Class entity, String fieldName) {
        Map<Object, Object> mapping;
        if (!this.fieldNameCache.containsKey(entity)) {
            mapping = new HashMap();
            for (Field field : this.getFields(entity)) {
                mapping.put(this.getFieldName(field), field);
            }
            this.fieldNameCache.put(entity, mapping);
        }
        if ((mapping = this.fieldNameCache.get(entity)).containsKey(fieldName)) {
            return (Field)mapping.get(fieldName);
        }
        return null;
    }

    protected void appendSortOrder(String name) {
        if (!this.sortOrder.contains(name)) {
            this.sortOrder.add(name);
        }
    }

    protected Object getJsonValue(Object value) {
        if (value instanceof JsonValue) {
            return ((JsonValue)value).toJsonValue();
        }
        if (value instanceof JsonCollection) {
            JsonCollection coll = (JsonCollection)value;
            if (coll.size() > 0) {
                try {
                    Method mtd = JsonEntity.class.getDeclaredMethod("buildJson", new Class[0]);
                    return mtd.invoke((Object)coll, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            return value;
        }
        return null;
    }

    protected abstract void doParse(Object var1);

    private void parse(String json) throws ParseException {
        JsonParser parser = new JsonParser();
        this.doParse(parser.parse(json));
    }

    private void parse(Reader reader) throws IOException, ParseException {
        JsonParser parser = new JsonParser();
        this.doParse(parser.parse(reader));
    }

    public void fromJson(Object json) {
        this.doParse(json);
    }

    public void fromJson(String json) throws ParseException {
        this.parse(json);
    }

    public void fromJson(File file) throws IOException, ParseException {
        if (file.length() > 0L) {
            this.fromJson(new FileReader(file));
        }
    }

    public void fromJson(Reader reader) throws IOException, ParseException {
        this.parse(reader);
    }

    protected abstract Object buildJson();

    public String toJson() {
        return JsonFormatter.format(this.buildJson());
    }
}

