/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.ui.FortranTemplateManager;
import org.eclipse.photran.internal.ui.editor.CompletionUtil;
import org.eclipse.swt.graphics.Image;

public final class FortranTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return FortranTemplateManager.getInstance().getContextTypeRegistry().getContextType("org.eclipse.photran.ui.template.context");
    }

    protected Template[] getTemplates(String contextTypeId) {
        return FortranTemplateManager.getInstance().getTemplateStore().getTemplates();
    }

    protected Image getImage(Template template) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        templates = this.adjustIndentation(templates, viewer, offset);
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block6: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException e) {
                    break block6;
                }
                if (template.matches(prefix, context.getContextType().getId()) && this.templatePatternStartsWith(prefix, template)) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
            }
        });
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            int start = CompletionUtil.findPrefix(document, offset);
            int end = offset;
            return document.get(start, end - start);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private boolean templatePatternStartsWith(String prefix, Template template) {
        String pattern = template.getPattern().replace("$$", "$");
        if (pattern.startsWith("$")) {
            return pattern.substring(pattern.indexOf(125) + 1).trim().startsWith(prefix);
        }
        return pattern.startsWith(prefix);
    }

    private Template[] adjustIndentation(Template[] templates, ITextViewer viewer, int offset) {
        String tabAsSpaces = FortranPreferences.TAB_WIDTH.getStringOfSpaces();
        String currentLineIndentation = this.determineIndentation(viewer, offset);
        Template[] result = new Template[templates.length];
        int i = 0;
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            result[i++] = new Template(t.getName(), t.getDescription(), t.getContextTypeId(), t.getPattern().replace("\t", tabAsSpaces).replace("\n", "\n" + currentLineIndentation), t.isAutoInsertable());
            ++n2;
        }
        return result;
    }

    private String determineIndentation(ITextViewer viewer, int offset) {
        try {
            IDocument doc = viewer.getDocument();
            int startOfLine = doc.getLineOffset(doc.getLineOfOffset(offset));
            StringBuilder prefix = new StringBuilder(doc.get(startOfLine, offset - startOfLine));
            while (prefix.length() > 0 && !prefix.toString().trim().equals("")) {
                prefix.deleteCharAt(prefix.length() - 1);
            }
            return prefix.toString();
        }
        catch (BadLocationException e) {
            return "";
        }
    }
}

