/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

final class CompletionUtil {
    public static int findPrefix(IDocument document, int offset) throws BadLocationException {
        if (offset - 1 >= 0 && document.getChar(offset - 1) == '!') {
            return offset - 1;
        }
        --offset;
        while (offset >= 0) {
            char c = document.getChar(offset);
            if (c == '$' && CompletionUtil.isCommentStart(document, offset - 1)) {
                return offset - 1;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset + 1;
            }
            --offset;
        }
        return 0;
    }

    private static boolean isCommentStart(IDocument document, int offset) throws BadLocationException {
        if (offset < 0 || offset >= document.getLength()) {
            return false;
        }
        char ch = document.getChar(offset);
        if (ch == '!') {
            return true;
        }
        if (ch == 'C' || ch == 'c' || ch == '*') {
            return CompletionUtil.isInColumn1(document, offset);
        }
        return false;
    }

    private static boolean isInColumn1(IDocument document, int offset) throws BadLocationException {
        return document.getLineInformationOfOffset(offset).getOffset() == offset;
    }

    public static int findSuffix(IDocument s, int offset) throws BadLocationException {
        int length = s.getLength();
        while (offset < length) {
            char c = s.getChar(offset);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset;
            }
            ++offset;
        }
        return length;
    }

    private CompletionUtil() {
    }
}

