/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.io;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;

public class EquinoxPaths {
    public static Path resolveInstallConfigurationPath(LicensingConfiguration configuration) {
        URL url = Platform.getInstallLocation().getURL();
        return LicensingPaths.resolveConfigurationPath((URL)url, (LicensingConfiguration)configuration);
    }

    public static Path resolveInstallBasePath() {
        URL url = Platform.getInstallLocation().getURL();
        return LicensingPaths.resolveBasePath((URL)url);
    }

    public static Path extractPath(String property, String value) throws LicensingException {
        String source = EquinoxPaths.class.getName();
        try {
            return Paths.get(URIUtil.fromString((String)value));
        }
        catch (URISyntaxException e) {
            String pattern = EquinoxMessages.EquinoxPaths_uri_retrieval_error;
            String message = NLS.bind((String)pattern, (Object)value, (Object)property);
            LicensingResult result = LicensingResults.createError((String)message, (String)source, (Throwable)e);
            throw new LicensingException(result);
        }
    }
}

