/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.api.access.PermissionEmitter;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.access.FeaturePermissions;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public abstract class BasePermissionEmitter
implements PermissionEmitter {
    public Iterable<FeaturePermission> emitPermissions(LicensingConfiguration configuration, Iterable<LicensingCondition> conditions) throws LicensingException {
        ArrayList<FeaturePermission> result = new ArrayList<FeaturePermission>();
        String source = this.getClass().getName();
        if (conditions == null) {
            String message = BaseMessages.getString("BasePermissionEmitter_prem_emit_error_invalid_consitions");
            IllegalArgumentException e = new IllegalArgumentException();
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
            throw new LicensingException(error);
        }
        for (LicensingCondition condition : conditions) {
            String expression = condition.getConditionExpression();
            Map<String, String> checks = LicensingConditions.parseExpression(expression);
            if (checks.isEmpty()) {
                String message = String.format(BaseMessages.getString("BasePermissionEmitter_prem_emit_error_no_expression_checks"), condition);
                IllegalArgumentException e = new IllegalArgumentException();
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
                throw new LicensingException(error);
            }
            Set<String> keySet = checks.keySet();
            boolean passed = true;
            for (String key : keySet) {
                String value = checks.get(key);
                try {
                    passed = this.evaluateSegment(key, value);
                }
                catch (Exception e) {
                    passed = false;
                    String message = String.format(BaseMessages.getString("BasePermissionEmitter_prem_emit_error_condition_evaluation_error"), condition, key, value);
                    LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
                    throw new LicensingException(error);
                }
                if (passed) continue;
                String message = String.format(BaseMessages.getString("BasePermissionEmitter_prem_emit_error_condition_rejected"), condition, key, value);
                IllegalArgumentException e = new IllegalArgumentException();
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
                throw new LicensingException(error);
            }
            if (!passed) continue;
            result.add(this.createPermission(condition, configuration));
        }
        return result;
    }

    protected FeaturePermission createPermission(LicensingCondition condition, LicensingConfiguration configuration) {
        return FeaturePermissions.createDefault(configuration, condition);
    }

    protected abstract boolean evaluateSegment(String var1, String var2);
}

