/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.tools.util.Suppliers2;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;

public class DecoratorModelReadOnlyHandler
extends AbstractReadOnlyHandler {
    public DecoratorModelReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        if (axes.contains(ReadOnlyAxis.DISCRETION)) {
            ResourceSet rset;
            EditingDomain domain = this.getEditingDomain();
            ResourceSet resourceSet = rset = domain == null ? null : domain.getResourceSet();
            if (rset instanceof ModelSet) {
                Resource resource;
                ArrayList decoratorModels = Lists.newArrayListWithCapacity((int)uris.length);
                Supplier userModelsByDecorator = Suppliers2.eventualSupplier(DecoratorModelIndex.getInstance().getUserModelsByDecoratorAsync(), (Object)ImmutableSetMultimap.of());
                int i = 0;
                while (i < uris.length) {
                    Resource resource2 = rset.getResource(uris[i].trimFragment(), false);
                    if (resource2 != null && resource2.isLoaded() && DecoratorModelUtils.isDecoratorModel(resource2)) {
                        decoratorModels.add(resource2.getURI());
                    } else if (((SetMultimap)userModelsByDecorator.get()).containsKey((Object)uris[i].trimFragment())) {
                        decoratorModels.add(uris[i]);
                    }
                    ++i;
                }
                HashSet userModels = Sets.newHashSet();
                for (URI next : decoratorModels) {
                    resource = rset.getResource(next, false);
                    if (resource != null && resource.isLoaded()) {
                        userModels.addAll(DecoratorModelUtils.getUserModelResources(resource));
                        continue;
                    }
                    userModels.addAll(((SetMultimap)userModelsByDecorator.get()).get((Object)next));
                }
                if (!decoratorModels.isEmpty()) {
                    if (userModels.isEmpty()) {
                        return Optional.of((Object)false);
                    }
                    IReadOnlyHandler2 manager = ((ModelSet)rset).getReadOnlyHandler();
                    if (manager != null) {
                        return manager.anyReadOnly(ReadOnlyAxis.discretionAxes(), (URI[])Iterables.toArray((Iterable)userModels, URI.class));
                    }
                } else {
                    ModelSet mset = (ModelSet)rset;
                    int i2 = 0;
                    while (i2 < uris.length) {
                        resource = mset.getResource(uris[i2], false);
                        if (resource != null && resource.isLoaded()) {
                            Resource root;
                            EObject firstRoot = (EObject)Iterables.getFirst((Iterable)resource.getContents(), null);
                            if (firstRoot != null && (root = EcoreUtil.getRootContainer((EObject)firstRoot).eResource()) != null) {
                                resource = root;
                            }
                            Set<URI> loadedDecorators = DecoratorModelUtils.getLoadedDecoratorModels(resource);
                            boolean isPrincipalUserModel = false;
                            if (!loadedDecorators.isEmpty()) {
                                for (URI next : loadedDecorators) {
                                    isPrincipalUserModel = next.trimFileExtension().equals(mset.getURIWithoutExtension());
                                    if (isPrincipalUserModel) break;
                                }
                            }
                            if (isPrincipalUserModel) {
                                return Optional.of((Object)false);
                            }
                        }
                        ++i2;
                    }
                }
            }
        }
        return Optional.absent();
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        return Optional.absent();
    }
}

