/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingStyledLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndexEvent;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.IDecoratorModelIndexListener;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class DecoratorModelLabelProvider
extends DelegatingStyledLabelProvider
implements IDecoratorModelIndexListener {
    private final ResourceSet resourceSet;
    private volatile Map<URI, String> modelNames;

    public DecoratorModelLabelProvider(ResourceSet resourceSet) {
        super((ILabelProvider)new WorkbenchLabelProvider());
        this.resourceSet = resourceSet;
        DecoratorModelIndex.getInstance().addIndexListener((IDecoratorModelIndexListener)this);
    }

    public DecoratorModelLabelProvider() {
        this(null);
    }

    public void dispose() {
        DecoratorModelIndex.getInstance().removeIndexListener((IDecoratorModelIndexListener)this);
        super.dispose();
    }

    protected Image customGetImage(Object element) {
        URI uri;
        Image result = null;
        if (element instanceof Resource) {
            element = ((Resource)element).getURI();
        }
        if (element instanceof URI && (uri = (URI)element).isPlatformResource()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            result = this.delegatedGetImage(file);
        }
        return result;
    }

    public StyledString customGetStyledText(Object element) {
        return element instanceof IFile ? this.getStyledText((IFile)element) : (element instanceof Resource ? this.getStyledText((Resource)element) : (element instanceof URI ? this.getStyledText((URI)element) : null));
    }

    protected StyledString getStyledText(Resource resource) {
        Package model = resource.isLoaded() ? (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE) : null;
        String modelName = model == null ? this.getModelNames().get(resource.getURI()) : UMLLabelInternationalization.getInstance().getLabel((NamedElement)model);
        return this.getStyledText(modelName, resource.getURI());
    }

    protected StyledString getStyledText(String modelName, URI uri) {
        StyledString result = new StyledString();
        result.append(modelName);
        String qualifier = uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toString();
        result.append(" - " + qualifier, StyledString.QUALIFIER_STYLER);
        return result;
    }

    protected StyledString getStyledText(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return this.getStyledText(uri);
    }

    protected StyledString getStyledText(URI uri) {
        StyledString result;
        Resource resource;
        Resource resource2 = resource = this.resourceSet != null ? this.resourceSet.getResource(uri, false) : null;
        if (resource != null) {
            result = this.getStyledText(resource);
        } else {
            String modelName = this.getModelNames().get(uri);
            if (modelName == null) {
                modelName = uri.trimFileExtension().lastSegment();
            }
            result = this.getStyledText(modelName, uri);
        }
        return result;
    }

    protected final synchronized Map<URI, String> getModelNames() {
        if (this.modelNames == null) {
            final ListenableFuture futureModelNames = DecoratorModelIndex.getInstance().getDecoratorModelNamesAsync();
            if (futureModelNames.isDone()) {
                this.modelNames = (Map)Futures.getUnchecked((Future)futureModelNames);
            } else {
                futureModelNames.addListener(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DecoratorModelLabelProvider decoratorModelLabelProvider = DecoratorModelLabelProvider.this;
                        synchronized (decoratorModelLabelProvider) {
                            DecoratorModelLabelProvider.this.modelNames = (Map)Futures.getUnchecked((Future)futureModelNames);
                            if (DecoratorModelLabelProvider.this.modelNames == null) {
                                DecoratorModelLabelProvider.this.modelNames = Collections.emptyMap();
                            } else {
                                DecoratorModelLabelProvider.this.updateLabels();
                            }
                        }
                    }
                }, (Executor)Activator.getDefault().getExecutorService());
            }
            if (this.modelNames == null) {
                this.modelNames = Collections.emptyMap();
            }
        }
        return this.modelNames;
    }

    public void indexChanged(DecoratorModelIndexEvent event) {
        this.modelNames = null;
        this.updateLabels();
    }

    protected void updateLabels() {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

