/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf.readonly.handlers;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.internal.ControlledResourceTracker;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.ui.internal.emf.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReferencedModelReadOnlyHandler
extends AbstractReadOnlyHandler
implements IReloadContextProvider {
    private final ControlledResourceTracker controlledResourceTracker;
    private final Set<URI> writableReferencedModels = new HashSet<URI>();
    private boolean interactive = true;

    public ReferencedModelReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
        this.controlledResourceTracker = ControlledResourceTracker.getInstance((EditingDomain)editingDomain);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional result = Optional.absent();
        if (axes.contains(ReadOnlyAxis.DISCRETION)) {
            URIConverter converter = this.getEditingDomain().getResourceSet().getURIConverter();
            int i = 0;
            while (i < uris.length) {
                URI next = uris[i].trimFragment();
                if (!this.writableReferencedModels.contains(next.trimFileExtension()) && this.isNotModelSetMainModel(next) && converter.exists(next, null)) {
                    result = Optional.of((Object)true);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional result = Optional.absent();
        if (axes.contains(ReadOnlyAxis.DISCRETION)) {
            int i = 0;
            while (i < uris.length) {
                URI next = uris[i].trimFragment();
                if (!this.isNotModelSetMainModel(next)) {
                    result = Optional.of((Object)false);
                    break;
                }
                result = Optional.of((Object)true);
                ++i;
            }
        }
        return result;
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional result = Optional.absent();
        if (axes.contains(ReadOnlyAxis.DISCRETION)) {
            final ArrayList<URI> toMakeWritable = new ArrayList<URI>(uris.length);
            int i = 0;
            while (i < uris.length) {
                URI next = uris[i].trimFragment();
                if (this.isNotModelSetMainModel(next)) {
                    toMakeWritable.add(next);
                }
                ++i;
            }
            if (!toMakeWritable.isEmpty()) {
                final boolean[] enableWrite = new boolean[]{!this.isInteractive()};
                if (this.isInteractive()) {
                    Display currentDisplay = Display.getCurrent();
                    if (currentDisplay == null) {
                        currentDisplay = Display.getDefault();
                    }
                    currentDisplay.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder message = new StringBuilder(Messages.ReferencedModelReadOnlyHandler_promptMsg);
                            for (URI uri : toMakeWritable) {
                                String path = uri.isPlatformResource() ? uri.toPlatformString(true) : (uri.isFile() ? uri.toFileString() : uri.toString());
                                message.append(path);
                                message.append("\n");
                            }
                            enableWrite[0] = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferencedModelReadOnlyHandler_promptTitle, (String)message.toString());
                        }
                    });
                }
                if (enableWrite[0]) {
                    for (URI next : toMakeWritable) {
                        this.writableReferencedModels.add(next.trimFileExtension());
                        this.fireReadOnlyStateChanged(ReadOnlyAxis.DISCRETION, next, true);
                    }
                }
                result = Optional.of((Object)enableWrite[0]);
            }
        }
        return result;
    }

    protected boolean isNotModelSetMainModel(URI uri) {
        ModelSet modelSet;
        Set<URI> rootURIs;
        boolean result = false;
        ResourceSet rset = this.getEditingDomain().getResourceSet();
        if (rset instanceof ModelSet && !(rootURIs = this.resolveRootResourceURIs(modelSet = (ModelSet)rset, uri)).isEmpty()) {
            URI next = rootURIs.iterator().next();
            result = modelSet.isUserModelResource(next) && !rootURIs.contains(modelSet.getURIWithoutExtension());
        }
        return result;
    }

    protected Set<URI> resolveRootResourceURIs(ModelSet modelSet, URI uri) {
        return this.controlledResourceTracker.getRootResourceURIs(uri);
    }

    public Object createReloadContext() {
        return this.writableReferencedModels;
    }

    public void restore(Object reloadContext) {
        this.writableReferencedModels.addAll((Set)reloadContext);
    }
}

