/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Set;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class AxisUtils {
    public static final String REGEX = "[^\\w\\s]";

    private AxisUtils() {
    }

    public static final String getPropertyId(Object axisElement) {
        String id = null;
        if (axisElement instanceof IdAxis) {
            id = ((IdAxis)axisElement).getElement();
        } else if (axisElement instanceof String) {
            id = (String)axisElement;
        }
        return id;
    }

    public static final Object getRepresentedElement(Object axisElement) {
        Object representedElement = axisElement instanceof IAxis ? ((IAxis)axisElement).getElement() : axisElement;
        return representedElement;
    }

    public static final AbstractAxisProvider getAxisProviderUsedForRows(Table table) {
        AbstractAxisProvider provider = table.getCurrentRowAxisProvider();
        if (table.isInvertAxis()) {
            provider = table.getCurrentColumnAxisProvider();
        }
        return provider;
    }

    public static final AbstractAxisProvider getAxisProviderUsedForColumns(Table table) {
        AbstractAxisProvider provider = table.getCurrentColumnAxisProvider();
        if (table.isInvertAxis()) {
            provider = table.getCurrentRowAxisProvider();
        }
        return provider;
    }

    public static final AbstractAxisProvider getAxisProviderUsedForRows(INattableModelManager manager) {
        return AxisUtils.getAxisProviderUsedForRows(manager.getTable());
    }

    public static final AbstractAxisProvider getAxisProviderUsedForColumns(INattableModelManager manager) {
        return AxisUtils.getAxisProviderUsedForColumns(manager.getTable());
    }

    public static int getUniqueSelectedAxisIndex(INattableModelManager nattableManager) {
        TableSelectionWrapper tableSelectionWrapper;
        int axisIndex = -1;
        if (nattableManager != null && (tableSelectionWrapper = (TableSelectionWrapper)nattableManager.getAdapter(TableSelectionWrapper.class)) != null && nattableManager.getTable() != null) {
            Table table = nattableManager.getTable();
            int numSelectedAxis = 0;
            Set<Integer> keySet = null;
            if (table.isInvertAxis()) {
                numSelectedAxis = tableSelectionWrapper.getFullySelectedRows().size();
                keySet = tableSelectionWrapper.getFullySelectedRows().keySet();
            } else {
                numSelectedAxis = tableSelectionWrapper.getFullySelectedColumns().size();
                keySet = tableSelectionWrapper.getFullySelectedColumns().keySet();
            }
            if (1 == numSelectedAxis) {
                axisIndex = (Integer)keySet.toArray()[0];
            }
        }
        return axisIndex;
    }
}

