/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.menu;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.papyrus.infra.nattable.menu.MenuUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;

public class AbstractPapyrusPopupMenuAction
implements IMouseAction,
IMenuListener {
    protected final String menuId;
    protected final String menuLocation;
    protected final MenuManager menuManager;
    protected final Menu menu;
    protected final NatTable natTable;

    public AbstractPapyrusPopupMenuAction(String menuId, NatTable natTable) {
        this.menuId = menuId;
        this.menuLocation = "popup" + ":" + menuId;
        this.menuManager = new MenuManager("popup", this.menuId);
        this.natTable = natTable;
        this.menu = this.menuManager.createContextMenu((Control)this.natTable);
        this.menuManager.setRemoveAllWhenShown(true);
        this.addMenuListener((IMenuManager)this.menuManager);
    }

    protected void addMenuListener(IMenuManager menuManager) {
        menuManager.addMenuListener((IMenuListener)this);
    }

    public void run(NatTable natTable, MouseEvent event) {
        if (event == null) {
            return;
        }
        Object data = event.data;
        NatEventData natEventData = data instanceof NatEventData ? (NatEventData)data : null;
        Assert.isNotNull((Object)natEventData, (String)"The natEventData is null");
        this.menu.setData("natEventData", (Object)natEventData);
        this.menu.setVisible(true);
    }

    protected void addMenuSeparators(IMenuManager menuManager) {
        Separator general = new Separator("general.separator");
        general.setVisible(false);
        menuManager.add((IContributionItem)general);
        Separator edit = new Separator("edit.separator");
        edit.setVisible(true);
        menuManager.add((IContributionItem)edit);
    }

    public final void menuAboutToShow(IMenuManager menuManager) {
        this.addMenuSeparators(menuManager);
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        NatEventData natEventData = (NatEventData)this.menuManager.getMenu().getData("natEventData");
        MenuUtils.registerNatTableWidgetInEclipseContext(natEventData);
        if (menuService != null && menuManager instanceof MenuManager) {
            menuService.populateContributionManager((ContributionManager)((MenuManager)menuManager), this.menuLocation);
        }
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
    }
}

