/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.papyrus.infra.nattable.command.UpdateFilterMapCommand;
import org.eclipse.papyrus.infra.nattable.layer.FilterRowDataLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;

public class FilterRowHeaderComposite<T>
extends CompositeLayer {
    private final FilterRowDataLayer<T> filterRowDataLayer;
    private boolean filterRowVisible = true;

    public FilterRowHeaderComposite(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, INattableModelManager tableManager) {
        super(1, 2);
        this.setChildLayer("columnHeader", columnHeaderLayer, 0, 0);
        this.filterRowDataLayer = new FilterRowDataLayer<T>(filterStrategy, columnHeaderLayer, columnHeaderDataProvider, tableManager);
        DimensionallyDependentLayer filterRowLayer = new DimensionallyDependentLayer(this.filterRowDataLayer, columnHeaderLayer, this.filterRowDataLayer);
        this.setChildLayer("FILTER_ROW", (ILayer)filterRowLayer, 0, 1);
    }

    public FilterRowDataLayer<T> getFilterRowDataLayer() {
        return this.filterRowDataLayer;
    }

    public int getHeight() {
        if (this.filterRowVisible) {
            return super.getHeight();
        }
        return this.getHeightOffset(1);
    }

    public int getRowCount() {
        if (this.filterRowVisible) {
            return super.getRowCount();
        }
        return super.getRowCount() - 1;
    }

    public boolean isFilterRowVisible() {
        return this.filterRowVisible;
    }

    public void setFilterRowVisible(boolean filterRowVisible) {
        this.filterRowVisible = filterRowVisible;
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent(this.filterRowDataLayer));
    }

    public boolean doCommand(ILayerCommand command) {
        if (command instanceof UpdateFilterMapCommand) {
            this.filterRowDataLayer.getFilterRowDataProvider().updateMapValue(((UpdateFilterMapCommand)command).getColumnIndexToUpdate());
            return true;
        }
        if (command instanceof ToggleFilterRowCommand) {
            this.setFilterRowVisible(!this.filterRowVisible);
            return true;
        }
        return super.doCommand(command);
    }
}

