/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dataprovider;

import org.eclipse.papyrus.infra.nattable.dataprovider.AbstractIndexHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisIndexStyle;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class RowIndexHeaderDataProvider
extends AbstractIndexHeaderDataProvider {
    public RowIndexHeaderDataProvider(INattableModelManager tableModelManager) {
        super(tableModelManager);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AbstractHeaderAxisConfiguration getAxisConfiguration() {
        return HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.manager.getTable());
    }

    @Override
    public int getColumnCount() {
        if (this.displayIndex) {
            return 1;
        }
        return 0;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        if (this.style == AxisIndexStyle.NUMERIC && this.displayIndexWithDepth() && TableHelper.isTreeTable(this.manager)) {
            return this.getTreeRowIndex(rowIndex);
        }
        return this.getAxisIndex(rowIndex);
    }

    protected boolean displayIndexWithDepth() {
        return false;
    }

    private Object getTreeRowIndex(int rowIndex) {
        ITreeItemAxis axis = (ITreeItemAxis)this.manager.getRowElementsList().get(rowIndex);
        StringBuilder builder = new StringBuilder();
        ITreeItemAxis parent = axis;
        while (parent != null) {
            ITreeItemAxis p = parent.getParent();
            if (p != null) {
                int index = p.getChildren().indexOf((Object)parent);
                builder.append(index);
                builder.append(".");
            } else {
                builder.append("1");
            }
            parent = p;
        }
        return builder.reverse().toString();
    }
}

