/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ICellEditorsRegistry;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCellsEditingSupport<T>
extends EditingSupport {
    private final EStructuralFeature feature;
    private final IModelCellEditor cellEditor;
    private final EObject eObject;
    private final ColumnViewer columnViewer;
    private final Object newValuePlaceholder;
    private List<T> values;

    public ModelCellsEditingSupport(ColumnViewer columnViewer, EStructuralFeature feature, EObject eObject, Object newValuePlaceholder, List<T> values) {
        super(columnViewer);
        this.columnViewer = columnViewer;
        this.feature = feature;
        this.eObject = eObject;
        this.values = values;
        this.newValuePlaceholder = newValuePlaceholder;
        this.cellEditor = ICellEditorsRegistry.INSTANCE.getCellEditorFor(this.feature.getEType());
        if (this.cellEditor == null) {
            throw new IllegalStateException("no cell editor found for " + this.feature.getEType().getName());
        }
    }

    protected CellEditor getCellEditor(final Object element) {
        return new CellEditor((Composite)this.columnViewer.getControl()){
            private Control control;

            protected void doSetValue(Object value) {
            }

            protected void doSetFocus() {
                this.control.setFocus();
            }

            protected Object doGetValue() {
                return null;
            }

            protected Control createControl(Composite parent) {
                IModelCellEditHandler editHandler = new IModelCellEditHandler(){

                    public void commit() {
                        Object value = ModelCellsEditingSupport.this.cellEditor.getValue();
                        int index = ModelCellsEditingSupport.this.values.indexOf(element);
                        if (index != -1 || element == ModelCellsEditingSupport.this.newValuePlaceholder) {
                            ModelCellsEditingSupport.this.values.set(index, value);
                        }
                        this.close();
                        ModelCellsEditingSupport.this.columnViewer.refresh();
                    }
                };
                Object originalValue = null;
                if (element != ModelCellsEditingSupport.this.newValuePlaceholder) {
                    originalValue = element;
                }
                this.control = ModelCellsEditingSupport.this.cellEditor.activateCell(parent, originalValue, editHandler, ModelCellsEditingSupport.this.feature, ModelCellsEditingSupport.this.eObject);
                return this.control;
            }

            public void close() {
                this.deactivate();
                Control parentControl = ModelCellsEditingSupport.this.columnViewer.getControl();
                if (parentControl != null && !parentControl.isDisposed()) {
                    parentControl.forceFocus();
                }
                this.dispose();
            }
        };
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        return element;
    }

    protected void setValue(Object element, Object value) {
    }
}

