/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetUIUtils {
    public static Set<? extends ETypedElement> getETypedElements(ResourceSet resourceSet) {
        HashSet<Object> result = new HashSet<Object>();
        Collection ePackages = EPackage.Registry.INSTANCE.values();
        for (Object object : ePackages) {
            EPackage ePackage = null;
            if (object instanceof EPackage) {
                ePackage = (EPackage)object;
            } else if (object instanceof EPackage.Descriptor) {
                EPackage.Descriptor descriptor = (EPackage.Descriptor)object;
                ePackage = descriptor.getEPackage();
            }
            if (ePackage == null) continue;
            result.addAll(FacetUIUtils.getETypedElements(ePackage));
        }
        result.addAll(FacetUIUtils.getFacetETypedElements(resourceSet));
        return result;
    }

    public static Set<? extends ETypedElement> getFacetETypedElements(ResourceSet resourceSet) {
        HashSet<ETypedElement> result = new HashSet<ETypedElement>();
        Collection facetSets = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet).getRegisteredFacetSets();
        for (FacetSet facetSet : facetSets) {
            result.addAll(FacetUIUtils.getETypedElements((EPackage)facetSet));
        }
        return result;
    }

    public static List<ETypedElement> getETypedElements(EPackage ePackage) {
        ArrayList<ETypedElement> result = new ArrayList<ETypedElement>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            result.addAll(FacetUIUtils.getETypedElements(eClassifier));
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(FacetUIUtils.getETypedElements(subPackage));
        }
        return result;
    }

    public static List<ETypedElement> getETypedElements(EClassifier eClassifier) {
        ArrayList<ETypedElement> result = new ArrayList<ETypedElement>();
        if (eClassifier instanceof Facet) {
            Facet facet = (Facet)eClassifier;
            result.addAll((Collection<ETypedElement>)facet.getFacetElements());
            result.addAll((Collection<ETypedElement>)facet.getFacetOperations());
        } else if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            result.addAll((Collection<ETypedElement>)eClass.getEAllStructuralFeatures());
            result.addAll((Collection<ETypedElement>)eClass.getEAllOperations());
        }
        return result;
    }
}

