/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util.internal.pde;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.internal.pde.UtilPDEPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;

public class TargetPlatformPluginLocation
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String element) throws CoreException {
        try {
            if (!StringUtil.isEmpty((String)element)) {
                TargetBundle[] bundles;
                int pos = element.lastIndexOf(95);
                String id = pos == -1 ? element : element.substring(0, pos);
                String version = pos == -1 ? null : element.substring(pos + 1);
                ITargetDefinition targetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
                if (!targetDefinition.isResolved()) {
                    targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
                }
                if ((bundles = targetDefinition.getAllBundles()) != null) {
                    TargetBundle[] targetBundleArray = bundles;
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String scheme;
                        URI location;
                        TargetBundle bundle = targetBundleArray[n2];
                        BundleInfo info = bundle.getBundleInfo();
                        if (info != null && info.getSymbolicName().equals(id) && (version == null || version.equals(info.getVersion())) && (location = info.getLocation()) != null && "file".equals(scheme = location.getScheme())) {
                            File file = new File(location.getPath());
                            return file.getAbsolutePath();
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception ex) {
            UtilPDEPlugin.INSTANCE.coreException(ex);
        }
        return null;
    }
}

