/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.cst.BooleanLiteralExpCS;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CallExpCS;
import org.eclipse.ocl.cst.ClassifierContextDeclCS;
import org.eclipse.ocl.cst.CollectionLiteralExpCS;
import org.eclipse.ocl.cst.CollectionLiteralPartCS;
import org.eclipse.ocl.cst.CollectionRangeCS;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.CollectionTypeIdentifierEnum;
import org.eclipse.ocl.cst.ContextDeclCS;
import org.eclipse.ocl.cst.DefCS;
import org.eclipse.ocl.cst.DefExpressionCS;
import org.eclipse.ocl.cst.DerValueCS;
import org.eclipse.ocl.cst.FeatureCallExpCS;
import org.eclipse.ocl.cst.IfExpCS;
import org.eclipse.ocl.cst.InitOrDerValueCS;
import org.eclipse.ocl.cst.InitValueCS;
import org.eclipse.ocl.cst.IntegerLiteralExpCS;
import org.eclipse.ocl.cst.InvCS;
import org.eclipse.ocl.cst.InvOrDefCS;
import org.eclipse.ocl.cst.InvalidLiteralExpCS;
import org.eclipse.ocl.cst.IsMarkedPreCS;
import org.eclipse.ocl.cst.IterateExpCS;
import org.eclipse.ocl.cst.IteratorExpCS;
import org.eclipse.ocl.cst.LetExpCS;
import org.eclipse.ocl.cst.LiteralExpCS;
import org.eclipse.ocl.cst.LoopExpCS;
import org.eclipse.ocl.cst.MessageExpCS;
import org.eclipse.ocl.cst.MessageExpKind;
import org.eclipse.ocl.cst.NullLiteralExpCS;
import org.eclipse.ocl.cst.OCLDocumentCS;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.OCLMessageArgCS;
import org.eclipse.ocl.cst.OperationCS;
import org.eclipse.ocl.cst.OperationCallExpCS;
import org.eclipse.ocl.cst.OperationContextDeclCS;
import org.eclipse.ocl.cst.PackageDeclarationCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.PrePostOrBodyDeclCS;
import org.eclipse.ocl.cst.PrimitiveLiteralExpCS;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.PropertyContextCS;
import org.eclipse.ocl.cst.RealLiteralExpCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.SimpleTypeEnum;
import org.eclipse.ocl.cst.StringLiteralExpCS;
import org.eclipse.ocl.cst.TupleLiteralExpCS;
import org.eclipse.ocl.cst.TupleTypeCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.cst.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CallExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NavigationCallExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractAnalyzer;
import org.eclipse.ocl.lpg.BasicEnvironment2;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.parser.AbstractOCLParser;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractAnalyzer {
    public static final String OCL_ANNOTATIONS_URI = "http://www.eclipse.org/ocl/1.1.0/OCL/Annotations";
    private static final String OCL_ESCAPE_PREFIX = "_";
    private static final int OCL_ESCAPE_LENGTH = "_".length();
    public static final String IMPLICIT_SET_CONVERSION = "IMPLICIT_SET_CONVERSION";
    protected OCLFactory oclFactory;
    protected UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml;
    protected final EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environmentFactory;

    public AbstractOCLAnalyzer(AbstractOCLParser parser) {
        super(parser);
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = this.getOCLEnvironment();
        this.environmentFactory = env.getFactory();
        this.oclFactory = this.createOCLFactory(env);
        this.uml = env.getUMLReflection();
    }

    protected OCLFactory createOCLFactory(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return env.getOCLFactory();
    }

    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getOCLEnvironment() {
        return this.getEnvironment().getAdapter(Environment.class);
    }

    @Override
    public AbstractOCLParser getAbstractParser() {
        return (AbstractOCLParser)super.getParser();
    }

    @Override
    public AbstractOCLParser getParser() {
        return this.getAbstractParser();
    }

    protected C getBoolean() {
        return this.getStandardLibrary().getBoolean();
    }

    protected C getOclVoid() {
        return this.getStandardLibrary().getOclVoid();
    }

    protected OCLStandardLibrary<C> getStandardLibrary() {
        return this.getOCLEnvironment().getOCLStandardLibrary();
    }

    public static boolean isIdentifierOrKeyword(int tokenKind) {
        switch (tokenKind) {
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                return true;
            }
        }
        return false;
    }

    protected String operationString(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String operName, List<? extends TypedElement<C>> args) {
        StringBuilder result = new StringBuilder();
        result.append(operName);
        result.append('(');
        Iterator<TypedElement<C>> iter = args.iterator();
        while (iter.hasNext()) {
            TypedElement<C> arg = iter.next();
            C type = arg.getType();
            result.append(type == null ? null : this.uml.getName(type));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    protected void setQualifiers(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String rule, NavigationCallExp<C, P> nc, List<OCLExpression<C>> qualifiers) {
        if (nc instanceof PropertyCallExp) {
            Object source = ((PropertyCallExp)nc).getReferredProperty();
            List<P> expectedQualifiers = this.uml.getQualifiers(source);
            if (expectedQualifiers.size() != qualifiers.size()) {
                this.ERROR(qualifiers, rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
                return;
            }
            if (!qualifiers.isEmpty()) {
                Object ncType;
                int iQualifierMax = expectedQualifiers.size();
                int iQualifier = 0;
                while (iQualifier < iQualifierMax) {
                    Object qualifierType;
                    P expectedQualifier = expectedQualifiers.get(iQualifier);
                    OCLExpression<C> qualifier = qualifiers.get(iQualifier);
                    C expectedType = this.getOCLType(env, expectedQualifier);
                    if (!TypeUtil.compatibleTypeMatch(env, expectedType, qualifierType = qualifier.getType())) {
                        this.ERROR(qualifier, rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
                    }
                    ++iQualifier;
                }
                if (this.uml.isMany(source) && (ncType = nc.getType()) instanceof CollectionType) {
                    CollectionType ct = (CollectionType)ncType;
                    nc.setType(ct.getElementType());
                }
            }
        } else if (nc instanceof AssociationClassCallExp) {
            if (qualifiers.size() != 1) {
                this.ERROR(qualifiers, rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierCount_ERROR_, nc.toString()));
            }
            if (qualifiers.isEmpty()) {
                return;
            }
            OCLExpression<C> qualifier = qualifiers.get(0);
            if (!(qualifier instanceof PropertyCallExp)) {
                this.ERROR(qualifier, rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            } else {
                AssociationClassCallExp acc = (AssociationClassCallExp)nc;
                Object assocClass = acc.getReferredAssociationClass();
                Object sourceType = this.getElementType(nc.getSource().getType());
                Object property = ((PropertyCallExp)qualifier).getReferredProperty();
                if (property != null) {
                    C refAssocClass = this.uml.getAssociationClass(property);
                    if (refAssocClass == null) {
                        this.ERROR(qualifier, rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
                    } else if (this.uml.getAttributes(sourceType).contains(property) && refAssocClass == assocClass) {
                        acc.setNavigationSource(property);
                        CollectionKind kind = this.getCollectionKind(this.getOCLType(env, property));
                        if (kind != null) {
                            acc.setType(this.getCollectionType(null, env, kind, assocClass));
                        } else {
                            acc.setType(assocClass);
                        }
                    } else {
                        this.ERROR(qualifier, rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
                    }
                }
            }
        }
        nc.getQualifier().addAll(qualifiers);
    }

    protected void checkNotReflexive(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String rule, AssociationClassCallExp<C, P> acc) {
        C assocClass = acc.getReferredAssociationClass();
        List<Object> ends = this.uml.isAssociationClass(assocClass) ? this.uml.getMemberEnds(assocClass) : Collections.emptyList();
        if (ends.size() == 2) {
            Object end1 = ends.get(0);
            Object end2 = ends.get(1);
            if (TypeUtil.getPropertyType(env, assocClass, end1) == TypeUtil.getPropertyType(env, assocClass, end2)) {
                this.ERROR(acc, rule, OCLMessages.bind(OCLMessages.AssociationClassAmbiguous_ERROR_, acc.toString()));
            }
        }
    }

    protected Variable<C, PM> genVariableDeclaration(CSTNode cstNode, String rule, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String name, C type, OCLExpression<C> initExp, boolean explicitFlag, boolean addToEnvironment, boolean isSelf) {
        Variable vdcl = this.oclFactory.createVariable();
        this.initASTMapping(env, vdcl, cstNode);
        vdcl.setName(name);
        vdcl.setType(TypeUtil.resolveType(env, type));
        vdcl.setInitExpression(initExp);
        if (addToEnvironment) {
            boolean result = env.addElement(name, vdcl, explicitFlag);
            if (!result) {
                if (name != null) {
                    String message = OCLMessages.bind(OCLMessages.VariableUsed_ERROR_, name);
                    this.ERROR(cstNode, rule, message);
                } else {
                    this.ERROR(cstNode, rule, OCLMessages.VariableDeclaration_ERROR_);
                }
            }
            if (isSelf) {
                env.setSelfVariable(vdcl);
            }
        }
        if (addToEnvironment) {
            this.TRACE(rule, "adding variable declaration for " + vdcl.getName());
        }
        return vdcl;
    }

    protected OperationCallExp<C, O> genOperationCallExp(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OperationCallExpCS operationCallExpCS, String rule, String operName, OCLExpression<C> source, C ownerType, List<OCLExpression<C>> args) {
        OperationCallExp<C, O> result = this.oclFactory.createOperationCallExp();
        this.initASTMapping(env, result, operationCallExpCS);
        result.setSource(source);
        O oper = this.lookupOperation(operationCallExpCS.getSimpleNameCS(), env, ownerType, operName, args);
        String resolvedName = operName;
        if (oper == null) {
            String message = OCLMessages.bind(OCLMessages.OperationNotFound_ERROR_, this.operationString(env, operName, args), ownerType == null ? null : this.uml.getName(ownerType));
            this.ERROR(operationCallExpCS, rule, message);
            result.setType(env.getOCLStandardLibrary().getOclVoid());
        } else {
            resolvedName = this.uml.getName(oper);
            this.TRACE(rule, resolvedName);
            result.setReferredOperation(oper);
        }
        EList callargs = result.getArgument();
        if (args != null) {
            for (OCLExpression<C> arg : args) {
                if (arg == null) {
                    this.ERROR(operationCallExpCS, rule, OCLMessages.BadArg_ERROR_);
                    continue;
                }
                callargs.add(arg);
            }
        }
        if (oper != null) {
            Object resultType = null;
            int opcode = 0;
            C oclOwnerType = this.uml.getOCLType(ownerType);
            if (TypeUtil.isStandardLibraryFeature(env, oclOwnerType, oper)) {
                opcode = OCLStandardLibraryUtil.getOperationCode(resolvedName);
            } else if (TypeUtil.isOclAnyOperation(env, oper)) {
                opcode = OCLStandardLibraryUtil.getOclAnyOperationCode(resolvedName);
            }
            result.setOperationCode(opcode);
            resultType = TypeUtil.getResultType(operationCallExpCS, env, ownerType, oper, args);
            if (resultType == null) {
                resultType = this.getOCLType(env, oper);
            }
            resultType = TypeUtil.resolveType(env, resultType);
            result.setType(resultType);
        }
        return result;
    }

    protected void documentCS(OCLDocumentCS documentCS, List<CT> constraints) {
        for (PackageDeclarationCS decl : documentCS.getPackageDeclarations()) {
            this.packageDeclarationCS(decl, constraints);
        }
    }

    protected void packageDeclarationCS(PackageDeclarationCS packageDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) {
        EList<String> pathname;
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> packageEnv;
        PathNameCS pathNameCS = packageDeclarationCS.getPathNameCS();
        if (pathNameCS == null) {
            packageEnv = env;
            pathname = ECollections.emptyEList();
            this.initASTMapping(packageEnv, this.createDummyPackage(env, packageDeclarationCS), packageDeclarationCS);
        } else {
            pathname = AbstractOCLAnalyzer.createSequenceOfNames(pathNameCS, null);
            try {
                packageEnv = this.createPackageContext(this.getOCLEnvironment(), (List<String>)pathname);
                if (packageEnv != null) {
                    PK contextPackage = packageEnv.getContextPackage();
                    this.initASTMapping(packageEnv, contextPackage, packageDeclarationCS);
                    pathNameCS.setAst(contextPackage);
                }
            }
            catch (LookupException e) {
                this.ERROR(pathNameCS, "packageDeclarationCS", e.getMessage());
                return;
            }
            if (packageEnv == null) {
                this.ERROR(pathNameCS, "packageDeclarationCS", OCLMessages.bind(OCLMessages.PackageNotFound_ERROR_, this.makeString(pathname)));
                return;
            }
        }
        this.TRACE("packageDeclarationCS", "Package ", pathname);
        EList<ContextDeclCS> contextDecls = packageDeclarationCS.getContextDecls();
        for (ContextDeclCS decl : contextDecls) {
            this.contextDeclCS(decl, packageEnv, constraints);
        }
    }

    protected void packageDeclarationCS(PackageDeclarationCS packageDeclarationCS, List<CT> constraints) {
        this.packageDeclarationCS(packageDeclarationCS, this.getOCLEnvironment(), constraints);
    }

    protected void contextDeclCS(ContextDeclCS contextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) {
        if (contextDeclCS instanceof OperationContextDeclCS) {
            this.operationContextDeclCS((OperationContextDeclCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof PropertyContextCS) {
            this.propertyContextCS((PropertyContextCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof ClassifierContextDeclCS) {
            this.classifierContextDeclCS((ClassifierContextDeclCS)contextDeclCS, env, constraints);
        }
    }

    protected void operationContextDeclCS(OperationContextDeclCS operationContextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) {
        env = this.operationCS(operationContextDeclCS.getOperationCS(), env);
        if (env != null) {
            for (PrePostOrBodyDeclCS decl : operationContextDeclCS.getPrePostOrBodyDecls()) {
                CT astNode = this.prePostOrBodyDeclCS(env, decl);
                if (astNode == null) continue;
                constraints.add(astNode);
            }
        }
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> operationCS(OperationCS operationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        C opType2;
        O operation = null;
        C classifier = null;
        EList<String> className = AbstractOCLAnalyzer.createSequenceOfNames(operationCS.getPathNameCS(), null);
        String operationName = operationCS.getSimpleNameCS().getValue();
        BasicEList qualifiedOperationName = new BasicEList();
        qualifiedOperationName.addAll(className);
        qualifiedOperationName.add((Object)operationName);
        EList<VariableCS> parametersCS = operationCS.getParameters();
        if (className.size() > 0 && (classifier = (C)this.lookupClassifier(operationCS.getPathNameCS(), env, (List<String>)className)) != null) {
            if ((env = this.environmentFactory.createClassifierContext(env, classifier)).lookupLocal("self") == null) {
                this.genVariableDeclaration(operationCS, "operationCS", env, "self", classifier, null, true, true, true);
            }
            List<Variable<Object, PM>> contextParms = this.parametersCS((List<VariableCS>)parametersCS, env);
            operation = this.lookupOperation(operationCS, env, classifier, operationName, contextParms);
            operationCS.getSimpleNameCS().setAst(operation);
            if (operation == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)qualifiedOperationName));
                this.ERROR(operationCS, "operationContextDeclCS", message);
                return null;
            }
        }
        if (operation == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)qualifiedOperationName));
            this.ERROR(operationCS, "operationContextDeclCS", message);
            return null;
        }
        TypeCS operationTypeCS = operationCS.getTypeCS();
        C opType1 = operationTypeCS != null ? this.typeCS(operationTypeCS, env) : this.getOclVoid();
        if (!TypeUtil.compatibleTypeMatch(env, opType1, opType2 = this.uml.getOCLType(operation))) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceOperation_ERROR_, this.makeString((EList<String>)qualifiedOperationName));
            this.ERROR(operationCS, "operationContextDeclCS", message);
            return null;
        }
        this.TRACE("operationCS", "context", (EList<String>)qualifiedOperationName);
        return this.createOperationContext(env, (OperationContextDeclCS)operationCS.eContainer(), operation);
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOperationContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OperationContextDeclCS operationContextCS, O operation) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result;
        if (operationContextCS != null) {
            operationContextCS.setAst(operation);
        }
        if ((result = this.environmentFactory.createOperationContext(env, operation)).lookupLocal("self") == null) {
            this.genVariableDeclaration(operationContextCS, "operationContextDeclCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        if (operationContextCS != null) {
            EList<VariableCS> contextParms = operationContextCS.getOperationCS().getParameters();
            List<PM> parms = this.uml.getParameters(operation);
            int i = 0;
            while (i < parms.size()) {
                String innateParmName;
                String contextParmName = ((VariableCS)contextParms.get(i)).getName();
                if (!contextParmName.equals(innateParmName = this.uml.getName(parms.get(i)))) {
                    Variable<C, PM> var = result.lookupLocal(innateParmName);
                    result.deleteElement(innateParmName);
                    var.setName(contextParmName);
                    result.addElement(contextParmName, var, true);
                }
                ++i;
            }
        }
        return result;
    }

    protected List<Variable<C, PM>> parametersCS(List<VariableCS> parameters, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return this.variableDeclarationListCS(parameters, env, false);
    }

    protected CT prePostOrBodyDeclCS(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, PrePostOrBodyDeclCS prePostOrBodyDeclCS) {
        CT astNode;
        ExpressionInOCL<C, PM> spec = this.createExpressionInOCL();
        this.initASTMapping(env, spec, prePostOrBodyDeclCS, null);
        O operation = env.getContextOperation();
        OperationContextDeclCS operationContext = (OperationContextDeclCS)prePostOrBodyDeclCS.eContainer();
        env = this.createOperationContext(env, operationContext, operation);
        Variable<C, PM> selfVar = env.getSelfVariable();
        spec.setContextVariable(selfVar);
        C operationType = this.getOCLType(env, operation);
        if (operationType instanceof VoidType) {
            operationType = null;
        }
        String stereotype = null;
        Variable<C, PM> resultVar = null;
        switch (prePostOrBodyDeclCS.getKind().getValue()) {
            case 1: {
                stereotype = "precondition";
                break;
            }
            case 2: {
                stereotype = "postcondition";
                if (operationType == null || env.lookupLocal("result") != null) break;
                resultVar = this.genVariableDeclaration(null, "prePostOrBodyDeclCS0", env, "result", operationType, null, true, true, false);
                this.initASTMapping(env, resultVar, prePostOrBodyDeclCS, null);
                spec.setResultVariable(resultVar);
                break;
            }
            case 3: {
                stereotype = "body";
                if (operationType == null || env.lookupLocal("result") != null) break;
                resultVar = this.genVariableDeclaration(null, "prePostOrBodyDeclCS", env, "result", operationType, null, true, true, false);
                this.initASTMapping(env, resultVar, prePostOrBodyDeclCS, null);
                spec.setResultVariable(resultVar);
            }
        }
        try {
            OCLExpression<C> oclExpression = this.oclExpressionCS(prePostOrBodyDeclCS.getExpressionCS(), env);
            astNode = this.createConstraint();
            this.initASTMapping(env, astNode, prePostOrBodyDeclCS);
            SimpleNameCS simpleNameCS = prePostOrBodyDeclCS.getSimpleNameCS();
            if (simpleNameCS != null) {
                this.uml.setConstraintName(astNode, simpleNameCS.getValue());
                simpleNameCS.setAst(astNode);
            }
            this.uml.addConstrainedElement(astNode, (EObject)operation);
            C owner = this.uml.getOwningClassifier(operation);
            Object selfVarType = selfVar.getType();
            if (owner != selfVarType) {
                ProblemHandler.Severity sev;
                this.uml.addConstrainedElement(astNode, (EObject)selfVarType);
                if (operationContext != null && !(sev = this.getEnvironment().getValue(ProblemOption.INHERITED_FEATURE_CONTEXT)).isOK()) {
                    this.getEnvironment().problem(sev, ProblemHandler.Phase.ANALYZER, OCLMessages.bind(OCLMessages.NonStd_InheritedFeatureContext_, this.formatQualifiedName(owner), this.formatName(operation)), "prePostOrBodyDeclCS", null);
                }
            }
            spec.setBodyExpression(oclExpression);
            List<PM> parameters = this.uml.getParameters(operation);
            Collection<Variable<C, PM>> vars = env.getVariables();
            for (Variable<C, PM> var : vars) {
                if (!parameters.contains(var.getRepresentedParameter())) continue;
                spec.getParameterVariable().add(var);
                this.initASTMapping(env, var, prePostOrBodyDeclCS);
            }
            this.uml.setSpecification(astNode, spec);
            this.uml.setStereotype(astNode, stereotype);
            if ("body".equals(stereotype)) {
                env.setBodyCondition(operation, astNode);
            }
        }
        finally {
            if (resultVar != null) {
                env.deleteElement("result");
            }
        }
        return astNode;
    }

    protected P propertyContextCS(PropertyContextCS propertyContextCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) {
        EList<String> pathName = AbstractOCLAnalyzer.createSequenceOfNames(propertyContextCS.getPathNameCS(), null);
        C owner = this.lookupClassifier(propertyContextCS.getPathNameCS(), env, (List<String>)pathName);
        if (owner == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR(propertyContextCS, "propertyContextCS", message);
            return null;
        }
        owner = this.uml.asOCLType(owner);
        env = this.environmentFactory.createClassifierContext(env, owner);
        SimpleNameCS simplenameCS = propertyContextCS.getSimpleNameCS();
        String simpleName = simplenameCS.getValue();
        P property = this.lookupProperty(simplenameCS, env, owner, simpleName);
        propertyContextCS.setAst(property);
        BasicEList propertyName = new BasicEList();
        propertyName.addAll(pathName);
        propertyName.add((Object)simpleName);
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)propertyName));
            this.ERROR(propertyContextCS, "propertyContextCS", message);
            return null;
        }
        C type = this.typeCS(propertyContextCS.getTypeCS(), env);
        C propertyType = this.getPropertyType(simplenameCS, env, owner, property);
        if (type == null || !TypeUtil.exactTypeMatch(env, propertyType, type)) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)propertyName));
            this.ERROR(propertyContextCS.getTypeCS(), "propertyContextCS", message);
        }
        this.TRACE("propertyContextCS", "context", (EList<String>)propertyName);
        env = this.environmentFactory.createAttributeContext(env, property);
        InitValueCS initCS = null;
        DerValueCS derCS = null;
        for (InitOrDerValueCS initOrDerValueCS : propertyContextCS.getConstraints()) {
            CT astNode;
            String message;
            if (initOrDerValueCS instanceof InitValueCS) {
                if (initCS != null) {
                    message = OCLMessages.bind(OCLMessages.PropertyConstraints_ERROR_, this.makeString((EList<String>)propertyName));
                    this.ERROR(initOrDerValueCS, "propertyContextCS", message);
                    continue;
                }
                initCS = (InitValueCS)initOrDerValueCS;
                astNode = this.initOrDerValueCS(env, initOrDerValueCS);
                constraints.add(astNode);
                continue;
            }
            if (!(initOrDerValueCS instanceof DerValueCS)) continue;
            if (derCS != null) {
                message = OCLMessages.bind(OCLMessages.PropertyConstraints_ERROR_, this.makeString((EList<String>)propertyName));
                this.ERROR(initOrDerValueCS, "propertyContextCS", message);
                continue;
            }
            derCS = (DerValueCS)initOrDerValueCS;
            astNode = this.initOrDerValueCS(env, initOrDerValueCS);
            constraints.add(astNode);
        }
        return property;
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createPropertyContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, PropertyContextCS propertyContextCS, P property) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.environmentFactory.createAttributeContext(env, property);
        if (result.lookupLocal("self") == null) {
            this.genVariableDeclaration(propertyContextCS, "propertyContextCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        return result;
    }

    protected CT initOrDerValueCS(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, InitOrDerValueCS initOrDerValueCS) {
        P property = env.getContextProperty();
        PropertyContextCS propertyContext = null;
        EObject container = initOrDerValueCS.eContainer();
        while (container != null) {
            if (container instanceof PropertyContextCS) {
                propertyContext = (PropertyContextCS)container;
                break;
            }
            container = container.eContainer();
        }
        env = this.createPropertyContext(env, propertyContext, property);
        String stereotype = null;
        switch (initOrDerValueCS.eClass().getClassifierID()) {
            case 16: {
                stereotype = "initial";
                break;
            }
            case 15: {
                stereotype = "derivation";
            }
        }
        OCLExpression<C> oclExpression = this.oclExpressionCS(initOrDerValueCS.getExpressionCS(), env);
        CT astNode = this.createConstraint();
        this.initASTMapping(env, astNode, initOrDerValueCS);
        this.uml.addConstrainedElement(astNode, (EObject)property);
        C owner = this.uml.getOwningClassifier(property);
        if (owner != env.getSelfVariable().getType()) {
            ProblemHandler.Severity sev;
            this.uml.addConstrainedElement(astNode, (EObject)env.getSelfVariable().getType());
            if (propertyContext != null && !(sev = this.getEnvironment().getValue(ProblemOption.INHERITED_FEATURE_CONTEXT)).isOK()) {
                this.getEnvironment().problem(sev, ProblemHandler.Phase.ANALYZER, OCLMessages.bind(OCLMessages.NonStd_InheritedFeatureContext_, this.formatQualifiedName(owner), this.formatName(property)), "initOrDerValueCS", null);
            }
        }
        ExpressionInOCL<C, PM> spec = this.createExpressionInOCL();
        this.initASTMapping(env, spec, initOrDerValueCS, null);
        spec.setBodyExpression(oclExpression);
        spec.setContextVariable(env.getSelfVariable());
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, stereotype);
        if ("derivation".equals(stereotype)) {
            env.setDeriveConstraint(property, astNode);
        } else {
            env.setInitConstraint(property, astNode);
        }
        return astNode;
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> classifierContextDeclCS(ClassifierContextDeclCS classifierContextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) {
        EList<String> pathName;
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = null;
        PathNameCS pathNameCS = classifierContextDeclCS.getPathNameCS();
        C type = this.lookupClassifier(pathNameCS, env, (List<String>)(pathName = AbstractOCLAnalyzer.createSequenceOfNames(pathNameCS, null)));
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR(classifierContextDeclCS, "classifierContextDeclCS", message);
            type = this.createDummyInvalidType(env, pathNameCS, pathNameCS.toString());
        }
        type = this.uml.asOCLType(type);
        result = this.environmentFactory.createClassifierContext(env, type);
        classifierContextDeclCS.setAst(type);
        if (result.getSelfVariable() == null) {
            this.genVariableDeclaration(classifierContextDeclCS, "classifierContextDeclCS", result, "self", type, null, true, true, true);
        }
        this.TRACE("classifierContextDeclCS", "context", pathName);
        for (InvOrDefCS decl : classifierContextDeclCS.getConstraints()) {
            CT constraint = this.invOrDefCS(decl, result);
            if (constraint == null) continue;
            constraints.add(constraint);
        }
        return result;
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createClassifierContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, ClassifierContextDeclCS classifierContextDeclCS, C classifier) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.environmentFactory.createClassifierContext(env, classifier);
        if (result.lookupLocal("self") == null) {
            this.genVariableDeclaration(classifierContextDeclCS, "propertyContextCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        return result;
    }

    protected CT invOrDefCS(InvOrDefCS invOrDefCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        C classifier = env.getContextClassifier();
        env = this.createClassifierContext(env, (ClassifierContextDeclCS)invOrDefCS.eContainer(), classifier);
        CT astNode = null;
        if (invOrDefCS instanceof InvCS) {
            astNode = this.invCS((InvCS)invOrDefCS, env);
        } else if (invOrDefCS instanceof DefCS) {
            astNode = this.defCS((DefCS)invOrDefCS, env);
        }
        return astNode;
    }

    protected CT invCS(InvCS invCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> oclExpression = this.oclExpressionCS(invCS.getExpressionCS(), env);
        CT astNode = this.createConstraint();
        SimpleNameCS simpleNameCS = invCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            this.uml.setConstraintName(astNode, simpleNameCS.getValue());
        }
        C type = env.getContextClassifier();
        this.uml.addConstrainedElement(astNode, (EObject)type);
        ExpressionInOCL<C, PM> spec = this.createExpressionInOCL();
        this.initASTMapping(env, astNode, invCS);
        this.initASTMapping(env, env.getSelfVariable(), invCS, null);
        this.initASTMapping(env, spec, invCS.getExpressionCS(), null);
        spec.setBodyExpression(oclExpression);
        spec.setContextVariable(env.getSelfVariable());
        if (simpleNameCS != null) {
            simpleNameCS.setAst(spec.getContextVariable());
        }
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, "invariant");
        return astNode;
    }

    protected CT defCS(DefCS defCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        DefExpressionCS defExpr = defCS.getDefExpressionCS();
        EObject feature = null;
        OCLExpression<C> expression = null;
        CT astNode = this.createConstraint();
        Variable<C, PM> variable = null;
        Object operType = null;
        C contextClassifier = env.getContextClassifier();
        SimpleNameCS simpleNameCS = defCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            this.uml.setConstraintName(astNode, simpleNameCS.getValue());
        }
        this.uml.addConstrainedElement(astNode, (EObject)contextClassifier);
        ExpressionInOCL<C, PM> spec = this.createExpressionInOCL();
        this.initASTMapping(env, astNode, defCS);
        this.initASTMapping(env, env.getSelfVariable(), defCS, null);
        this.initASTMapping(env, spec, defExpr);
        if (simpleNameCS != null) {
            simpleNameCS.setAst(spec.getContextVariable());
        }
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, "definition");
        if (defExpr != null) {
            try {
                if (defExpr.getVariableCS() != null) {
                    Environment<PK, Object, O, P, EL, PM, S, COA, SSA, CT, CLS, E> contextEnv = env;
                    variable = this.variableDeclarationCS(defExpr.getVariableCS(), contextEnv, false);
                    spec.setResultVariable(variable);
                    P existing = this.lookupProperty(null, env, contextClassifier, variable.getName());
                    if (existing != null) {
                        this.ERROR(defCS, "defCS", OCLMessages.bind(OCLMessages.DuplicateProperty_ERROR_, variable.getName(), this.uml.getName(contextEnv.getContextClassifier())));
                    }
                    spec.setContextVariable(env.getSelfVariable());
                    feature = (EObject)env.defineAttribute(contextClassifier, variable, astNode);
                    if (this.getEnvironment().getValue(ParsingOptions.DEFINITION_CONSTRAINS_FEATURE).booleanValue()) {
                        this.uml.addConstrainedElement(astNode, feature);
                    }
                    expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
                } else if (defExpr.getOperationCS() != null) {
                    OperationCS operCS = defExpr.getOperationCS();
                    Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> contextEnv = this.environmentFactory.createEnvironment(env);
                    List<Variable<C, PM>> params = this.variableDeclarationListCS((List<VariableCS>)operCS.getParameters(), contextEnv, true);
                    operType = this.typeCS(operCS.getTypeCS(), contextEnv);
                    String operName = operCS.getSimpleNameCS().getValue();
                    O existing = this.lookupOperation(null, env, contextClassifier, operName, params);
                    if (existing != null) {
                        this.ERROR(defCS, "defCS", OCLMessages.bind(OCLMessages.DuplicateOperation_ERROR_, this.operationString(env, operName, params), this.uml.getName(contextEnv.getContextClassifier())));
                    }
                    spec.setContextVariable(env.getSelfVariable());
                    spec.getParameterVariable().addAll(params);
                    feature = (EObject)env.defineOperation(contextClassifier, operName, operType, params, astNode);
                    operCS.setAst(feature);
                    operCS.getSimpleNameCS().setAst(feature);
                    if (operCS.getPathNameCS() != null) {
                        operCS.getPathNameCS().setAst(contextClassifier);
                    }
                    if (this.getEnvironment().getValue(ParsingOptions.DEFINITION_CONSTRAINS_FEATURE).booleanValue()) {
                        this.uml.addConstrainedElement(astNode, feature);
                    }
                    expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
                }
                if (feature != null && defCS.isStatic()) {
                    Boolean supportStatic = this.getEnvironment().getValue(ParsingOptions.SUPPORT_STATIC_FEATURES);
                    if (!supportStatic.booleanValue()) {
                        this.ERROR(defCS, "defCS", OCLMessages.bind(OCLMessages.UnsupportedStatic_ERROR_, null));
                    } else if (!this.uml.setIsStatic(feature, true)) {
                        this.ERROR(defCS, "defCS", OCLMessages.bind(OCLMessages.UnimplementedStatic_ERROR_, null));
                    }
                }
                if (feature != null && expression != null) {
                    C featureType = this.getOCLType(env, feature);
                    Object bodyType = expression.getType();
                    if (featureType == null || !TypeUtil.compatibleTypeMatch(env, bodyType, featureType)) {
                        expression = null;
                        astNode = null;
                        String message = OCLMessages.bind(OCLMessages.DefinitionConstraintConformance_ERROR_, this.uml.getName(bodyType), this.uml.getName(featureType));
                        this.ERROR(defCS, "defCS", message);
                    }
                    spec.setBodyExpression(expression);
                }
            }
            finally {
                if (feature != null && expression == null) {
                    env.undefine(feature);
                }
            }
        }
        return astNode;
    }

    protected Variable<C, PM> variableDeclarationCS(VariableCS variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, boolean addToEnvironment) {
        String varName = variableDeclarationCS.getName();
        C type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        OCLExpression<C> expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        if (expr != null) {
            Object exprType = expr.getType();
            while (exprType instanceof CollectionType) {
                CollectionType ct = (CollectionType)exprType;
                exprType = ct.getElementType();
            }
            if (exprType instanceof MessageType) {
                C varType = type;
                if (varType instanceof CollectionType) {
                    do {
                        CollectionType collType;
                        if ((varType = (C)(collType = (CollectionType)varType).getElementType()) != env.getOCLStandardLibrary().getOclMessage()) continue;
                        collType.setElementType(exprType);
                        break;
                    } while (varType instanceof CollectionType);
                } else if (type == env.getOCLStandardLibrary().getOclMessage()) {
                    type = exprType;
                }
            }
        }
        Variable<Object, PM> astNode = this.genVariableDeclaration(variableDeclarationCS, "variableDeclarationCS", env, varName, type, expr, true, addToEnvironment, false);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        return astNode;
    }

    protected List<Variable<C, PM>> variableDeclarationListCS(List<VariableCS> variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, boolean addToEnvironment) {
        ArrayList<Variable<C, PM>> variableDeclarations = new ArrayList<Variable<C, PM>>();
        for (VariableCS next : variableDeclarationCS) {
            variableDeclarations.add(this.variableDeclarationCS(next, env, addToEnvironment));
        }
        return variableDeclarations;
    }

    protected C typeCS(TypeCS typeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        C astNode = null;
        if (typeCS instanceof PrimitiveTypeCS) {
            astNode = this.primitiveTypeCS(((PrimitiveTypeCS)typeCS).getType(), env);
            typeCS.setAst(astNode);
        } else if (typeCS instanceof PathNameCS) {
            EList<String> pathName = AbstractOCLAnalyzer.createSequenceOfNames((PathNameCS)typeCS, null);
            astNode = this.lookupClassifier(typeCS, env, (List<String>)pathName);
            if (astNode == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, this.formatPath((List<String>)pathName));
                this.ERROR(typeCS, "typeCS", message);
                astNode = this.createDummyInvalidType(env, typeCS, message);
            }
            typeCS.setAst(astNode);
        } else if (typeCS instanceof CollectionTypeCS || typeCS instanceof TupleTypeCS) {
            if (typeCS instanceof CollectionTypeCS) {
                astNode = this.collectionTypeCS((CollectionTypeCS)typeCS, env);
            } else if (typeCS instanceof TupleTypeCS) {
                astNode = this.tupleTypeCS((TupleTypeCS)typeCS, env);
            }
        }
        return astNode;
    }

    protected StateExp<C, S> stateExpCS(OCLExpression<C> source, CSTNode stateExpCS, EList<String> statePath, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        C sourceType = null;
        if (source != null) {
            sourceType = source.getType();
        }
        Object state = null;
        if (!statePath.isEmpty() && (state = (Object)this.lookupState(stateExpCS, env, sourceType, (List<String>)statePath)) == null) {
            this.ERROR(stateExpCS, "stateExpCS", OCLMessages.bind(OCLMessages.NoSuchState_ERROR_, statePath, sourceType == null ? null : this.uml.getName(sourceType)));
        }
        StateExp astNode = this.oclFactory.createStateExp();
        this.initASTMapping(env, astNode, stateExpCS);
        astNode.setReferredState(state);
        astNode.setType(env.getOCLStandardLibrary().getState());
        astNode.setName(this.makeName(statePath));
        this.initStartEndPositions(astNode, stateExpCS);
        return astNode;
    }

    protected C collectionTypeCS(CollectionTypeCS collectionTypeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        CollectionKind kind = this.collectionTypeIdentifierCS(collectionTypeCS.getCollectionTypeIdentifier());
        C type = this.typeCS(collectionTypeCS.getTypeCS(), env);
        C result = this.getCollectionType(collectionTypeCS, env, kind, type);
        CollectionType astNode = (CollectionType)result;
        this.initTypePositions(astNode, collectionTypeCS.getTypeCS());
        return result;
    }

    protected CollectionKind collectionTypeIdentifierCS(CollectionTypeIdentifierEnum collectionTypeIdentifier) {
        CollectionKind astNode = null;
        switch (collectionTypeIdentifier.getValue()) {
            case 1: {
                astNode = CollectionKind.SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SET");
                break;
            }
            case 2: {
                astNode = CollectionKind.BAG_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "BAG");
                break;
            }
            case 3: {
                astNode = CollectionKind.SEQUENCE_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SEQUENCE");
                break;
            }
            case 4: {
                astNode = CollectionKind.COLLECTION_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "COLLECTION");
                break;
            }
            case 5: {
                astNode = CollectionKind.ORDERED_SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "ORDERED_SET");
            }
        }
        return astNode;
    }

    protected C tupleTypeCS(TupleTypeCS tupleTypeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        BasicEList vdcls = new BasicEList();
        List<Variable<C, PM>> variableDeclarations = this.variableDeclarationListCS((List<VariableCS>)tupleTypeCS.getVariables(), env, false);
        for (Variable<C, PM> vdcl : variableDeclarations) {
            String message;
            vdcls.add(vdcl);
            String name = vdcl.getName();
            this.TRACE("tupleTypeCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR(vdcl, "tupleTypeCS", message);
                vdcl.setName(null);
            } else {
                names.add(name);
            }
            if (vdcl.getInitExpression() != null) {
                message = OCLMessages.bind(OCLMessages.InitExpNotAllowed_ERROR_, name);
                this.ERROR(vdcl, "tupleTypeCS", message);
            }
            if (vdcl.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, name);
                this.ERROR(vdcl, "tupleTypeCS", message);
                vdcl.setType(this.getOclVoid());
            }
            nodeName = nodeName == null ? "Tuple(" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + vdcl.getName() + ":" + this.uml.getName(vdcl.getType());
        }
        return this.getTupleType(tupleTypeCS, env, (EList<? extends TypedElement<C>>)vdcls);
    }

    protected OCLExpression<C> oclExpressionCS(OCLExpressionCS oclExpressionCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> astNode = null;
        if (oclExpressionCS instanceof IfExpCS) {
            astNode = this.ifExpCS((IfExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof CallExpCS) {
            astNode = this.propertyCallExpCS((CallExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof VariableExpCS) {
            astNode = this.variableExpCS((VariableExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LiteralExpCS) {
            astNode = this.literalExpCS((LiteralExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LetExpCS) {
            astNode = this.letExp((LetExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof MessageExpCS) {
            astNode = this.messageExpCS((MessageExpCS)oclExpressionCS, env);
        }
        if (astNode != null) {
            astNode.setType(TypeUtil.resolveType(env, astNode.getType()));
            this.initStartEndPositions(astNode, oclExpressionCS);
        }
        return astNode;
    }

    protected OCLExpression<C> variableExpCS(VariableExpCS variableExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        SimpleNameCS simpleNameCS = variableExpCS.getSimpleNameCS();
        OCLExpression<C> astNode = this.simpleNameCS(simpleNameCS, env, null);
        variableExpCS.setAst(astNode);
        List<OCLExpression<C>> qualifiers = this.qualifiersCS((List<OCLExpressionCS>)variableExpCS.getArguments(), env, astNode);
        if (this.isAtPre(variableExpCS)) {
            if (astNode instanceof FeatureCallExp) {
                ((FeatureCallExp)astNode).setMarkedPre(true);
            } else {
                this.ERROR(variableExpCS.getIsMarkedPreCS(), "variableExpCS", OCLMessages.IllegalAtPre_ERROR_);
            }
        }
        if (!qualifiers.isEmpty()) {
            if (astNode instanceof NavigationCallExp) {
                NavigationCallExp callNode = (NavigationCallExp)astNode;
                this.setQualifiers(env, "variableExpCS", callNode, qualifiers);
            } else if (astNode instanceof LoopExp && ((LoopExp)astNode).getBody() instanceof NavigationCallExp) {
                NavigationCallExp callNode = (NavigationCallExp)((LoopExp)astNode).getBody();
                this.setQualifiers(env, "variableExpCS", callNode, qualifiers);
            } else {
                this.ERROR(variableExpCS, "variableExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(variableExpCS)));
            }
        } else if (astNode instanceof AssociationClassCallExp) {
            AssociationClassCallExp callNode = (AssociationClassCallExp)astNode;
            this.checkNotReflexive(env, "variableExpCS", callNode);
        }
        return astNode;
    }

    protected boolean isAtPre(FeatureCallExpCS callExp) {
        IsMarkedPreCS atPre = callExp.getIsMarkedPreCS();
        return atPre != null;
    }

    protected boolean isAtPre(VariableExpCS variableExp) {
        IsMarkedPreCS atPre = variableExp.getIsMarkedPreCS();
        return atPre != null;
    }

    protected VariableExp<C, PM> createVariableExp(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CSTNode cst, Variable<C, PM> var) {
        VariableExp<C, PM> result = this.oclFactory.createVariableExp();
        this.initASTMapping(env, result, cst, var);
        if (var != null) {
            result.setType(var.getType());
            result.setReferredVariable(var);
            result.setName(var.getName());
        }
        return result;
    }

    protected List<OCLExpression<C>> qualifiersCS(List<OCLExpressionCS> arguments, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> navigation) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OCLExpression<C>> qualifiers = new ArrayList<OCLExpression<C>>();
        if (navigation instanceof LoopExp) {
            LoopExp loopNode = (LoopExp)navigation;
            navigation = loopNode.getBody();
        }
        if (navigation instanceof AssociationClassCallExp) {
            AssociationClassCallExp acc = (AssociationClassCallExp)navigation;
            OCLExpression source = acc.getSource();
            OCLExpressionCS arg = arguments.get(0);
            if (!(arg instanceof VariableExpCS)) {
                this.ERROR(arg, "qualifiersCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableExpCS", arg.eClass().getName()));
            } else {
                String simpleName;
                C sourceType;
                SimpleNameCS qualifier = ((VariableExpCS)arg).getSimpleNameCS();
                P property = this.lookupProperty(qualifier, env, sourceType = source != null ? (C)source.getType() : null, simpleName = qualifier.getValue());
                if (property == null) {
                    String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
                    this.ERROR(sourceType, "qualifiersCS", message);
                } else {
                    this.TRACE("qualifierCS", "Reference: " + simpleName);
                    PropertyCallExp ref = this.oclFactory.createPropertyCallExp();
                    this.initASTMapping(env, ref, arg);
                    ref.setReferredProperty(property);
                    ref.setType(this.getPropertyType(qualifier, env, sourceType, property));
                    if (source == null) {
                        Variable<C, PM> implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                        VariableExp<C, PM> src = this.createVariableExp(env, arg, implicitSource);
                        ref.setSource(src);
                    }
                    this.initStartEndPositions(ref, qualifier);
                    this.initPropertyPositions(ref, qualifier);
                    qualifiers.add(ref);
                }
            }
        } else {
            for (OCLExpressionCS arg : arguments) {
                OCLExpression<C> qualExp = this.oclExpressionCS(arg, env);
                if (qualExp == null) continue;
                qualifiers.add(qualExp);
            }
        }
        return qualifiers;
    }

    protected IfExp<C> ifExpCS(IfExpCS ifExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> condition = this.oclExpressionCS(ifExpCS.getCondition(), env);
        OCLExpression<C> thenExpression = this.oclExpressionCS(ifExpCS.getThenExpression(), env);
        OCLExpression<C> elseExpression = this.oclExpressionCS(ifExpCS.getElseExpression(), env);
        this.TRACE("ifExpCS", " ");
        IfExp<C> astNode = this.oclFactory.createIfExp();
        if (!this.isErrorNode(condition) && condition.getType() != this.getBoolean()) {
            this.ERROR(ifExpCS.getCondition(), "ifExpCS", OCLMessages.bind(OCLMessages.BooleanForIf_ERROR_, this.computeInputString(ifExpCS.getCondition())));
        }
        this.initASTMapping(env, astNode, ifExpCS);
        astNode.setCondition(condition);
        astNode.setThenExpression(thenExpression);
        astNode.setElseExpression(elseExpression);
        if (thenExpression != null && elseExpression != null) {
            C commonType = this.getCommonSuperType(ifExpCS, "ifExpCS", env, thenExpression.getType(), elseExpression.getType());
            astNode.setType(commonType);
            if (this.isErrorNode(thenExpression)) {
                this.markAsErrorNode(astNode);
            }
            if (this.isErrorNode(elseExpression)) {
                this.markAsErrorNode(astNode);
            }
        } else {
            astNode.setType(this.getOclVoid());
        }
        this.initStartEndPositions(astNode, ifExpCS);
        return astNode;
    }

    @Deprecated
    protected LetExp<C, PM> letExpCS(LetExpCS letExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return (LetExp)this.letExp(letExpCS, env);
    }

    protected OCLExpression<C> letExp(LetExpCS letExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return this.letExpCSRecursive(letExpCS, 0, env);
    }

    protected OCLExpression<C> letExpCSRecursive(LetExpCS letExpCS, int index, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> astNode;
        if (index < letExpCS.getVariables().size()) {
            String message;
            VariableCS variableDeclarationCS = (VariableCS)letExpCS.getVariables().get(index);
            Variable<C, PM> variableDeclaration = this.variableDeclarationCS(variableDeclarationCS, env, true);
            String varName = variableDeclaration.getName();
            if (variableDeclaration.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, varName);
                this.ERROR(variableDeclarationCS, "letExpCS", message);
                variableDeclaration.setType(this.getOclVoid());
            }
            if (variableDeclaration.getInitExpression() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, varName);
                this.ERROR(variableDeclarationCS, "letExpCS", message);
            }
            OCLExpression<C> letSubExp = this.letExpCSRecursive(letExpCS, ++index, env);
            LetExp<C, PM> letExp = this.oclFactory.createLetExp();
            this.initASTMapping(env, letExp, letExpCS);
            letExp.setVariable(variableDeclaration);
            letExp.setIn(letSubExp);
            if (letSubExp != null) {
                letExp.setType(letSubExp.getType());
            } else {
                letExp.setType(this.getOclVoid());
            }
            astNode = letExp;
            env.deleteElement(varName);
        } else {
            astNode = this.oclExpressionCS(letExpCS.getInExpression(), env);
        }
        return astNode;
    }

    protected OCLExpression<C> simpleNameCS(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source) {
        OCLExpression<Object> astNode;
        if (source != null && this.isErrorNode(source)) {
            return source;
        }
        String simpleName = null;
        C classifier = null;
        switch (simpleNameCS.getType().getValue()) {
            case 1: 
            case 2: 
            case 11: {
                simpleName = simpleNameCS.getValue();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                if (source != null) break;
                classifier = this.primitiveTypeCS(simpleNameCS.getType(), env);
                simpleName = this.uml.getName(classifier);
            }
        }
        C sourceElementType = null;
        if (source != null && (sourceElementType = (C)source.getType()) instanceof CollectionType) {
            CollectionType ct = (CollectionType)sourceElementType;
            sourceElementType = ct.getElementType();
        }
        if ((astNode = this.simpleTypeName(simpleNameCS, env, source, classifier, simpleName)) == null) {
            astNode = this.simpleVariableName(simpleNameCS, env, source, simpleName);
        }
        if (astNode == null) {
            astNode = this.simpleNavigationName(simpleNameCS, env, source, sourceElementType, simpleName);
        }
        if (astNode == null) {
            astNode = this.simpleAssociationClassName(simpleNameCS, env, source, sourceElementType, simpleName);
        }
        if (astNode == null) {
            astNode = this.simpleUndefinedName(simpleNameCS, env, source, simpleName);
        }
        if (source != null && source.getType() instanceof CollectionType && astNode instanceof FeatureCallExp) {
            astNode = this.createImplicitCollect(source, (FeatureCallExp)astNode, env, simpleNameCS);
        }
        return astNode;
    }

    protected AssociationClassCallExp<C, P> simpleAssociationClassName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, C owner, String simpleName) {
        AssociationClassCallExp<C, P> result = null;
        C assocClass = this.lookupAssociationClassReference(simpleNameCS, env, owner, simpleName);
        if (assocClass != null) {
            this.TRACE("variableExpCS", "Association class: " + simpleName);
            result = this.oclFactory.createAssociationClassCallExp();
            this.initASTMapping(env, result, simpleNameCS);
            result.setReferredAssociationClass(assocClass);
            if (source != null) {
                result.setSource(source);
            } else {
                Variable<C, PM> implicitSource = env.lookupImplicitSourceForAssociationClass(simpleName);
                VariableExp<C, PM> src = this.createVariableExp(env, simpleNameCS, implicitSource);
                result.setSource(src);
            }
            Object acrefType = null;
            Object sourceType = this.getElementType(result.getSource().getType());
            List<P> ends = this.uml.getMemberEnds(assocClass);
            List<P> available = this.uml.getAttributes(sourceType);
            for (P end : ends) {
                if (!available.contains(end)) continue;
                result.setNavigationSource(end);
                CollectionKind kind = this.getCollectionKind(this.getOCLType(env, end));
                acrefType = kind != null ? (Object)this.getCollectionType(simpleNameCS, env, kind, assocClass) : (Object)assocClass;
            }
            if (acrefType == null) {
                acrefType = this.getSetType(simpleNameCS, env, assocClass);
            }
            result.setType(acrefType);
            this.initPropertyPositions(result, simpleNameCS);
        }
        return result;
    }

    protected NavigationCallExp<C, P> simpleNavigationName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, C owner, String simpleName) {
        return this.simplePropertyName(simpleNameCS, env, source, owner, simpleName);
    }

    protected PropertyCallExp<C, P> simplePropertyName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, C owner, String simpleName) {
        if (simpleName == null) {
            return null;
        }
        PropertyCallExp<C, P> result = null;
        P property = this.lookupProperty(simpleNameCS, env, owner, simpleName);
        if (property != null) {
            this.TRACE("variableExpCS", "Property: " + simpleName);
            result = this.oclFactory.createPropertyCallExp();
            this.initASTMapping(env, result, simpleNameCS, null);
            result.setReferredProperty(property);
            result.setType(this.getPropertyType(simpleNameCS, env, owner, property));
            if (source != null) {
                result.setSource(source);
            } else {
                Variable<C, PM> implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                VariableExp<C, PM> src = this.createVariableExp(env, simpleNameCS, implicitSource);
                result.setSource(src);
            }
            this.initPropertyPositions(result, simpleNameCS);
        }
        return result;
    }

    protected TypeExp<C> simpleTypeName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, C classifier, String simpleName) {
        if (simpleNameCS.getAst() != null) {
            return null;
        }
        TypeExp<C> result = null;
        if (classifier == null && source == null) {
            classifier = this.lookupClassifier(simpleNameCS, env, Collections.singletonList(simpleName));
        }
        if (classifier != null) {
            result = this.typeCS(simpleNameCS, env, classifier);
        }
        return result;
    }

    protected VariableExp<C, PM> simpleVariableName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, String simpleName) {
        Variable<C, PM> vdcl;
        VariableExp<C, PM> result = null;
        if (source == null && (vdcl = env.lookup(simpleName)) != null) {
            this.TRACE("variableExpCS", "Variable Expression: " + simpleName);
            result = this.createVariableExp(env, simpleNameCS, vdcl);
        }
        return result;
    }

    protected OCLExpression<C> simpleUndefinedName(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source, String simpleName) {
        if (source != null && env.lookup(simpleName) != null) {
            String message = OCLMessages.bind(OCLMessages.VarInNavExp_ERROR_, simpleName);
            this.ERROR(simpleNameCS, "variableExpCS", message);
        } else {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
            this.ERROR(simpleNameCS, "variableExpCS", message);
        }
        return this.createDummyInvalidLiteralExp(env, simpleNameCS);
    }

    protected IteratorExp<C, PM> createImplicitCollect(OCLExpression<C> source, FeatureCallExp<C> propertyCall, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CSTNode cstNode) {
        C c;
        Object sourceElementType = ((CollectionType)source.getType()).getElementType();
        IteratorExp result = this.oclFactory.createIteratorExp();
        this.initASTMapping(env, result, cstNode, null);
        Variable<C, PM> itervar = this.genVariableDeclaration(cstNode, "modelPropertyCallCS", env, null, sourceElementType, null, false, true, false);
        EList iters = result.getIterator();
        iters.add(itervar);
        result.setBody(propertyCall);
        result.setName("collect");
        VariableExp<C, PM> vexp = this.createVariableExp(env, cstNode, itervar);
        propertyCall.setSource(vexp);
        if (!(propertyCall instanceof OperationCallExp)) {
            propertyCall.setStartPosition(propertyCall.getPropertyStartPosition());
            propertyCall.setEndPosition(propertyCall.getPropertyEndPosition());
        }
        result.setSource(source);
        Object bodyType = propertyCall.getType();
        if (bodyType instanceof CollectionType) {
            CollectionType ct = (CollectionType)bodyType;
            bodyType = CollectionUtil.getFlattenedElementType(ct);
        }
        if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
            c = this.getCollectionType(cstNode, env, CollectionKind.SEQUENCE_LITERAL, bodyType);
            result.setType(c);
        } else {
            c = this.getCollectionType(cstNode, env, CollectionKind.BAG_LITERAL, bodyType);
            result.setType(c);
        }
        env.deleteElement(itervar.getName());
        return result;
    }

    protected C primitiveTypeCS(SimpleTypeEnum simpleType, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        C astNode = null;
        switch (simpleType) {
            case INTEGER_LITERAL: {
                astNode = env.getOCLStandardLibrary().getInteger();
                break;
            }
            case UNLIMITED_NATURAL_LITERAL: {
                astNode = env.getOCLStandardLibrary().getUnlimitedNatural();
                break;
            }
            case STRING_LITERAL: {
                astNode = env.getOCLStandardLibrary().getString();
                break;
            }
            case REAL_LITERAL: {
                astNode = env.getOCLStandardLibrary().getReal();
                break;
            }
            case BOOLEAN_LITERAL: {
                astNode = env.getOCLStandardLibrary().getBoolean();
                break;
            }
            case OCL_ANY_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclAny();
                break;
            }
            case OCL_VOID_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclVoid();
                break;
            }
            case OCL_INVALID_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclInvalid();
                break;
            }
            case OCL_MESSAGE_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclMessage();
            }
        }
        return astNode;
    }

    protected LiteralExp<C> primitiveLiteralExpCS(PrimitiveLiteralExpCS primitiveLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        PrimitiveLiteralExp<C> astNode = null;
        if (primitiveLiteralExpCS instanceof IntegerLiteralExpCS) {
            astNode = this.integerLiteralExpCS((IntegerLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof UnlimitedNaturalLiteralExpCS) {
            astNode = this.unlimitedNaturalLiteralExpCS((UnlimitedNaturalLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof RealLiteralExpCS) {
            astNode = this.realLiteralExpCS((RealLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof StringLiteralExpCS) {
            astNode = this.stringLiteralExpCS((StringLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof BooleanLiteralExpCS) {
            astNode = this.booleanLiteralExpCS((BooleanLiteralExpCS)primitiveLiteralExpCS, env);
        }
        return astNode;
    }

    protected IntegerLiteralExp<C> integerLiteralExpCS(IntegerLiteralExpCS integerLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        IntegerLiteralExp<C> astNode = this.oclFactory.createIntegerLiteralExp();
        this.initASTMapping(env, astNode, integerLiteralExpCS);
        astNode.setLongSymbol(integerLiteralExpCS.getLongSymbol());
        astNode.setType(env.getOCLStandardLibrary().getInteger());
        this.TRACE("integerLiteralExpCS", "Integer: " + integerLiteralExpCS.getSymbol());
        return astNode;
    }

    protected UnlimitedNaturalLiteralExp<C> unlimitedNaturalLiteralExpCS(UnlimitedNaturalLiteralExpCS unlimitedNaturalLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        UnlimitedNaturalLiteralExp<C> astNode = this.oclFactory.createUnlimitedNaturalLiteralExp();
        this.initASTMapping(env, astNode, unlimitedNaturalLiteralExpCS);
        astNode.setIntegerSymbol(unlimitedNaturalLiteralExpCS.getIntegerSymbol());
        astNode.setType(env.getOCLStandardLibrary().getUnlimitedNatural());
        this.TRACE("unlimitedNaturalLiteralExpCS", "UnlimitedNatural: " + unlimitedNaturalLiteralExpCS.getSymbol());
        return astNode;
    }

    protected RealLiteralExp<C> realLiteralExpCS(RealLiteralExpCS realLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        RealLiteralExp<C> astNode = this.oclFactory.createRealLiteralExp();
        this.initASTMapping(env, astNode, realLiteralExpCS);
        astNode.setRealSymbol(realLiteralExpCS.getRealSymbol());
        astNode.setType(env.getOCLStandardLibrary().getReal());
        this.TRACE("realLiteralExpCS", "Real: " + realLiteralExpCS.getSymbol());
        return astNode;
    }

    protected StringLiteralExp<C> stringLiteralExpCS(StringLiteralExpCS stringLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        StringLiteralExp<C> astNode = this.oclFactory.createStringLiteralExp();
        this.initASTMapping(env, astNode, stringLiteralExpCS);
        astNode.setStringSymbol(stringLiteralExpCS.getUnescapedStringSymbol());
        astNode.setType(env.getOCLStandardLibrary().getString());
        this.TRACE("stringLiteralExpCS", "String: " + stringLiteralExpCS.getSymbol());
        return astNode;
    }

    protected BooleanLiteralExp<C> booleanLiteralExpCS(BooleanLiteralExpCS booleanLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        BooleanLiteralExp<C> astNode = this.oclFactory.createBooleanLiteralExp();
        this.initASTMapping(env, astNode, booleanLiteralExpCS);
        astNode.setBooleanSymbol(booleanLiteralExpCS.getBooleanSymbol());
        astNode.setType(env.getOCLStandardLibrary().getBoolean());
        this.TRACE("booleanLiteralExpCS", "Boolean: " + booleanLiteralExpCS.getSymbol());
        return astNode;
    }

    protected NullLiteralExp<C> nullLiteralExpCS(NullLiteralExpCS nullLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        NullLiteralExp<C> astNode = this.oclFactory.createNullLiteralExp();
        this.initASTMapping(env, astNode, nullLiteralExpCS);
        astNode.setType(env.getOCLStandardLibrary().getOclVoid());
        this.TRACE("nullLiteralExpCS", "OclVoid: null");
        return astNode;
    }

    protected InvalidLiteralExp<C> invalidLiteralExpCS(InvalidLiteralExpCS invalidLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        InvalidLiteralExp<C> astNode = this.oclFactory.createInvalidLiteralExp();
        this.initASTMapping(env, astNode, invalidLiteralExpCS);
        astNode.setType(env.getOCLStandardLibrary().getOclInvalid());
        this.TRACE("invalidLiteralExpCS", "Invalid: invalid");
        return astNode;
    }

    protected OCLExpression<C> literalExpCS(LiteralExpCS literalExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        LiteralExp<C> astNode = null;
        if (literalExpCS instanceof PrimitiveLiteralExpCS) {
            astNode = this.primitiveLiteralExpCS((PrimitiveLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof CollectionLiteralExpCS) {
            astNode = this.collectionLiteralExpCS((CollectionLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof TupleLiteralExpCS) {
            astNode = this.tupleLiteralExpCS((TupleLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof NullLiteralExpCS) {
            astNode = this.nullLiteralExpCS((NullLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof InvalidLiteralExpCS) {
            astNode = this.invalidLiteralExpCS((InvalidLiteralExpCS)literalExpCS, env);
        }
        return astNode;
    }

    protected TupleLiteralExp<C, P> tupleLiteralExpCS(TupleLiteralExpCS tupleLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        TupleLiteralExp astNode = this.oclFactory.createTupleLiteralExp();
        this.initASTMapping(env, astNode, tupleLiteralExpCS);
        EList tupleParts = astNode.getPart();
        this.TRACE("tupleLiteralExpCS", "Tuple");
        EList<VariableCS> tupleLiteralPartListCS = tupleLiteralExpCS.getVariables();
        EList<TupleLiteralPart<C, P>> tupleLiteralParts = this.tupleLiteralPartListCS((List<VariableCS>)tupleLiteralPartListCS, env);
        for (TupleLiteralPart part : tupleLiteralParts) {
            String message;
            tupleParts.add((Object)part);
            String name = part.getName();
            this.TRACE("tupleLiteralExpCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR(part, "tupleLiteralPartCS", message);
                part.setName(null);
            } else {
                names.add(name);
            }
            if (part.getValue() == null) {
                message = OCLMessages.bind(OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, name, this.computeInputString(tupleLiteralExpCS));
                this.ERROR(tupleLiteralExpCS, "tupleLiteralExpCS", message);
            }
            if (part.getType() == null) {
                if (part.getValue() != null) {
                    part.setType(part.getValue().getType());
                } else {
                    part.setType(this.getOclVoid());
                }
            }
            nodeName = nodeName == null ? "Tuple{" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + part.getName() + ":" + this.uml.getName(part.getType());
        }
        C tt = this.getTupleType(tupleLiteralExpCS, env, tupleParts);
        astNode.setType(tt);
        for (TupleLiteralPart part : tupleParts) {
            part.setAttribute(env.lookupProperty(tt, part.getName()));
        }
        return astNode;
    }

    protected EList<TupleLiteralPart<C, P>> tupleLiteralPartListCS(List<VariableCS> variableDeclarations, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        BasicEList result = new BasicEList();
        Iterator<VariableCS> i = variableDeclarations.iterator();
        while (i.hasNext()) {
            result.add(this.tupleLiteralPartCS(i.next(), env));
        }
        return result;
    }

    protected TupleLiteralPart<C, P> tupleLiteralPartCS(VariableCS variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        String varName = variableDeclarationCS.getName();
        Object type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        OCLExpression<C> expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        TupleLiteralPart astNode = this.oclFactory.createTupleLiteralPart();
        this.initASTMapping(env, astNode, variableDeclarationCS);
        astNode.setName(varName);
        astNode.setType(type);
        astNode.setValue(expr);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        if (expr != null && this.isErrorNode(expr)) {
            this.markAsErrorNode(astNode);
        }
        return astNode;
    }

    protected TypeExp<C> typeCS(CSTNode enumLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        TypeExp<C> astNode = this.oclFactory.createTypeExp();
        this.initASTMapping(env, astNode, enumLiteralExpCS, null);
        astNode.setReferredType(type);
        astNode.setType(this.getTypeType(enumLiteralExpCS, env, type));
        return astNode;
    }

    protected CollectionLiteralExp<C> collectionLiteralExpCS(CollectionLiteralExpCS collectionLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        CollectionLiteralExp astNode = null;
        CollectionKind kind = null;
        CollectionLiteralPart<C> collectionLiteralPartExp = null;
        EList collectionParts = null;
        Object type = null;
        Object resultType = null;
        kind = this.collectionTypeIdentifierCS(collectionLiteralExpCS.getCollectionType());
        astNode = this.oclFactory.createCollectionLiteralExp();
        this.initASTMapping(env, astNode, collectionLiteralExpCS);
        astNode.setKind(kind);
        collectionParts = astNode.getPart();
        EList<CollectionLiteralPartCS> collectionLiteralPartsCS = collectionLiteralExpCS.getCollectionLiteralParts();
        if (!collectionLiteralPartsCS.isEmpty()) {
            Iterator i = collectionLiteralPartsCS.iterator();
            CollectionLiteralPartCS colPart = (CollectionLiteralPartCS)i.next();
            collectionLiteralPartExp = this.collectionLiteralPartCS(colPart, env);
            collectionParts.add(collectionLiteralPartExp);
            type = collectionLiteralPartExp.getType();
            if (this.isErrorNode(collectionLiteralPartExp)) {
                this.markAsErrorNode(astNode);
            }
            while (i.hasNext()) {
                collectionLiteralPartExp = this.collectionLiteralPartCS((CollectionLiteralPartCS)i.next(), env);
                Object type1 = collectionLiteralPartExp.getType();
                type = this.getCommonSuperType(colPart, "collectionLiteralExpCS", env, type, type1);
                collectionParts.add(collectionLiteralPartExp);
                if (!this.isErrorNode(collectionLiteralPartExp)) continue;
                this.markAsErrorNode(astNode);
            }
        }
        resultType = collectionParts.isEmpty() ? (Object)this.getCollectionType(collectionLiteralExpCS, env, kind, env.getOCLStandardLibrary().getOclVoid()) : this.getCollectionType(collectionLiteralExpCS, env, kind, type);
        astNode.setType(resultType);
        return astNode;
    }

    protected CollectionLiteralPart<C> collectionLiteralPartCS(CollectionLiteralPartCS collectionLiteralPartCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        CollectionLiteralPart<C> astNode = null;
        OCLExpression<C> expr1 = null;
        OCLExpression<C> expr2 = null;
        CollectionRange collRange = null;
        CollectionItem<C> collItem = null;
        expr1 = this.oclExpressionCS(collectionLiteralPartCS.getExpressionCS(), env);
        if (collectionLiteralPartCS instanceof CollectionRangeCS) {
            CollectionRangeCS collectionRangeCS = (CollectionRangeCS)collectionLiteralPartCS;
            expr2 = this.oclExpressionCS(collectionRangeCS.getLastExpressionCS(), env);
            collRange = this.oclFactory.createCollectionRange();
            this.initASTMapping(env, collRange, collectionLiteralPartCS);
            collRange.setFirst(expr1);
            collRange.setLast(expr2);
            collRange.setType(expr1.getType());
            if (expr1.getType() != expr2.getType()) {
                this.ERROR(collectionLiteralPartCS, "collectionLiteralPartCS", OCLMessages.bind(OCLMessages.FirstLastTypeMismatch_ERROR_, this.computeInputString(collectionLiteralPartCS)));
            }
            astNode = collRange;
            if (this.isErrorNode(expr1) || this.isErrorNode(expr2)) {
                this.markAsErrorNode(astNode);
            }
            this.TRACE("collectionLiteralPartCS", "collection range");
        } else {
            collItem = this.oclFactory.createCollectionItem();
            this.initASTMapping(env, collItem, collectionLiteralPartCS);
            collItem.setType(expr1.getType());
            collItem.setItem(expr1);
            astNode = collItem;
            if (this.isErrorNode(expr1)) {
                this.markAsErrorNode(astNode);
            }
            this.TRACE("collectionLiteralPartCS", "collection item");
        }
        return astNode;
    }

    protected OCLExpression<C> propertyCallExpCS(CallExpCS propertyCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression astNode = null;
        if (propertyCallExpCS instanceof LoopExpCS) {
            astNode = this.loopExpCS((LoopExpCS)propertyCallExpCS, env);
        } else if (propertyCallExpCS instanceof FeatureCallExpCS) {
            astNode = this.modelPropertyCallExpCS((FeatureCallExpCS)propertyCallExpCS, env);
        }
        this.initStartEndPositions(astNode, propertyCallExpCS);
        return astNode;
    }

    protected LoopExp<C, PM> loopExpCS(LoopExpCS loopExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        LoopExp<C, PM> astNode = null;
        if (loopExpCS instanceof IteratorExpCS) {
            astNode = this.iteratorExpCS((IteratorExpCS)loopExpCS, env);
        } else if (loopExpCS instanceof IterateExpCS) {
            astNode = this.iterateExpCS((IterateExpCS)loopExpCS, env);
        }
        return astNode;
    }

    protected OCLExpression<C> getCollectionSourceExpression(OCLExpressionCS oclExpressionCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> astNode = this.oclExpressionCS(oclExpressionCS, env);
        if (astNode == null) {
            astNode = this.createDummyInvalidLiteralExp(env, oclExpressionCS);
        }
        if (!(astNode.getType() instanceof CollectionType)) {
            CollectionLiteralExp<C> astNode1 = this.oclFactory.createCollectionLiteralExp();
            this.initASTMapping(env, astNode1, oclExpressionCS, null);
            astNode1.setKind(CollectionKind.SET_LITERAL);
            if (astNode1 instanceof EModelElement) {
                EAnnotation implicitSetConversionAnnotation = ((EModelElement)astNode1).getEAnnotation(OCL_ANNOTATIONS_URI);
                if (implicitSetConversionAnnotation == null) {
                    implicitSetConversionAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    implicitSetConversionAnnotation.setSource(OCL_ANNOTATIONS_URI);
                    ((EModelElement)astNode1).getEAnnotations().add((Object)implicitSetConversionAnnotation);
                }
                implicitSetConversionAnnotation.getDetails().put((Object)IMPLICIT_SET_CONVERSION, (Object)"true");
            }
            EList collectionParts = astNode1.getPart();
            CollectionItem<C> collItem = this.oclFactory.createCollectionItem();
            this.initASTMapping(env, collItem, oclExpressionCS, null);
            collItem.setType(astNode.getType());
            collItem.setItem(astNode);
            collectionParts.add(collItem);
            C type = this.getCollectionType(oclExpressionCS, env, astNode1.getKind(), astNode.getType());
            astNode1.setType(type);
            if (this.isErrorNode(astNode)) {
                this.markAsErrorNode(astNode1);
            }
            astNode = astNode1;
        }
        return astNode;
    }

    protected IteratorExp<C, PM> iteratorExpCS(IteratorExpCS iteratorExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> source = this.getCollectionSourceExpression(iteratorExpCS.getSource(), env);
        if (source == null) {
            return null;
        }
        String name = iteratorExpCS.getSimpleNameCS().getValue();
        Variable vdcl = null;
        Variable vdcl1 = null;
        IteratorExp astNode = this.oclFactory.createIteratorExp();
        this.initASTMapping(env, astNode, iteratorExpCS);
        astNode.setName(name);
        this.resolveIteratorOperation(iteratorExpCS.getSimpleNameCS(), env);
        EList iterators = astNode.getIterator();
        if (iteratorExpCS.getVariable1() != null) {
            CollectionType ct;
            Object sourceType;
            vdcl = this.variableDeclarationCS(iteratorExpCS.getVariable1(), env, true);
            if (vdcl.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                ct = (CollectionType)sourceType;
                vdcl.setType(ct.getElementType());
            }
            iterators.add(vdcl);
            if (iteratorExpCS.getVariable2() != null) {
                vdcl1 = this.variableDeclarationCS(iteratorExpCS.getVariable2(), env, true);
                if (vdcl1.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                    ct = (CollectionType)sourceType;
                    vdcl1.setType(ct.getElementType());
                }
                iterators.add(vdcl1);
            }
        } else {
            CollectionType ct = (CollectionType)source.getType();
            vdcl = this.genVariableDeclaration(iteratorExpCS, "iteratorExpCS", env, null, ct.getElementType(), null, false, true, false);
            iterators.add(vdcl);
        }
        OCLExpressionCS exprCS = iteratorExpCS.getBody();
        OCLExpression<C> expr = null;
        if (this.isErrorNode(source)) {
            expr = this.createDummyInvalidLiteralExp(env, iteratorExpCS);
            this.markAsErrorNode(astNode);
        } else {
            expr = this.oclExpressionCS(exprCS, env);
        }
        this.TRACE("oclIteratorExpCS: ", name);
        if (name.equals("forAll") || name.equals("exists") || name.equals("one") || name.equals("isUnique")) {
            astNode.setType(env.getOCLStandardLibrary().getBoolean());
        } else if (name.equals("select") || name.equals("reject")) {
            astNode.setType(source.getType());
        } else if (name.equals("collect")) {
            Object elementType = expr.getType();
            if (elementType instanceof CollectionType) {
                CollectionType ct = (CollectionType)elementType;
                elementType = CollectionUtil.getFlattenedElementType(ct);
            }
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType(this.getSequenceType(exprCS, env, elementType));
            } else {
                astNode.setType(this.getBagType(exprCS, env, elementType));
            }
        } else if (name.equals("collectNested")) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType(this.getSequenceType(exprCS, env, expr.getType()));
            } else {
                astNode.setType(this.getBagType(exprCS, env, expr.getType()));
            }
        } else if (name.equals("any")) {
            CollectionType ct = (CollectionType)source.getType();
            astNode.setType(ct.getElementType());
        } else if (name.equals("sortedBy")) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof BagType) {
                CollectionType ct = (CollectionType)source.getType();
                astNode.setType(this.getSequenceType(exprCS, env, ct.getElementType()));
            } else {
                CollectionType ct = (CollectionType)source.getType();
                astNode.setType(this.getOrderedSetType(exprCS, env, ct.getElementType()));
            }
        } else if (name.equals("closure")) {
            Object bodyType = expr.getType();
            if (bodyType instanceof OrderedSetType || bodyType instanceof SequenceType) {
                CollectionType ct = (CollectionType)bodyType;
                bodyType = ct.getElementType();
                astNode.setType(this.getOrderedSetType(exprCS, env, bodyType));
            } else {
                if (bodyType instanceof CollectionType) {
                    CollectionType ct = (CollectionType)bodyType;
                    bodyType = ct.getElementType();
                }
                astNode.setType(this.getSetType(exprCS, env, bodyType));
            }
        }
        astNode.setBody(expr);
        astNode.setSource(source);
        env.deleteElement(vdcl.getName());
        if (vdcl1 != null) {
            env.deleteElement(vdcl1.getName());
        }
        return astNode;
    }

    protected void resolveIteratorOperation(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
    }

    protected IterateExp<C, PM> iterateExpCS(IterateExpCS iterateExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        String message;
        CollectionType ct;
        IterateExp astNode = null;
        OCLExpression<C> source = this.getCollectionSourceExpression(iterateExpCS.getSource(), env);
        if (source == null) {
            return null;
        }
        Variable<C, PM> vdcl = null;
        Variable<C, PM> vdcl1 = null;
        OCLExpression<C> expr = null;
        vdcl = this.variableDeclarationCS(iterateExpCS.getVariable1(), env, true);
        if (iterateExpCS.getVariable2() != null) {
            vdcl1 = this.variableDeclarationCS(iterateExpCS.getVariable2(), env, true);
        }
        if (vdcl1 == null) {
            vdcl1 = vdcl;
            vdcl = null;
        }
        if (vdcl == null) {
            ct = (CollectionType)source.getType();
            vdcl = this.genVariableDeclaration(iterateExpCS, "iterateExpCS", env, null, ct.getElementType(), null, false, true, false);
        }
        if (vdcl.getType() == null) {
            ct = (CollectionType)source.getType();
            vdcl.setType(ct.getElementType());
        }
        this.TRACE("iterateExpCS", "iterate");
        astNode = this.oclFactory.createIterateExp();
        this.initASTMapping(env, astNode, iterateExpCS);
        astNode.setName("iterate");
        this.resolveIteratorOperation(iterateExpCS.getSimpleNameCS(), env);
        if (this.isErrorNode(source)) {
            expr = this.createDummyInvalidLiteralExp(env, iterateExpCS);
            this.markAsErrorNode(astNode);
        } else {
            expr = this.oclExpressionCS(iterateExpCS.getBody(), env);
        }
        EList iterator = astNode.getIterator();
        iterator.add(vdcl);
        astNode.setSource(source);
        astNode.setResult(vdcl1);
        astNode.setBody(expr);
        if (vdcl1.getType() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, vdcl1.getName());
            this.ERROR(vdcl, "iterateExpCS", message);
            vdcl1.setType(this.createDummyInvalidType(env, iterateExpCS.getVariable1(), message));
        }
        astNode.setType(vdcl1.getType());
        if (vdcl1.getInitExpression() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, vdcl1.getName());
            this.ERROR(iterateExpCS.getVariable2(), "iterateExpCS", message);
        }
        if (vdcl.getInitExpression() != null) {
            message = OCLMessages.bind(OCLMessages.DeclarationInitExp_ERROR_, vdcl1.getName());
            this.ERROR(iterateExpCS.getVariable1(), "iterateExpCS", message);
        }
        env.deleteElement(vdcl.getName());
        env.deleteElement(vdcl1.getName());
        return astNode;
    }

    protected OCLExpression<C> modelPropertyCallExpCS(FeatureCallExpCS modelPropertyCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression astNode = null;
        if (modelPropertyCallExpCS instanceof OperationCallExpCS) {
            astNode = this.operationCallExpCS((OperationCallExpCS)modelPropertyCallExpCS, env);
        } else {
            OCLExpression<C> source = this.oclExpressionCS(modelPropertyCallExpCS.getSource(), env);
            if (source == null) {
                String message;
                C type;
                EList<String> sequenceOfNames = AbstractOCLAnalyzer.createSequenceOfNames(modelPropertyCallExpCS.getPathNameCS(), null);
                String lastToken = modelPropertyCallExpCS.getSimpleNameCS().getValue();
                Object literal = null;
                P attribute = null;
                C enumType = this.lookupClassifier(modelPropertyCallExpCS.getPathNameCS(), env, (List<String>)sequenceOfNames);
                if (enumType == null) {
                    sequenceOfNames.add((Object)lastToken);
                    type = this.lookupClassifier(modelPropertyCallExpCS.getSimpleNameCS(), env, (List<String>)sequenceOfNames);
                    if (type == null) {
                        message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, sequenceOfNames);
                        this.ERROR(modelPropertyCallExpCS, "enumerationOrClassLiteralExpCS", message);
                    } else {
                        astNode = this.typeCS(modelPropertyCallExpCS, env, type);
                        modelPropertyCallExpCS.getPathNameCS().setAst(this.uml.getPackage(type));
                    }
                } else {
                    if (this.uml.isEnumeration(enumType)) {
                        literal = this.uml.getEnumerationLiteral(enumType, lastToken);
                        if (literal == null && AbstractOCLAnalyzer.isEscaped(lastToken)) {
                            literal = this.uml.getEnumerationLiteral(enumType, AbstractOCLAnalyzer.unescape(lastToken));
                        }
                        if (literal == null) {
                            attribute = this.lookupProperty(modelPropertyCallExpCS, env, enumType, lastToken);
                        }
                    } else {
                        attribute = this.lookupProperty(modelPropertyCallExpCS, env, enumType, lastToken);
                    }
                    if (literal != null) {
                        astNode = this.oclFactory.createEnumLiteralExp();
                        this.initASTMapping(env, astNode, modelPropertyCallExpCS);
                        EnumLiteralExp litExp = astNode;
                        litExp.setReferredEnumLiteral(literal);
                        astNode = litExp;
                        astNode.setType(enumType);
                        modelPropertyCallExpCS.getSimpleNameCS().setAst(literal);
                    } else if (attribute != null) {
                        if (!this.uml.isStatic(attribute)) {
                            String message2 = OCLMessages.bind(OCLMessages.NonStaticAttribute_ERROR_, lastToken);
                            this.ERROR(modelPropertyCallExpCS.getSimpleNameCS(), "enumerationOrClassLiteralExpCS", message2);
                        }
                        PropertyCallExp pcExp = this.oclFactory.createPropertyCallExp();
                        this.initASTMapping(env, pcExp, modelPropertyCallExpCS);
                        astNode = pcExp;
                        modelPropertyCallExpCS.getSimpleNameCS().setAst(attribute);
                        modelPropertyCallExpCS.getPathNameCS().setAst(enumType);
                        TypeExp<C> typeExp = this.typeCS(modelPropertyCallExpCS, env, enumType);
                        this.initStartEndPositions(typeExp, modelPropertyCallExpCS.getPathNameCS());
                        pcExp.setSource(typeExp);
                        pcExp.setReferredProperty(attribute);
                        pcExp.setType(this.getPropertyType(modelPropertyCallExpCS.getSimpleNameCS(), env, enumType, attribute));
                        this.initPropertyPositions(pcExp, modelPropertyCallExpCS.getSimpleNameCS());
                    } else {
                        sequenceOfNames.add((Object)lastToken);
                        type = this.lookupClassifier(modelPropertyCallExpCS.getSimpleNameCS(), env, (List<String>)sequenceOfNames);
                        if (type == null) {
                            message = OCLMessages.bind(OCLMessages.UnrecognizedEnum_ERROR_, lastToken);
                            this.ERROR(modelPropertyCallExpCS, "enumerationOrClassLiteralExpCS", message);
                        } else {
                            astNode = this.typeCS(modelPropertyCallExpCS, env, type);
                            modelPropertyCallExpCS.getSimpleNameCS().setAst(type);
                            modelPropertyCallExpCS.getPathNameCS().setAst(this.uml.getPackage(type));
                        }
                    }
                }
                if (astNode == null) {
                    astNode = this.createDummyInvalidLiteralExp(env, modelPropertyCallExpCS);
                }
                String traceText = new String();
                for (String next : sequenceOfNames) {
                    traceText = String.valueOf(traceText) + next + "::";
                }
                traceText = String.valueOf(traceText) + lastToken;
                this.TRACE("enumerationOrClassLiteralExpCS", traceText);
                return astNode;
            }
            astNode = this.simpleNameCS(modelPropertyCallExpCS.getSimpleNameCS(), env, source);
            List<OCLExpression<C>> qualifiers = this.qualifiersCS((List<OCLExpressionCS>)modelPropertyCallExpCS.getArguments(), env, astNode);
            if (this.isAtPre(modelPropertyCallExpCS)) {
                if (astNode instanceof FeatureCallExp) {
                    ((FeatureCallExp)astNode).setMarkedPre(true);
                } else {
                    this.ERROR(modelPropertyCallExpCS.getIsMarkedPreCS(), "modelPropertyCallExpCS", OCLMessages.IllegalAtPre_ERROR_);
                }
            }
            if (!qualifiers.isEmpty()) {
                if (astNode instanceof NavigationCallExp) {
                    NavigationCallExp callNode = (NavigationCallExp)astNode;
                    this.setQualifiers(env, "modelPropertyCallExpCS", callNode, qualifiers);
                } else if (astNode instanceof LoopExp && this.getLoopBody(astNode) instanceof NavigationCallExp) {
                    NavigationCallExp nav = (NavigationCallExp)this.getLoopBody(astNode);
                    this.setQualifiers(env, "modelPropertyCallExpCS", nav, qualifiers);
                } else {
                    this.ERROR(modelPropertyCallExpCS, "modelPropertyCallExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(modelPropertyCallExpCS)));
                }
            } else if (astNode instanceof AssociationClassCallExp) {
                AssociationClassCallExp callNode = (AssociationClassCallExp)astNode;
                this.checkNotReflexive(env, "modelPropertyCallExpCS", callNode);
            }
            this.initASTMapping(env, astNode, modelPropertyCallExpCS);
        }
        return astNode;
    }

    protected OCLExpression<C> getLoopBody(OCLExpression<C> expr) {
        return ((LoopExp)expr).getBody();
    }

    protected OCLExpression<C> operationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        boolean isImplicitCollect;
        int operator = operationCallExpCS.getAccessor().getValue();
        if (operator == 3) {
            return this.arrowOperationCallExpCS(operationCallExpCS, env);
        }
        OCLExpressionCS sourceCS = operationCallExpCS.getSource();
        if (sourceCS == null && operationCallExpCS.getPathNameCS() != null) {
            return this.staticOperationCallExpCS(operationCallExpCS, env);
        }
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        if ("oclIsInState".equals(operationName)) {
            return this.oclIsInStateOperationCallExpCS(operationCallExpCS, env);
        }
        if (ParsingOptions.getValue(env, ParsingOptions.WARN_OF_XOR_OR_AND_PRECEDENCE_CHANGE).booleanValue()) {
            this.checkForXorOrAndPrecedenceHazard(operationCallExpCS);
        }
        OCLExpression<C> source = this.oclExpressionCS(operationCallExpCS.getSource(), env);
        List<OCLExpression<C>> args = this.argumentsCS(operationCallExpCS, env);
        if (source == null) {
            source = this.createImplicitSource(operationCallExpCS, env, args);
        }
        Object operationSourceType = source.getType();
        boolean bl = isImplicitCollect = operator == 2 && operationSourceType instanceof CollectionType;
        if (isImplicitCollect) {
            CollectionType ct = (CollectionType)operationSourceType;
            operationSourceType = ct.getElementType();
        }
        boolean isStatic = operationSourceType instanceof TypeType;
        OperationCallExp<C, O> astNode = this.genOperationCallExp(env, operationCallExpCS, "operationCallExpCS", operationName, source, operationSourceType, args);
        if (isStatic) {
            TypeType typeType = (TypeType)operationSourceType;
            O operation = astNode.getReferredOperation();
            if (!typeType.oclOperations().contains(operation) && !this.uml.isStatic(operation)) {
                String message = OCLMessages.bind(OCLMessages.NonStaticOperation_ERROR_, operationName);
                this.ERROR(astNode, "operationCallExpCS", message);
            }
        }
        astNode.setMarkedPre(this.isAtPre(operationCallExpCS));
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        CallExp result = astNode;
        if (isImplicitCollect) {
            result = this.createImplicitCollect(source, astNode, env, operationCallExpCS);
        }
        if (this.isErrorNode(source)) {
            this.markAsErrorNode(result);
        }
        return result;
    }

    protected OCLExpression<C> createImplicitSource(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<OCLExpression<C>> args) {
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        Variable<C, PM> implicitSource = this.lookupImplicitSourceForOperation(operationCallExpCS, env, args, operationName);
        VariableExp<C, PM> vexp = this.createVariableExp(env, operationCallExpCS, implicitSource);
        if (implicitSource == null) {
            String errMessage = String.valueOf(operationName) + "(";
            int i = 0;
            while (i < args.size()) {
                if (i > 0) {
                    errMessage = String.valueOf(errMessage) + ", ";
                }
                errMessage = String.valueOf(errMessage) + this.uml.getName(args.get(i).getType());
                ++i;
            }
            errMessage = String.valueOf(errMessage) + ")";
            String message = OCLMessages.bind(OCLMessages.IllegalSignature_ERROR_, errMessage);
            this.ERROR(operationCallExpCS, "operationCallExpCS", message);
        }
        if (implicitSource != null) {
            vexp.setType(implicitSource.getType());
            vexp.setReferredVariable(implicitSource);
        } else {
            vexp.setType(this.getOclVoid());
        }
        return vexp;
    }

    protected OCLExpression<C> arrowOperationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        OCLExpression<C> source = this.getCollectionSourceExpression(operationCallExpCS.getSource(), env);
        List<OCLExpression<C>> args = this.argumentsCS(operationCallExpCS, env);
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        Object operationSourceType = source.getType();
        OperationCallExp<C, O> astNode = this.genOperationCallExp(env, operationCallExpCS, "operationCallExpCS", operationName, source, operationSourceType, args);
        astNode.setMarkedPre(this.isAtPre(operationCallExpCS));
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        if (this.isErrorNode(source)) {
            this.markAsErrorNode(astNode);
        }
        return astNode;
    }

    protected OCLExpression<C> oclIsInStateOperationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        if (operationCallExpCS.getArguments().size() != 1) {
            String message = OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS));
            this.ERROR(operationCallExpCS, "operationCallExpCS", message);
        }
        OCLExpression<C> source = this.oclExpressionCS(operationCallExpCS.getSource(), env);
        ArrayList<OCLExpression<C>> args = new ArrayList<OCLExpression<C>>();
        if (!operationCallExpCS.getArguments().isEmpty()) {
            EList<String> statePath;
            OCLExpressionCS stateName;
            OCLExpressionCS arg = (OCLExpressionCS)operationCallExpCS.getArguments().get(0);
            if (arg instanceof VariableExpCS) {
                stateName = (VariableExpCS)arg;
                statePath = AbstractOCLAnalyzer.createSequenceOfNames(null, stateName.getSimpleNameCS());
                args.add(this.stateExpCS(source, stateName, statePath, env));
            } else if (arg instanceof FeatureCallExpCS) {
                stateName = (FeatureCallExpCS)arg;
                statePath = AbstractOCLAnalyzer.createSequenceOfNames(stateName.getPathNameCS(), stateName.getSimpleNameCS());
                args.add(this.stateExpCS(source, stateName, statePath, env));
                stateName.getSource();
                stateName.getIsMarkedPreCS();
            } else {
                String message = OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS));
                this.ERROR(arg, "operationCallExpCS", message);
            }
        }
        if (source == null) {
            source = this.createImplicitSource(operationCallExpCS, env, args);
        }
        Object operationSourceType = source.getType();
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        OperationCallExp<C, O> astNode = this.genOperationCallExp(env, operationCallExpCS, "operationCallExpCS", operationName, source, operationSourceType, args);
        astNode.setMarkedPre(this.isAtPre(operationCallExpCS));
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        if (this.isErrorNode(source)) {
            this.markAsErrorNode(astNode);
        }
        return astNode;
    }

    protected OCLExpression<C> staticOperationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        EList<String> pathNames;
        TypeExp<C> source = null;
        PathNameCS pathNameCS = operationCallExpCS.getPathNameCS();
        C sourceType = this.lookupClassifier(pathNameCS, env, (List<String>)(pathNames = AbstractOCLAnalyzer.createSequenceOfNames(pathNameCS, null)));
        if (sourceType == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, pathNames);
            this.ERROR(operationCallExpCS, "operatonCallExpCS", message);
        } else {
            source = this.typeCS(pathNameCS, env, sourceType);
        }
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        List<OCLExpression<C>> args = this.argumentsCS(operationCallExpCS, env);
        C operationSourceType = source != null ? (C)source.getType() : null;
        boolean isStatic = operationSourceType instanceof TypeType;
        OperationCallExp<Object, O> astNode = this.genOperationCallExp(env, operationCallExpCS, "operationCallExpCS", operationName, source, operationSourceType, args);
        if (isStatic) {
            boolean isTypeTypeOperation;
            TypeType typeType = (TypeType)operationSourceType;
            O operation = astNode.getReferredOperation();
            boolean bl = isTypeTypeOperation = typeType != null && typeType.oclOperations().contains(operation);
            if (!isTypeTypeOperation && !this.uml.isStatic(operation)) {
                String message = OCLMessages.bind(OCLMessages.NonStaticOperation_ERROR_, operationName);
                this.ERROR(astNode, "operationCallExpCS", message);
            }
        }
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        OperationCallExp<Object, O> result = astNode;
        if (this.isErrorNode(source)) {
            this.markAsErrorNode(result);
        }
        return result;
    }

    protected List<OCLExpression<C>> argumentsCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        ArrayList<OCLExpression<C>> args = new ArrayList<OCLExpression<C>>();
        for (OCLExpressionCS arg : operationCallExpCS.getArguments()) {
            OCLExpression<C> argExpr = this.oclExpressionCS(arg, env);
            if (argExpr == null) {
                argExpr = this.createDummyInvalidLiteralExp(env, arg);
                this.initASTMapping(env, argExpr, arg);
            }
            args.add(argExpr);
        }
        return args;
    }

    private void checkForXorOrAndPrecedenceHazard(OperationCallExpCS operationCallExpCS) {
        OCLExpressionCS childExpression;
        String parentOperationName = operationCallExpCS.getSimpleNameCS().getValue();
        if ("xor".equals(parentOperationName)) {
            OCLExpressionCS childExpression2 = (OCLExpressionCS)operationCallExpCS.getArguments().get(0);
            if (childExpression2 instanceof OperationCallExpCS) {
                OperationCallExpCS childOperationCallExpCS = (OperationCallExpCS)childExpression2;
                String childOperationName = childOperationCallExpCS.getSimpleNameCS().getValue();
                if (!childOperationCallExpCS.getIsAtomic().booleanValue() && ("or".equals(childOperationName) || "and".equals(childOperationName))) {
                    this.getEnvironment().analyzerWarning(OCLMessages.XorOrAndPrecedence_WARNING, "operationCallExpCS", operationCallExpCS);
                }
            }
        } else if ("or".equals(parentOperationName) && (childExpression = (OCLExpressionCS)operationCallExpCS.getArguments().get(0)) instanceof OperationCallExpCS) {
            OperationCallExpCS childOperationCallExpCS = (OperationCallExpCS)childExpression;
            String childOperationName = childOperationCallExpCS.getSimpleNameCS().getValue();
            if (!childOperationCallExpCS.getIsAtomic().booleanValue() && "and".equals(childOperationName)) {
                this.getEnvironment().analyzerWarning(OCLMessages.XorOrAndPrecedence_WARNING, "operationCallExpCS", operationCallExpCS);
            }
        }
    }

    protected OCLExpression<C> messageExpCS(MessageExpCS messageExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        EList arguments;
        OCLExpression<C> target = this.oclExpressionCS(messageExpCS.getTarget(), env);
        String name = messageExpCS.getSimpleNameCS().getValue();
        EList<OCLMessageArgCS> argsCS = messageExpCS.getArguments();
        if (argsCS.isEmpty()) {
            arguments = ECollections.emptyEList();
        } else {
            arguments = new BasicEList();
            for (OCLMessageArgCS argCS : argsCS) {
                OCLExpression<C> arg;
                if (argCS.getExpression() == null) {
                    arg = this.oclFactory.createUnspecifiedValueExp();
                    this.initASTMapping(env, arg, argCS);
                    this.initStartEndPositions(arg, argCS);
                    if (argCS.getTypeCS() == null) {
                        arg.setType(env.getOCLStandardLibrary().getOclVoid());
                    } else {
                        arg.setType(this.typeCS(argCS.getTypeCS(), env));
                        this.initTypePositions((UnspecifiedValueExp)arg, argCS.getTypeCS());
                    }
                } else {
                    arg = this.oclExpressionCS(argCS.getExpression(), env);
                }
                arguments.add(arg);
            }
        }
        O calledOperation = this.lookupOperation(messageExpCS, env, target.getType(), name, (List<? extends TypedElement<C>>)arguments);
        C receivedSignal = this.lookupSignal(messageExpCS, env, target.getType(), name, (List<? extends TypedElement<C>>)arguments);
        if (calledOperation == null && receivedSignal == null) {
            this.ERROR(messageExpCS, "messageExpCS", OCLMessages.bind(OCLMessages.UnrecognizedMessageType_ERROR_, name));
        } else if (calledOperation != null && receivedSignal != null) {
            this.ERROR(messageExpCS, "messageExpCS", OCLMessages.bind(OCLMessages.AmbiguousMessageType_ERROR_, name));
        }
        MessageExp<C, COA, SSA> result = this.oclFactory.createMessageExp();
        this.initASTMapping(env, result, messageExpCS);
        this.initStartEndPositions(result, messageExpCS);
        this.initPropertyPositions(result, messageExpCS.getSimpleNameCS());
        result.setTarget(target);
        result.getArgument().addAll((Collection)arguments);
        EObject behavioralFeature = null;
        if (calledOperation != null) {
            COA callAction = this.uml.createCallOperationAction(calledOperation);
            this.initASTMapping(env, callAction, messageExpCS.getSimpleNameCS());
            result.setCalledOperation(callAction);
            behavioralFeature = (EObject)calledOperation;
        } else if (receivedSignal != null) {
            SSA sendAction = this.uml.createSendSignalAction(receivedSignal);
            this.initASTMapping(env, sendAction, messageExpCS.getSimpleNameCS());
            result.setSentSignal(sendAction);
            behavioralFeature = (EObject)receivedSignal;
        }
        if (messageExpCS.getKind() == MessageExpKind.HAS_SENT_LITERAL) {
            result.setType(env.getOCLStandardLibrary().getBoolean());
        } else if (behavioralFeature != null && this.uml.isOperation(behavioralFeature)) {
            result.setType(this.getSequenceType(messageExpCS, env, this.getOperationMessageType(messageExpCS, env, calledOperation)));
        } else if (receivedSignal != null) {
            result.setType(this.getSequenceType(messageExpCS, env, this.getSignalMessageType(messageExpCS, env, receivedSignal)));
        } else {
            result.setType(this.getOclVoid());
        }
        return result;
    }

    protected C getCommonSuperType(CSTNode cstNode, String rule, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        C commonType = TypeUtil.commonSuperType(cstNode, env, type1, type2);
        if (commonType == null) {
            commonType = env.getOCLStandardLibrary().getOclVoid();
        }
        return commonType;
    }

    protected C getOCLType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object metaElement) {
        return TypeUtil.resolveType(env, this.uml.getOCLType(metaElement));
    }

    protected C getSetType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        C setType = TypeUtil.resolveSetType(env, elementType);
        this.initASTMapping(env, setType, cstNode);
        return setType;
    }

    protected C getOrderedSetType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        C orderedSetType = TypeUtil.resolveOrderedSetType(env, elementType);
        this.initASTMapping(env, orderedSetType, cstNode);
        return orderedSetType;
    }

    protected C getBagType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        C bagType = TypeUtil.resolveBagType(env, elementType);
        this.initASTMapping(env, bagType, cstNode);
        return bagType;
    }

    protected C getSequenceType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        C sequenceType = TypeUtil.resolveSequenceType(env, elementType);
        this.initASTMapping(env, sequenceType, cstNode);
        return sequenceType;
    }

    protected C getCollectionType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CollectionKind kind, C elementType) {
        C collectionType = this.getCollectionType(env, kind, elementType);
        this.initASTMapping(env, collectionType, cstNode);
        return collectionType;
    }

    @Deprecated
    protected C getCollectionType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CollectionKind kind, C elementType) {
        return TypeUtil.resolveCollectionType(env, kind, elementType);
    }

    protected C getTupleType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EList<? extends TypedElement<C>> parts) {
        C tupleType = TypeUtil.resolveTupleType(env, parts);
        this.initASTMapping(env, tupleType, cstNode);
        return tupleType;
    }

    protected C getTypeType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        C typeType = TypeUtil.resolveTypeType(env, type);
        this.initASTMapping(env, typeType, cstNode);
        return typeType;
    }

    protected C getOperationMessageType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        C operationMessageType = TypeUtil.resolveOperationMessageType(env, operation);
        this.initASTMapping(env, operationMessageType, cstNode);
        return operationMessageType;
    }

    protected C getSignalMessageType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C signal) {
        C signalMessageType = TypeUtil.resolveSignalMessageType(env, signal);
        this.initASTMapping(env, signalMessageType, cstNode);
        return signalMessageType;
    }

    protected C getPropertyType(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, P property) {
        C propertyType = TypeUtil.getPropertyType(env, owner, property);
        this.initASTMapping(env, propertyType, cstNode, property);
        return propertyType;
    }

    protected C getElementType(C possibleCollectionType) {
        if (possibleCollectionType instanceof CollectionType) {
            return ((CollectionType)possibleCollectionType).getElementType();
        }
        return possibleCollectionType;
    }

    protected CollectionKind getCollectionKind(C possibleCollectionType) {
        if (possibleCollectionType instanceof CollectionType) {
            return ((CollectionType)possibleCollectionType).getKind();
        }
        return null;
    }

    @Deprecated
    protected InvalidLiteralExp<C> createDummyInvalidLiteralExp() {
        InvalidLiteralExp<C> result = this.oclFactory.createInvalidLiteralExp();
        result.setType(this.getStandardLibrary().getOclInvalid());
        this.markAsErrorNode(result);
        return result;
    }

    protected InvalidLiteralExp<C> createDummyInvalidLiteralExp(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CSTNode cstNode) {
        InvalidLiteralExp<C> result = this.createDummyInvalidLiteralExp();
        this.initASTMapping(env, result, cstNode);
        return result;
    }

    protected C createDummyInvalidType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CSTNode cstNode, String message) {
        C astNode = this.getOclVoid();
        cstNode.setAst(astNode);
        return astNode;
    }

    protected Object createDummyPackage(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, PackageDeclarationCS packageDeclarationCS) {
        return null;
    }

    protected boolean isErrorNode(TypedElement<C> expr) {
        return false;
    }

    protected void markAsErrorNode(TypedElement<C> expr) {
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createPackageContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, List<String> packageName) throws LookupException {
        EnvironmentFactory.Lookup lookup = OCLUtil.getAdapter(this.environmentFactory, EnvironmentFactory.Lookup.class);
        return lookup.tryCreatePackageContext(parent, packageName);
    }

    protected C lookupClassifier(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<String> className) {
        try {
            Environment.Lookup lookup = OCLUtil.getAdapter(env, Environment.Lookup.class);
            Object classifier = lookup.tryLookupClassifier(className);
            if (cstNode != null) {
                cstNode.setAst(classifier);
            }
            return classifier;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return (C)(e.getAmbiguousMatches().isEmpty() ? env.getOCLStandardLibrary().getOclVoid() : e.getAmbiguousMatches().get(0));
        }
    }

    protected Variable<C, PM> lookupImplicitSourceForOperation(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<OCLExpression<C>> args, String operationName) {
        return env.lookupImplicitSourceForOperation(operationName, args);
    }

    protected O lookupOperation(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name, List<? extends TypedElement<C>> args) {
        try {
            Environment.Lookup lookup = OCLUtil.getAdapter(env, Environment.Lookup.class);
            Object operation = lookup.tryLookupOperation(owner, name, args);
            if (cstNode != null) {
                cstNode.setAst(operation);
            }
            return operation;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (O)e.getAmbiguousMatches().get(0);
        }
    }

    protected P lookupProperty(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name) {
        try {
            Environment.Lookup lookup = OCLUtil.getAdapter(env, Environment.Lookup.class);
            Object property = lookup.tryLookupProperty(owner, name);
            if (cstNode != null) {
                cstNode.setAst(property);
            }
            return property;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (P)e.getAmbiguousMatches().get(0);
        }
    }

    protected C lookupAssociationClassReference(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name) {
        try {
            Environment.Lookup lookup = OCLUtil.getAdapter(env, Environment.Lookup.class);
            C associationClassReference = lookup.tryLookupAssociationClassReference(owner, name);
            if (cstNode != null && associationClassReference != null) {
                cstNode.setAst(associationClassReference);
            }
            return associationClassReference;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (C)e.getAmbiguousMatches().get(0);
        }
    }

    protected C lookupSignal(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name, List<? extends TypedElement<C>> args) {
        try {
            Environment.Lookup lookup = OCLUtil.getAdapter(env, Environment.Lookup.class);
            C signal = lookup.tryLookupSignal(owner, name, args);
            if (cstNode != null) {
                cstNode.setAst(signal);
            }
            return signal;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (C)e.getAmbiguousMatches().get(0);
        }
    }

    protected S lookupState(CSTNode cstNode, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C sourceType, List<String> statePath) {
        try {
            S state = env.lookupState(sourceType, statePath);
            if (cstNode != null) {
                cstNode.setAst(state);
            }
            return state;
        }
        catch (LookupException e) {
            this.ERROR(cstNode, null, e.getMessage());
            return e.getAmbiguousMatches().isEmpty() ? null : (S)e.getAmbiguousMatches().get(0);
        }
        catch (SemanticException e) {
            this.ERROR(cstNode, "stateExpCS", e.getMessage());
            return null;
        }
    }

    protected ExpressionInOCL<C, PM> createExpressionInOCL() {
        return this.uml.createExpressionInOCL();
    }

    protected CT createConstraint() {
        return this.uml.createConstraint();
    }

    protected void initASTMapping(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object astNode, CSTNode cstNode) {
        this.initASTMapping(env, astNode, cstNode, astNode);
    }

    protected void initASTMapping(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object fromAstNode, CSTNode cstNode, Object toAstNode) {
        OCLUtil.getAdapter(env, BasicEnvironment2.class).initASTMapping(fromAstNode, cstNode, toAstNode);
    }

    public static EList<String> createSequenceOfNames(PathNameCS pathNameCS, SimpleNameCS simpleNameCS) {
        BasicEList sequenceOfNames = new BasicEList();
        if (pathNameCS != null) {
            for (SimpleNameCS simpleName : pathNameCS.getSimpleNames()) {
                sequenceOfNames.add((Object)simpleName.getValue());
            }
        }
        if (simpleNameCS != null) {
            sequenceOfNames.add((Object)simpleNameCS.getValue());
        }
        return sequenceOfNames;
    }

    public static boolean isEscaped(String name) {
        return name != null && name.startsWith(OCL_ESCAPE_PREFIX);
    }

    public static String unescape(String name) {
        return name.substring(OCL_ESCAPE_LENGTH);
    }

    public static boolean equalName(String name, String elementName) {
        boolean result = name.equals(elementName);
        if (!result && AbstractOCLAnalyzer.isEscaped(name)) {
            result = AbstractOCLAnalyzer.unescape(name).equals(elementName);
        }
        return result;
    }
}

