/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.evaluation.IterationTemplate;
import org.eclipse.ocl.options.EvaluationOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationTemplateClosure<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private OCLExpression<C> body;
    private int depth = 0;
    private boolean closureIncludesSources;

    private IterationTemplateClosure(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v, OCLExpression<C> body) {
        super(v);
        this.body = body;
        this.closureIncludesSources = EvaluationOptions.getValue(v.getEvaluationEnvironment(), EvaluationOptions.CLOSURE_INCLUDES_SOURCES);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getInstance(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v, OCLExpression<C> body) {
        return new IterationTemplateClosure<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(v, body);
    }

    @Override
    protected Object evaluateResult(List<Variable<C, PM>> iterators, String resultName, Object bodyVal) {
        String iterName;
        Object currObj;
        if (bodyVal == this.getInvalid()) {
            this.setDone(true);
            return this.getInvalid();
        }
        EvaluationEnvironment env = this.getEvalEnvironment();
        Collection results = (Collection)env.getValueOf(resultName);
        if ((this.closureIncludesSources || this.depth > 0) && !results.add(currObj = env.getValueOf(iterName = iterators.get(0).getName()))) {
            return results;
        }
        if (bodyVal != null) {
            try {
                ++this.depth;
                Set<Object> bodyColl = bodyVal instanceof Collection ? (Set<Object>)bodyVal : Collections.singleton(bodyVal);
                Object[] iteratorValues = this.pauseIterators(iterators);
                this.evaluate(bodyColl, iterators, this.body, resultName);
                this.resumeIterators(iterators, iteratorValues);
            }
            finally {
                --this.depth;
            }
        }
        return results;
    }

    private Object[] pauseIterators(List<Variable<C, PM>> iterators) {
        Object[] result = new Object[iterators.size()];
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = result.length;
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            result[i] = env.remove(iterDecl.getName());
            ++i;
        }
        return result;
    }

    private void resumeIterators(List<Variable<C, PM>> iterators, Object[] values) {
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = values.length;
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            env.add(iterDecl.getName(), values[i]);
            ++i;
        }
    }
}

