/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.filterSynthesis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.NavigationCallExp;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.impl.TypeExpImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSynthesisImpl
extends AbstractVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>
implements OperationBodyToCallMapper {
    private final boolean notifyNewContextElements;
    protected final Set<EventFilter> filters = new HashSet<EventFilter>();
    private final Map<org.eclipse.ocl.ecore.OCLExpression, Set<OperationCallExp>> visitedOperationBodies = new LinkedHashMap<org.eclipse.ocl.ecore.OCLExpression, Set<OperationCallExp>>();
    private final Map<EAttribute, Set<PropertyCallExp>> attributeCallExpressions = new HashMap<EAttribute, Set<PropertyCallExp>>();
    protected final Map<EReference, Set<NavigationCallExp>> associationEndCallExpressions = new HashMap<EReference, Set<NavigationCallExp>>();
    private final Set<org.eclipse.ocl.ecore.OCLExpression> visitedExpressions = new HashSet<org.eclipse.ocl.ecore.OCLExpression>();
    private final Map<EClassifier, Set<OperationCallExp>> allInstancesCalls = new HashMap<EClassifier, Set<OperationCallExp>>();
    private final Stack<org.eclipse.ocl.ecore.OCLExpression> visitedOperationBodyStack = new Stack();
    private final Map<org.eclipse.ocl.ecore.OCLExpression, Set<Variable>> selfVariablesUsedInBody = new HashMap<org.eclipse.ocl.ecore.OCLExpression, Set<Variable>>();
    private final Map<org.eclipse.ocl.ecore.OCLExpression, Set<Variable>> parameterVariablesUsedInBody = new HashMap<org.eclipse.ocl.ecore.OCLExpression, Set<Variable>>();
    private final OCL ocl;
    private final Map<org.eclipse.ocl.ecore.OCLExpression, Set<PropertyCallExp>> derivedProperties = new HashMap<org.eclipse.ocl.ecore.OCLExpression, Set<PropertyCallExp>>();
    private final Stack<org.eclipse.ocl.ecore.OCLExpression> derivedPropertiesStack = new Stack();

    public FilterSynthesisImpl(org.eclipse.ocl.ecore.OCLExpression expression, boolean notifyNewContextElements, OCL ocl) {
        this.notifyNewContextElements = notifyNewContextElements;
        this.ocl = ocl;
        this.walk(expression);
    }

    public EPackage handlePropertyCallExp(org.eclipse.ocl.expressions.PropertyCallExp<EClassifier, EStructuralFeature> propCallExp, EPackage sourceResult, List<EPackage> qualifierResults) {
        Set<PropertyCallExp> set;
        EClass cls = (EClass)propCallExp.getSource().getType();
        EStructuralFeature property = (EStructuralFeature)propCallExp.getReferredProperty();
        if (cls instanceof TupleType) {
            return (EPackage)this.result;
        }
        if (property.isDerived()) {
            org.eclipse.ocl.ecore.OCLExpression body = SettingBehavior.INSTANCE.getFeatureBody(this.ocl, property);
            Set<PropertyCallExp> callsForProperty = this.derivedProperties.get(body);
            if (callsForProperty == null) {
                callsForProperty = new HashSet<PropertyCallExp>();
                this.derivedProperties.put(body, callsForProperty);
                this.derivedPropertiesStack.push(body);
                this.walk(body);
                this.derivedPropertiesStack.pop();
            }
            callsForProperty.add((PropertyCallExp)propCallExp);
        }
        if (property instanceof EAttribute) {
            this.filters.add(EventManagerFactory.eINSTANCE.createFilterForEAttribute(cls, (EAttribute)property));
            EAttribute refAttr = (EAttribute)property;
            set = this.attributeCallExpressions.get(refAttr);
            if (set == null) {
                set = new HashSet<PropertyCallExp>();
                this.attributeCallExpressions.put(refAttr, set);
            }
            set.add((PropertyCallExp)propCallExp);
        } else if (propCallExp.getReferredProperty() instanceof EReference) {
            this.filters.add(EventManagerFactory.eINSTANCE.createFilterForEReference(cls, (EReference)property));
            EReference refRef = (EReference)property;
            set = this.associationEndCallExpressions.get(refRef);
            if (set == null) {
                set = new HashSet<PropertyCallExp>();
                this.associationEndCallExpressions.put(refRef, set);
            }
            set.add((PropertyCallExp)propCallExp);
        } else {
            throw new RuntimeException("Unhandled subclass of EStructuralFeature.");
        }
        return (EPackage)this.result;
    }

    public EPackage handleOperationCallExp(org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation> opCallExp, EPackage sourceResult, List<EPackage> qualifierResults) {
        org.eclipse.ocl.ecore.OCLExpression body;
        if (((EOperation)opCallExp.getReferredOperation()).getName().equals("allInstances")) {
            EClass cls = null;
            OCLExpression source = opCallExp.getSource();
            cls = source instanceof TypeExpImpl ? (EClass)((TypeExpImpl)source).getReferredType() : (EClass)source.getType();
            this.filters.add(this.createFilterForElementInsertionOrDeletion(cls));
            EClassifier classifier = (EClassifier)((TypeExp)opCallExp.getSource()).getReferredType();
            Set<OperationCallExp> set = this.allInstancesCalls.get(classifier);
            if (set == null) {
                set = new HashSet<OperationCallExp>();
                this.allInstancesCalls.put(classifier, set);
            }
            set.add((OperationCallExp)opCallExp);
        } else if (opCallExp.getOperationCode() <= 0 && (body = this.getOperationBody((EOperation)opCallExp.getReferredOperation())) != null) {
            Set<OperationCallExp> analyzedCallsToBody = this.visitedOperationBodies.get(body);
            if (analyzedCallsToBody == null) {
                analyzedCallsToBody = new HashSet<OperationCallExp>();
                analyzedCallsToBody.add((OperationCallExp)opCallExp);
                this.visitedOperationBodies.put(body, analyzedCallsToBody);
                this.visitedOperationBodyStack.push(body);
                this.walk(body);
                this.visitedOperationBodyStack.pop();
            } else {
                analyzedCallsToBody.add((OperationCallExp)opCallExp);
            }
        }
        return (EPackage)this.result;
    }

    public EPackage visitVariableExp(VariableExp<EClassifier, EParameter> var) {
        if (!this.visitedOperationBodyStack.isEmpty()) {
            org.eclipse.ocl.ecore.OCLExpression body = this.visitedOperationBodyStack.peek();
            EOperation operation = (EOperation)this.visitedOperationBodies.get(body).iterator().next().getReferredOperation();
            if (var.getName().equals("self")) {
                this.addSelfUsageForBody(var, body);
            } else {
                for (EParameter param : operation.getEParameters()) {
                    if (!var.getName().equals(param.getName())) continue;
                    Set<Variable> paramSet = this.parameterVariablesUsedInBody.get(body);
                    if (paramSet == null) {
                        paramSet = new HashSet<Variable>();
                        this.parameterVariablesUsedInBody.put(body, paramSet);
                    }
                    paramSet.add((Variable)var.getReferredVariable());
                    break;
                }
            }
        } else if (!this.derivedPropertiesStack.isEmpty() && var.getName().equals("self")) {
            org.eclipse.ocl.ecore.OCLExpression derivationExpression = this.derivedPropertiesStack.peek();
            this.addSelfUsageForBody(var, derivationExpression);
        } else {
            if (var.getName().equals("self")) {
                this.addSelfUsageForBody(var, OclHelper.getRootExpression(var));
            }
            if (this.notifyNewContextElements && var.getName().equals("self")) {
                EClass cls = (EClass)var.getType();
                this.filters.add(this.createFilterForElementInsertionOrDeletion(cls));
            }
        }
        return (EPackage)this.result;
    }

    private void addSelfUsageForBody(VariableExp<EClassifier, EParameter> var, org.eclipse.ocl.ecore.OCLExpression body) {
        Set<Variable> selfSet = this.selfVariablesUsedInBody.get(body);
        if (selfSet == null) {
            selfSet = new HashSet<Variable>();
            this.selfVariablesUsedInBody.put(body, selfSet);
        }
        selfSet.add((Variable)var.getReferredVariable());
    }

    @Override
    public Set<OperationCallExp> getCallsOf(org.eclipse.ocl.ecore.OCLExpression operationBodyExpression) {
        Set<Object> result = this.visitedOperationBodies.get(operationBodyExpression);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public EventFilter getSynthesisedFilter() {
        return EventManagerFactory.eINSTANCE.createOrFilterFor(this.filters.toArray(new EventFilter[this.filters.size()]));
    }

    public org.eclipse.ocl.ecore.OCLExpression getBodyForCall(OperationCallExp call) {
        for (Map.Entry<org.eclipse.ocl.ecore.OCLExpression, Set<OperationCallExp>> entry : this.visitedOperationBodies.entrySet()) {
            if (!entry.getValue().contains(call)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<PropertyCallExp> getAttributeCallExpressions(EAttribute a) {
        Set<PropertyCallExp> lookup = this.attributeCallExpressions.get(a);
        Set<PropertyCallExp> result = lookup == null ? Collections.emptySet() : Collections.unmodifiableSet(this.attributeCallExpressions.get(a));
        return result;
    }

    public Set<NavigationCallExp> getAssociationEndCallExpressions(EReference a) {
        Set<NavigationCallExp> lookup = this.associationEndCallExpressions.get(a);
        Set<NavigationCallExp> result = lookup == null ? Collections.emptySet() : Collections.unmodifiableSet(this.associationEndCallExpressions.get(a));
        return result;
    }

    public Set<OperationCallExp> getAllInstancesCallsFor(EClassifier c) {
        Set<Object> result = this.allInstancesCalls.get(c);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private EventFilter createFilterForElementInsertionOrDeletion(EClass clazz) {
        return EventManagerFactory.eINSTANCE.createFilterForElementInsertionOrDeletion(clazz);
    }

    private void walk(org.eclipse.ocl.ecore.OCLExpression expression) {
        if (!this.visitedExpressions.contains(expression)) {
            this.visitedExpressions.add(expression);
            this.safeVisit((Visitable)expression);
        }
    }

    @Override
    public Set<Variable> getSelfVariablesUsedInBody(org.eclipse.ocl.ecore.OCLExpression body) {
        Set<Object> result = this.selfVariablesUsedInBody.get(body);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    @Override
    public Set<Variable> getParameterVariablesUsedInBody(org.eclipse.ocl.ecore.OCLExpression body) {
        Set<Object> result = this.parameterVariablesUsedInBody.get(body);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    @Override
    public org.eclipse.ocl.ecore.OCLExpression getOperationBody(EOperation operation) {
        org.eclipse.ocl.ecore.OCLExpression body = InvocationBehavior.INSTANCE.getOperationBody(this.ocl, operation);
        return body;
    }

    public EPackage handleOppositePropertyCallExp(OppositePropertyCallExp callExp, EPackage sourceResult) {
        if (callExp.getReferredOppositeProperty() instanceof EReference) {
            EClass cls = (EClass)callExp.getReferredOppositeProperty().eContainer();
            this.filters.add(EventManagerFactory.eINSTANCE.createFilterForEReference(cls, callExp.getReferredOppositeProperty()));
            EReference refRef = callExp.getReferredOppositeProperty();
            Set<NavigationCallExp> set = this.associationEndCallExpressions.get(refRef);
            if (set == null) {
                set = new HashSet<NavigationCallExp>();
                this.associationEndCallExpressions.put(refRef, set);
            }
            set.add((NavigationCallExp)callExp);
        } else {
            System.err.println("Unhandled EStructuralFeature as referredOppositeProperty in FilterSynthesis.");
        }
        return (EPackage)this.result;
    }

    public EPackage visitOppositePropertyCallExp(OppositePropertyCallExp callExp) {
        EPackage sourceResult = (EPackage)this.safeVisit((Visitable)callExp.getSource());
        return this.handleOppositePropertyCallExp(callExp, sourceResult);
    }

    public Map<org.eclipse.ocl.ecore.OCLExpression, Set<PropertyCallExp>> getDerivedProperties() {
        return this.derivedProperties;
    }
}

