/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class SafeHandler
extends AbstractHandler {
    private Command command;
    private ISelection selection;

    public Command getCommand() {
        return this.command;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object result = null;
        try {
            this.extractEventDetails(event);
            result = this.safeExecute(event);
        }
        catch (ExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            MessageDialog.openError(null, (String)this.getText(), (String)(String.valueOf(ex.getLocalizedMessage()) + "\n" + Messages.getString("SafeActionDelegate_0")));
        }
        return result;
    }

    public void setEnabled(Object evaluationContext) {
        try {
            Object variable = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
            this.selection = variable instanceof ISelection ? (ISelection)variable : StructuredSelection.EMPTY;
            this.setBaseEnabled(this.updateSelection(this.selection));
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    protected void extractEventDetails(ExecutionEvent event) {
        this.setEnabled(event.getApplicationContext());
        this.command = event.getCommand();
    }

    protected abstract Object safeExecute(ExecutionEvent var1) throws Exception;

    protected String getText() {
        try {
            return this.command == null ? Messages.getString("SafeActionDelegate_1") : this.command.getName();
        }
        catch (NotDefinedException e) {
            return Messages.getString("SafeActionDelegate_1");
        }
    }

    protected boolean updateSelection(ISelection selection) {
        return true;
    }
}

