/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.identity.core.IIdentity;
import org.eclipse.mylyn.commons.identity.core.IIdentityService;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserAttributeEditor
extends AbstractAttributeEditor {
    private int imageSize = 48;
    private Label label;
    private IIdentity identity;
    private final PropertyChangeListener imageListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("image")) {
                final ProfileImage profileImage = (ProfileImage)event.getNewValue();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!UserAttributeEditor.this.label.isDisposed()) {
                            UserAttributeEditor.this.updateImage((IProfileImage)profileImage);
                        }
                    }
                });
            }
        }
    };
    private Image image;

    public UserAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
    }

    public UserAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute, int imageSize) {
        this(manager, taskAttribute);
        this.imageSize = imageSize;
    }

    protected Image updateImage(IProfileImage profileImage) {
        if (this.image != null) {
            this.image.dispose();
        }
        ImageData data = profileImage != null ? new ImageData((InputStream)new ByteArrayInputStream(profileImage.getData())) : CommonImages.PERSON_LARGE.getImageData();
        if (data.width != this.imageSize || data.height != this.imageSize) {
            data = data.scaledTo(this.imageSize, this.imageSize);
        }
        this.image = new Image((Device)this.label.getDisplay(), data);
        this.label.setImage(this.image);
        return this.image;
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        this.label = new Label(parent, 0);
        this.label.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (UserAttributeEditor.this.image != null) {
                    UserAttributeEditor.this.image.dispose();
                }
                if (UserAttributeEditor.this.identity != null) {
                    UserAttributeEditor.this.identity.removePropertyChangeListener(UserAttributeEditor.this.imageListener);
                }
            }
        });
        this.refresh();
        toolkit.adapt((Control)this.label, false, false);
        this.setControl((Control)this.label);
    }

    public Image getValue() {
        return this.image;
    }

    @Override
    protected boolean shouldAutoRefresh() {
        return false;
    }

    @Override
    public void refresh() {
        if (this.label.isDisposed()) {
            return;
        }
        if (this.identity != null) {
            this.identity.removePropertyChangeListener(this.imageListener);
        }
        if ("person".equals(this.getTaskAttribute().getMetaData().getType())) {
            IRepositoryPerson person = this.getTaskAttribute().getTaskData().getAttributeMapper().getRepositoryPerson(this.getTaskAttribute());
            this.label.setToolTipText(String.valueOf(this.getLabel()) + " " + person.toString());
        } else {
            this.label.setToolTipText(this.getDescription());
        }
        Account account = TasksUiInternal.getAccount(this.getTaskAttribute());
        IIdentityService identityService = TasksUiPlugin.getDefault().getIdentityService();
        if (identityService != null) {
            this.identity = identityService.getIdentity(account);
            this.identity.addPropertyChangeListener(this.imageListener);
            Future result = this.identity.requestImage(this.imageSize, this.imageSize);
            if (result.isDone()) {
                try {
                    this.updateImage((IProfileImage)result.get(0L, TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    this.updateImage(null);
                }
            } else {
                this.updateImage(null);
            }
        }
    }
}

