/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class BuildEditorPage
extends TaskFormPage {
    private boolean reflow;
    private final DataBindingContext dataBindingContext = new DataBindingContext();

    public BuildEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public BuildEditorPage(String id, String title) {
        super(id, title);
    }

    public BuildEditorInput getEditorInput() {
        return (BuildEditorInput)super.getEditorInput();
    }

    public DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    public boolean isReflow() {
        return this.reflow;
    }

    public void reflow() {
        if (this.reflow) {
            ScrolledForm form = this.getManagedForm().getForm();
            try {
                form.setRedraw(false);
                Rectangle parentClientArea = form.getParent().getClientArea();
                Point formSize = form.getSize();
                if (formSize.x != parentClientArea.width) {
                    ScrollBar verticalBar = form.getVerticalBar();
                    int verticalBarWidth = verticalBar != null ? verticalBar.getSize().x : 15;
                    form.setSize(parentClientArea.width - verticalBarWidth, formSize.y);
                }
                form.layout(true, false);
                form.reflow(true);
            }
            finally {
                form.setRedraw(true);
            }
        }
    }

    public void setReflow(boolean reflow) {
        this.reflow = reflow;
    }
}

