/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal.annotations;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarkerUtils {
    private static final int FILE_BUFFER_SIZE = 100;

    private MarkerUtils() {
    }

    public static void deleteMarkers(MemberDeclaration member, String markerId) {
        if (member.getPosition() == null || member.getPosition().file() == null) {
            return;
        }
        File javaFile = member.getPosition().file();
        Path javaPath = new Path(javaFile.getAbsolutePath());
        IFile javaResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)javaPath);
        try {
            javaResource.deleteMarkers(markerId, true, 1);
        }
        catch (CoreException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public static void createMarker(MemberDeclaration member, String message, String markerId) {
        if (member.getPosition() == null || member.getPosition().file() == null) {
            return;
        }
        File javaFile = member.getPosition().file();
        Path javaPath = new Path(javaFile.getAbsolutePath());
        IFile javaResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)javaPath);
        SourcePosition annotationPosition = null;
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().getDeclaration().getQualifiedName().equals(Parameter.class.getName())) continue;
            annotationPosition = annotationMirror.getPosition();
        }
        if (annotationPosition == null) {
            annotationPosition = member.getPosition();
        }
        try {
            IMarker marker = javaResource.createMarker(markerId);
            marker.setAttribute("severity", 2);
            MarkerUtils.computeMarkerPosition(marker, annotationPosition);
            marker.setAttribute("message", (Object)message);
        }
        catch (CoreException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public static void createMarkers(Collection<MemberDeclaration> members, String message, String markerId) {
        for (MemberDeclaration aMember : members) {
            MarkerUtils.createMarker(aMember, message, markerId);
        }
    }

    private static void computeMarkerPosition(IMarker aMarker, SourcePosition position) throws CoreException, IOException {
        int lineNumber = position.line();
        String fileContent = MarkerUtils.getContent((IFile)aMarker.getResource()).toString();
        List<Integer> linePositions = MarkerUtils.indexingLinePositions(fileContent);
        aMarker.setAttribute("charStart", (Object)linePositions.get(lineNumber - 1));
        aMarker.setAttribute("charEnd", (Object)linePositions.get(lineNumber));
    }

    private static List<Integer> indexingLinePositions(String aFileContent) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(0);
        int index = aFileContent.indexOf(10);
        while (index > -1) {
            result.add(index + 1);
            index = aFileContent.indexOf(10, index + 1);
        }
        return result;
    }

    private static StringBuffer getContent(IFile file) throws CoreException, IOException {
        InputStream inputStream = file.getContents();
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = null;
        try {
            int read;
            reader = new InputStreamReader(inputStream);
            char[] chars = new char[100];
            while ((read = reader.read(chars)) != -1) {
                if (read == 100) {
                    buffer.append(chars);
                    continue;
                }
                buffer.append(chars, 0, read);
            }
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        return buffer;
    }
}

