/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.core.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFUtils {
    private EMFUtils() {
    }

    public static EClass computeLeastCommonSupertype(Collection<EClass> classes) {
        return EMFUtils.computeLeastCommonSupertype(classes, null);
    }

    public static EClass computeLeastCommonSupertype(Collection<EClass> classes, EStructuralFeature feature) {
        AbstractCollection commonClassesFiltered;
        HashSet<EClass> commonClasses = new HashSet<EClass>();
        Iterator<EClass> iterator = classes.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            EClass eClass = iterator.next();
            if (first) {
                commonClasses.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
                commonClasses.add(eClass);
                first = false;
                continue;
            }
            ArrayList<EClass> filter = new ArrayList<EClass>((Collection<EClass>)eClass.getEAllSuperTypes());
            filter.add(eClass);
            commonClasses.retainAll(filter);
        }
        if (feature != null) {
            commonClassesFiltered = new ArrayList();
            for (EClass eClass : commonClasses) {
                if (!eClass.getEAllStructuralFeatures().contains((Object)feature)) continue;
                commonClassesFiltered.add(eClass);
            }
        } else {
            commonClassesFiltered = commonClasses;
        }
        int size = commonClassesFiltered.size();
        if (size == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        if (size == 1) {
            return (EClass)commonClassesFiltered.iterator().next();
        }
        ArrayList list = new ArrayList(commonClassesFiltered);
        ListIterator listIterator = list.listIterator();
        block2: while (listIterator.hasNext()) {
            EClass eClass = (EClass)listIterator.next();
            for (EClass eClass2 : commonClassesFiltered) {
                if (eClass == eClass2 || eClass.isSuperTypeOf(eClass2) || eClass2.isSuperTypeOf(eClass)) continue;
                listIterator.remove();
                continue block2;
            }
        }
        int size2 = list.size();
        if (size2 == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        if (size2 == 1) {
            return (EClass)list.iterator().next();
        }
        Collections.sort(list, new Comparator<EClass>(){

            @Override
            public int compare(EClass e1, EClass e2) {
                if (e1 == e2) {
                    return 0;
                }
                if (e1.isSuperTypeOf(e2)) {
                    return 1;
                }
                if (e2.isSuperTypeOf(e1)) {
                    return -1;
                }
                throw new IllegalStateException("comparing classes not in the same hierarchy");
            }
        });
        if (list.isEmpty()) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        return (EClass)list.get(0);
    }

    public static Set<EClass> getAllFeatureOwner(List<EObject> elements, EStructuralFeature feature) {
        HashSet<EClass> owners = new HashSet<EClass>();
        for (EObject el : elements) {
            if (!el.eClass().getEAllStructuralFeatures().contains((Object)feature)) continue;
            owners.add(el.eClass());
        }
        return owners;
    }
}

