/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public final class DebugUtils {
    private static final int CALLER = 3;

    private DebugUtils() {
    }

    public static void debug(boolean condition) {
        if (condition) {
            String location = DebugUtils.getCallerLocation(0);
            System.out.println(location);
        }
    }

    public static void debug(boolean condition, String message) {
        if (condition) {
            String location = DebugUtils.getCallerLocation(0);
            System.out.println(String.valueOf(location) + ": " + message);
        }
    }

    public static void debug(boolean condition, String messageTemplate, Object ... args) {
        if (condition) {
            DebugUtils.debug(1, messageTemplate, args);
        }
    }

    public static String getCallerLocation(int stackOffset) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3 + stackOffset];
        String location = String.valueOf(traceElement.getClassName()) + '.' + traceElement.getMethodName();
        return location;
    }

    public static boolean getDebugStatus(Plugin plugin) {
        String debugOption = DebugUtils.getDebugOption(plugin);
        return DebugUtils.internalGetDebugStatus(plugin, debugOption);
    }

    public static boolean getDebugStatus(Plugin plugin, String suboption) {
        String debugOption = String.valueOf(DebugUtils.getDebugOption(plugin)) + '/' + suboption;
        return DebugUtils.internalGetDebugStatus(plugin, debugOption);
    }

    private static boolean internalGetDebugStatus(Plugin plugin, String debugOption) {
        String debugOptionValue = Platform.getDebugOption((String)debugOption);
        boolean isDebuggingOption = Boolean.parseBoolean(debugOptionValue);
        boolean result = plugin.isDebugging() && isDebuggingOption;
        return result;
    }

    private static String getDebugOption(Plugin plugin) {
        Class classs;
        Bundle bundle = plugin.getBundle();
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
        String className = traceElement.getClassName();
        try {
            classs = bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String debugOption = String.valueOf(bundle.getSymbolicName()) + "/debug/" + classs.getSimpleName();
        return debugOption;
    }

    public static void debug(String message) {
        DebugUtils.debug(message, 1);
    }

    public static void debug(String messageTemplate, Object ... args) {
        DebugUtils.debug(1, messageTemplate, args);
    }

    public static void debug(String message, int stackOffset) {
        String location = DebugUtils.getCallerLocation(stackOffset);
        System.out.println(String.valueOf(location) + ": " + message);
    }

    public static void debug(int stackOffset, String messageTemplate, Object ... args) {
        String message = String.format(messageTemplate, args);
        DebugUtils.debug(message, stackOffset + 1);
    }
}

