/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.query.java.core.internal.evaluator;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.modisco.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.modisco.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.modisco.facet.efacet.core.internal.query.QueryUtils;
import org.eclipse.modisco.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.modisco.facet.efacet.core.query.IQueryImplementationFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.modisco.facet.query.java.core.IJavaQuery2;
import org.eclipse.modisco.facet.query.java.core.IJavaQuery3;
import org.eclipse.modisco.facet.query.java.core.internal.evaluator.JavaQueryImplementation;
import org.eclipse.modisco.facet.query.java.core.internal.plugin.Activator;
import org.eclipse.modisco.facet.query.java.metamodel.v0_2_0.javaquery.JavaQuery;
import org.eclipse.modisco.facet.query.java.metamodel.v0_2_0.javaquery.JavaQueryPackage;
import org.eclipse.modisco.facet.util.core.Logger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaQueryImplementationFactory
implements IQueryImplementationFactory {
    public IQueryImplementation create(Query query, Bundle bundle, IDerivedTypedElementManager manager) throws DerivedTypedElementException {
        if (!(query instanceof JavaQuery)) {
            throw new IllegalArgumentException("The given DerivedTypedElement does not have a JavaQuery");
        }
        JavaQuery javaQuery = (JavaQuery)query;
        if (bundle == null) {
            throw new DerivedTypedElementException("Java query implementation class '" + javaQuery.getClass().getName() + "' should be created within a bundle.");
        }
        JavaQueryImplementation javaQueryEvaluator = null;
        try {
            String className = javaQuery.getImplementationClassName();
            if (className == null || className.length() == 0) {
                throw new DerivedTypedElementException("The Java query's implementationClassName must not be empty");
            }
            Class javaQueryClass = bundle.loadClass(className);
            if (!IJavaQuery2.class.isAssignableFrom(javaQueryClass) && !IJavaQuery3.class.isAssignableFrom(javaQueryClass)) {
                String message = String.format("Java query implementation class '%s' does not implement %s or %s.", className, IJavaQuery2.class.getSimpleName(), IJavaQuery3.class.getSimpleName());
                throw new Exception(message);
            }
            javaQueryEvaluator = JavaQueryImplementationFactory.createJavaQueryImpl(javaQueryClass);
            javaQueryEvaluator.setCheckResultType(true);
        }
        catch (Exception e) {
            DerivedTypedElementException queryException = new DerivedTypedElementException("The bundle " + bundle.getSymbolicName() + " failed to load the java query: " + QueryUtils.getQueryDescription((Query)javaQuery), (Throwable)e);
            Logger.logError((Throwable)queryException, (Plugin)Activator.getDefault());
            throw queryException;
        }
        return javaQueryEvaluator;
    }

    private static JavaQueryImplementation createJavaQueryImpl(Class<?> javaQueryClass) throws InstantiationException, IllegalAccessException {
        Object query = javaQueryClass.newInstance();
        JavaQueryImplementation javaQueryEvaluator = new JavaQueryImplementation(query);
        return javaQueryEvaluator;
    }

    public EClass getManagedQueryType() {
        return JavaQueryPackage.eINSTANCE.getJavaQuery();
    }
}

