/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import org.eclipse.mat.util.IProgressListener;

public class SimpleMonitor {
    String task;
    IProgressListener delegate;
    int currentMonitor;
    int[] percentages;

    public SimpleMonitor(String task, IProgressListener monitor, int[] percentages) {
        this.task = task;
        this.delegate = monitor;
        this.percentages = percentages;
    }

    public IProgressListener nextMonitor() {
        if (this.currentMonitor == 0) {
            int total = 0;
            int[] nArray = this.percentages;
            int n = this.percentages.length;
            int n2 = 0;
            while (n2 < n) {
                int ii = nArray[n2];
                total += ii;
                ++n2;
            }
            this.delegate.beginTask(this.task, total);
        }
        return new Listener(this.percentages[this.currentMonitor++]);
    }

    public class Listener
    implements IProgressListener {
        long counter;
        int majorUnits;
        int unitsReported;
        long workDone;
        long workPerUnit;
        boolean isSmaller;

        public Listener(int majorUnits) {
            this.majorUnits = majorUnits;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null) {
                SimpleMonitor.this.delegate.subTask(name);
            }
            if (totalWork == 0) {
                return;
            }
            this.isSmaller = totalWork < this.majorUnits;
            this.workPerUnit = this.isSmaller ? this.majorUnits / totalWork : totalWork / this.majorUnits;
            this.unitsReported = 0;
        }

        public void subTask(String name) {
            SimpleMonitor.this.delegate.subTask(name);
        }

        public void done() {
            if (this.majorUnits - this.unitsReported > 0) {
                SimpleMonitor.this.delegate.worked(this.majorUnits - this.unitsReported);
            }
        }

        public boolean isCanceled() {
            return SimpleMonitor.this.delegate.isCanceled();
        }

        public boolean isProbablyCanceled() {
            return this.counter++ % 5000L == 0L ? this.isCanceled() : false;
        }

        public void totalWorkDone(long work) {
            if (this.workDone == work) {
                return;
            }
            if (this.workPerUnit == 0L) {
                return;
            }
            this.workDone = work;
            int unitsWorked = this.isSmaller ? (int)(work * this.workPerUnit) : (int)(work / this.workPerUnit);
            int unitsToReport = unitsWorked - this.unitsReported;
            if (unitsToReport > 0) {
                SimpleMonitor.this.delegate.worked(unitsToReport);
                this.unitsReported += unitsToReport;
            }
        }

        public void worked(int work) {
            this.totalWorkDone(this.workDone + (long)work);
        }

        public void setCanceled(boolean value) {
            SimpleMonitor.this.delegate.setCanceled(value);
        }

        public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
            SimpleMonitor.this.delegate.sendUserMessage(severity, message, exception);
        }

        public long getWorkDone() {
            return this.workDone;
        }
    }
}

