/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.LinkedPart;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.Parameters;
import org.eclipse.mat.report.internal.QueryPart;
import org.eclipse.mat.report.internal.SectionPart;
import org.eclipse.mat.util.MessageUtil;

public class PartsFactory {
    private int nextId = 1;
    private Map<Spec, AbstractPart> parts = new HashMap<Spec, AbstractPart>();

    public AbstractPart createRoot(Spec spec) {
        return this.build(null, spec);
    }

    public AbstractPart create(AbstractPart parent, Spec spec) {
        return this.build(parent, spec);
    }

    private AbstractPart build(AbstractPart parent, Spec spec) {
        AbstractPart p = this.parts.get(spec);
        if (p != null) {
            return new LinkedPart(String.valueOf(this.nextId++), parent, p.dataFile, p.spec, p);
        }
        DataFile artefact = new DataFile();
        AbstractPart answer = null;
        if (spec instanceof SectionSpec) {
            answer = new SectionPart(String.valueOf(this.nextId++), parent, artefact, (SectionSpec)spec, null);
        } else if (spec instanceof QuerySpec) {
            answer = new QueryPart(String.valueOf(this.nextId++), parent, artefact, (QuerySpec)spec);
        }
        if (answer == null) {
            throw new RuntimeException(MessageUtil.format(Messages.PartsFactory_Error_Construction, spec.getClass().getName()));
        }
        answer.init(this);
        this.parts.put(spec, answer);
        return answer;
    }

    public AbstractPart createClone(AbstractPart template, Spec spec) {
        DataFile artefact = template.getDataFile();
        AbstractPart answer = null;
        if (spec instanceof SectionSpec) {
            answer = new SectionPart(template.getId(), template.getParent(), artefact, (SectionSpec)spec, template.getCommand());
        } else if (spec instanceof QuerySpec) {
            answer = new QueryPart(template.getId(), template.getParent(), artefact, (QuerySpec)spec);
        }
        if (answer == null) {
            throw new RuntimeException(MessageUtil.format(Messages.PartsFactory_Error_Construction, spec.getClass().getName()));
        }
        answer.objects = template.objects;
        answer.params = new Parameters.Deep(answer.params, template.params);
        answer.init(this);
        this.parts.put(spec, answer);
        return answer;
    }
}

