/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.registry.QueryDescriptor;

public class QueryResult {
    private QueryResult parent;
    private QueryDescriptor query;
    private String command;
    private IResult subject;
    private ResultMetaData resultMetaData;
    private ContextProvider defaultContextProvider;

    public QueryResult(QueryDescriptor query, String command, IResult subject) {
        this(null, query, command, subject);
    }

    public QueryResult(QueryResult parent, QueryDescriptor query, String command, IResult subject) {
        this.parent = parent;
        this.query = query;
        this.command = command;
        this.subject = subject;
        ResultMetaData resultMetaData = this.resultMetaData = subject != null ? subject.getResultMetaData() : null;
        if (this.resultMetaData == null) {
            this.resultMetaData = new ResultMetaData.Builder().build();
        }
        if (subject instanceof IStructuredResult) {
            this.defaultContextProvider = new ContextProvider(null){

                public IContextObject getContext(Object row) {
                    return ((IStructuredResult)QueryResult.this.subject).getContext(row);
                }
            };
        }
    }

    public QueryResult getParent() {
        return this.parent;
    }

    public String getCommand() {
        return this.command;
    }

    public QueryDescriptor getQuery() {
        return this.query;
    }

    public IResult getSubject() {
        return this.subject;
    }

    public ResultMetaData getResultMetaData() {
        return this.resultMetaData;
    }

    public String getTitle() {
        return this.command;
    }

    public String getTitleToolTip() {
        return this.command;
    }

    public ContextProvider getDefaultContextProvider() {
        return this.defaultContextProvider;
    }
}

