/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.editor.xml.InsertArtifactProposal;
import org.eclipse.m2e.editor.xml.InsertExpressionProposal;
import org.eclipse.m2e.editor.xml.InsertSPDXLicenseProposal;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.m2e.editor.xml.PomTemplate;
import org.eclipse.m2e.editor.xml.PomTemplateContext;
import org.eclipse.m2e.editor.xml.PomTemplateProposal;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PomContentAssistProcessor
extends DefaultXMLCompletionProposalComputer {
    private static Set<PomTemplateContext> expressionproposalContexts = EnumSet.of(PomTemplateContext.GROUP_ID, new PomTemplateContext[]{PomTemplateContext.ARTIFACT_ID, PomTemplateContext.PACKAGING, PomTemplateContext.TYPE, PomTemplateContext.CLASSIFIER, PomTemplateContext.SCOPE, PomTemplateContext.SYSTEM_PATH, PomTemplateContext.PROPERTIES, PomTemplateContext.MODULE, PomTemplateContext.PHASE, PomTemplateContext.GOAL, PomTemplateContext.CONFIGURATION, PomTemplateContext.SOURCEDIRECTORY, PomTemplateContext.SCRIPTSOURCEDIRECTORY, PomTemplateContext.TESTSOURCEDIRECTORY, PomTemplateContext.OUTPUTDIRECTORY, PomTemplateContext.TESTOUTPUTDIRECTORY, PomTemplateContext.DIRECTORY, PomTemplateContext.FILTER, PomTemplateContext.UNKNOWN});
    private static List<String> hardwiredProperties = Collections.unmodifiableList(Arrays.asList("basedir", "project.basedir", "project.version", "project.groupId", "project.artifactId", "project.version", "project.name", "project.build.directory", "project.build.outputDirectory"));

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext ctx) {
        PomTemplateContext context = PomTemplateContext.fromNode(contentAssistRequest.getParent());
        if (PomTemplateContext.CONFIGURATION == context) {
            this.addTemplateProposals(contentAssistRequest, context, ctx.getViewer(), true);
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext ctx) {
        PomTemplateContext context = PomTemplateContext.fromNode(contentAssistRequest.getParent());
        int offset = contentAssistRequest.getReplacementBeginPosition();
        String prefix = PomContentAssistProcessor.extractPrefix(ctx.getViewer(), offset);
        contentAssistRequest.setMatchString(prefix);
        contentAssistRequest.setReplacementBeginPosition(offset - prefix.length());
        contentAssistRequest.setReplacementLength(prefix.length());
        this.addExpressionProposals(contentAssistRequest, context, ctx.getViewer());
        this.addGenerateProposals(contentAssistRequest, context, ctx.getViewer());
        this.addTemplateProposals(contentAssistRequest, context, ctx.getViewer(), false);
    }

    private void addExpressionProposals(ContentAssistRequest request, PomTemplateContext context, ITextViewer sourceViewer) {
        String prefix = request.getMatchString();
        int exprStart = prefix.lastIndexOf("${");
        if (exprStart != -1) {
            String realExpressionPrefix = prefix.substring(exprStart);
            if (realExpressionPrefix.contains("}")) {
                return;
            }
            if (expressionproposalContexts.contains((Object)context)) {
                Properties props;
                MavenProject prj = XmlUtils.extractMavenProject(sourceViewer);
                Region region = new Region(request.getReplacementBeginPosition() + exprStart, realExpressionPrefix.length());
                TreeSet<String> collect = new TreeSet<String>();
                String currentProp = null;
                Node node = request.getParent();
                if (PomTemplateContext.getAncestor(node, "properties", "project") != null || PomTemplateContext.getAncestor(node, "properties", "profile", "profiles", "project") != null) {
                    currentProp = node.getLocalName();
                }
                if (prj != null && (props = prj.getProperties()) != null) {
                    for (Object key : props.keySet()) {
                        String keyString = key.toString();
                        if (keyString.equals(currentProp) || !("${" + keyString).startsWith(realExpressionPrefix)) continue;
                        collect.add(keyString);
                    }
                }
                for (String prop : hardwiredProperties) {
                    if (!("${" + prop).startsWith(realExpressionPrefix)) continue;
                    collect.add(prop);
                }
                for (String key : collect) {
                    request.addProposal((ICompletionProposal)new InsertExpressionProposal(region, key, prj));
                }
            }
        }
    }

    private void addGenerateProposals(ContentAssistRequest request, PomTemplateContext context, ITextViewer sourceViewer) {
        Element parent;
        Node project;
        InsertArtifactProposal.Configuration config;
        Region region;
        CompletionProposal proposal;
        Region region2;
        String relative;
        Element parent2;
        Element relPath;
        String prefix = request.getMatchString();
        if (prefix.trim().length() != 0) {
            return;
        }
        Node node = request.getParent();
        if (context == PomTemplateContext.PARENT && node.getNodeName().equals("parent") && (relPath = XmlUtils.findChild(parent2 = (Element)node, "relativePath")) == null && (relative = PomContentAssistProcessor.findRelativePath(sourceViewer, parent2)) != null) {
            region2 = new Region(request.getReplacementBeginPosition(), 0);
            proposal = new CompletionProposal("<relativePath>" + relative + "</relativePath>", region2.getOffset(), region2.getLength(), 0, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"), NLS.bind((String)Messages.PomContentAssistProcessor_insert_relPath_title, (Object)relative), null, null);
            request.addProposal((ICompletionProposal)proposal);
        }
        if (context == PomTemplateContext.RELATIVE_PATH && (parent2 = (Element)node.getParentNode()) != null && "parent".equals(parent2.getNodeName())) {
            String relative2 = PomContentAssistProcessor.findRelativePath(sourceViewer, parent2);
            String textContent = XmlUtils.getTextValue(node);
            if (relative2 != null && !relative2.equals(textContent)) {
                region2 = new Region(request.getReplacementBeginPosition() - prefix.length(), prefix.length());
                if (request.getNode() instanceof IndexedRegion && request.getNode() instanceof Text) {
                    IndexedRegion index = (IndexedRegion)request.getNode();
                    region2 = new Region(index.getStartOffset(), index.getEndOffset() - index.getStartOffset());
                }
                proposal = new CompletionProposal(relative2, region2.getOffset(), region2.getLength(), 0, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"), NLS.bind((String)Messages.PomContentAssistProcessor_set_relPath_title, (Object)relative2), null, null);
                request.addProposal((ICompletionProposal)proposal);
            }
        }
        if (context == PomTemplateContext.DEPENDENCIES || context == PomTemplateContext.PROFILE || context == PomTemplateContext.DEPENDENCY_MANAGEMENT || context == PomTemplateContext.PROJECT) {
            region = new Region(request.getReplacementBeginPosition(), 0);
            config = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.DEPENDENCY);
            config.setCurrentNode(node);
            request.addProposal((ICompletionProposal)new InsertArtifactProposal(sourceViewer, region, config));
        }
        if (context == PomTemplateContext.PLUGINS || context == PomTemplateContext.BUILD || context == PomTemplateContext.PLUGIN_MANAGEMENT || context == PomTemplateContext.PROJECT) {
            region = new Region(request.getReplacementBeginPosition(), 0);
            config = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.PLUGIN);
            config.setCurrentNode(node);
            request.addProposal((ICompletionProposal)new InsertArtifactProposal(sourceViewer, region, config));
        }
        if (context == PomTemplateContext.PROJECT && (project = node) != null && project instanceof Element && (parent = XmlUtils.findChild((Element)project, "parent")) == null) {
            Region region3 = new Region(request.getReplacementBeginPosition(), 0);
            Element groupId = XmlUtils.findChild((Element)project, "groupId");
            String groupString = null;
            if (groupId != null) {
                groupString = XmlUtils.getTextValue(groupId);
            }
            InsertArtifactProposal.Configuration config2 = new InsertArtifactProposal.Configuration(InsertArtifactProposal.SearchType.PARENT);
            config2.setInitiaSearchString(groupString);
            request.addProposal((ICompletionProposal)new InsertArtifactProposal(sourceViewer, region3, config2));
        }
        if (context == PomTemplateContext.PROJECT && XmlUtils.findChild((Element)node, "licenses") == null || context == PomTemplateContext.LICENSES) {
            region = new Region(request.getReplacementBeginPosition(), 0);
            request.addProposal((ICompletionProposal)new InsertSPDXLicenseProposal(sourceViewer, context, region));
        }
    }

    private static String findRelativePath(ITextViewer viewer, Element parent) {
        String groupId = XmlUtils.getTextValue(XmlUtils.findChild(parent, "groupId"));
        String artifactId = XmlUtils.getTextValue(XmlUtils.findChild(parent, "artifactId"));
        String version = XmlUtils.getTextValue(XmlUtils.findChild(parent, "version"));
        return PomContentAssistProcessor.findRelativePath(viewer, groupId, artifactId, version);
    }

    public static String findRelativePath(ITextViewer viewer, String groupId, String artifactId, String version) {
        IMavenProjectFacade facade;
        if (groupId != null && artifactId != null && version != null && (facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(groupId, artifactId, version)) != null) {
            IPath path2;
            IPath relative;
            IFile parentPomFile = facade.getPom();
            IPath path = parentPomFile.getLocation();
            IProject prj = XmlUtils.extractProject(viewer);
            if (prj != null && path != null && (relative = path.makeRelativeTo(path2 = prj.getLocation())) != path) {
                return relative.toString();
            }
        }
        return null;
    }

    private void addTemplateProposals(ContentAssistRequest request, PomTemplateContext context, ITextViewer sourceViewer, boolean tagProposals) {
        int n;
        int n2;
        Template[] templateArray;
        Template[] templates;
        Region region;
        TemplateContext templateContext;
        MavenProject prj = XmlUtils.extractMavenProject(sourceViewer);
        IProject eclipseprj = XmlUtils.extractProject(sourceViewer);
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        Node parentNode = request.getParent();
        int offset = request.getReplacementBeginPosition();
        String prefix = request.getMatchString();
        int len = prefix.length();
        IndexedRegion ir = (IndexedRegion)request.getNode();
        if (ir instanceof Text) {
            IDocument document = sourceViewer.getDocument();
            int i = offset + len;
            while (i < ir.getEndOffset()) {
                try {
                    if (Character.isWhitespace(document.getChar(i))) {
                    }
                }
                catch (BadLocationException e) {}
                break;
                ++len;
                ++i;
            }
        }
        if (tagProposals) {
            --offset;
            ++len;
        }
        if ((templateContext = this.createContext(sourceViewer, (IRegion)(region = new Region(offset, len)), context.getContextTypeId())) == null) {
            return;
        }
        templateContext.setVariable("selection", selection.getText());
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        TemplateStore store = MvnIndexPlugin.getDefault().getTemplateStore();
        if (store != null) {
            templateArray = templates = store.getTemplates(context.getContextTypeId());
            n2 = templates.length;
            n = 0;
            while (n < n2) {
                Template template = templateArray[n];
                TemplateProposal proposal = this.createProposalForTemplate(prefix, region, templateContext, MvnImages.IMG_USER_TEMPLATE, template, true);
                if (proposal != null) {
                    matches.add(proposal);
                }
                ++n;
            }
        }
        templateArray = templates = context.getTemplates(prj, eclipseprj, parentNode, prefix);
        n2 = templates.length;
        n = 0;
        while (n < n2) {
            TemplateProposal proposal;
            Template template = templateArray[n];
            Image image = null;
            if (template instanceof PomTemplate) {
                image = ((PomTemplate)template).getImage();
            }
            if ((proposal = this.createProposalForTemplate(prefix, region, templateContext, image, template, false)) != null) {
                matches.add(proposal);
            }
            ++n;
        }
        for (ICompletionProposal iCompletionProposal : matches) {
            request.addProposal(iCompletionProposal);
        }
    }

    private TemplateProposal createProposalForTemplate(String prefix, Region region, TemplateContext context, Image image, final Template template, boolean isUserTemplate) {
        try {
            context.getContextType().validate(template.getPattern());
            if (template.matches(prefix, context.getContextType().getId())) {
                if (isUserTemplate) {
                    return new PomTemplateProposal(template, context, (IRegion)region, image, this.getRelevance(template, prefix)){

                        public String getAdditionalProposalInfo() {
                            return StringUtils.convertToHTMLContent((String)super.getAdditionalProposalInfo());
                        }
                    };
                }
                return new PomTemplateProposal(template, context, (IRegion)region, image, this.getRelevance(template, prefix)){

                    public String getAdditionalProposalInfo() {
                        return this.getTemplate().getDescription();
                    }

                    public String getDisplayString() {
                        return template.getName();
                    }
                };
            }
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        return null;
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region, String contextTypeId) {
        TemplateContextType contextType = this.getContextType(viewer, region, contextTypeId);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected int getRelevance(Template template, String prefix) {
        int rel;
        if (template instanceof PomTemplate && (rel = ((PomTemplate)template).getRelevance()) != -1) {
            return rel;
        }
        if (template.getName().startsWith(prefix)) {
            return 1900;
        }
        return 1500;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region, String contextTypeId) {
        ContextTypeRegistry registry = MvnIndexPlugin.getDefault().getTemplateContextRegistry();
        if (registry != null) {
            return registry.getContextType(contextTypeId);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static final String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while ((ch = document.getChar(i - 1)) != '>' && ch != '<' && ch != ' ' && ch != '\n' && ch != '\t') {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }
}

