/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import org.eclipse.jface.text.Region;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.PomTemplateContext;
import org.eclipse.m2e.editor.xml.internal.dialogs.SPDXLicense;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddLicensePomOperation
implements PomEdits.Operation {
    private final SPDXLicense license;
    private final PomTemplateContext context;
    private final Region region;
    private int generatedOffset = -1;
    private int generatedLength = -1;

    public AddLicensePomOperation(SPDXLicense license, PomTemplateContext context, Region region) {
        if (license == null) {
            throw new NullPointerException();
        }
        if (context != PomTemplateContext.PROJECT && context != PomTemplateContext.LICENSES) {
            throw new IllegalArgumentException();
        }
        if (context == PomTemplateContext.LICENSES && region == null) {
            throw new IllegalArgumentException();
        }
        this.license = license;
        this.context = context;
        this.region = region;
    }

    public void process(Document doc) {
        Element element = this.context == PomTemplateContext.PROJECT ? this.createLicenses(doc) : this.createLicense(doc);
        PomEdits.format((Node)element);
        if (element instanceof IndexedRegion) {
            this.generatedOffset = ((IndexedRegion)element).getStartOffset();
            this.generatedLength = ((IndexedRegion)element).getEndOffset() - this.generatedOffset;
        }
    }

    private Element createLicenses(Document doc) {
        Element licensesDom = this.region != null ? PomEdits.insertAt((Element)doc.createElement("licenses"), (int)this.region.getOffset()) : PomEdits.getChild((Element)doc.getDocumentElement(), (String[])new String[]{"licenses"});
        this.setLicense(PomEdits.createElement((Element)licensesDom, (String)"license"));
        return licensesDom;
    }

    private Element createLicense(Document doc) {
        Element licenseDom = PomEdits.insertAt((Element)doc.createElement("license"), (int)this.region.getOffset());
        this.setLicense(licenseDom);
        return licenseDom;
    }

    void setLicense(Element licenseDom) {
        PomEdits.setText((Element)PomEdits.getChild((Element)licenseDom, (String[])new String[]{"name"}), (String)this.license.getName());
        PomEdits.setText((Element)PomEdits.getChild((Element)licenseDom, (String[])new String[]{"url"}), (String)this.license.getURL());
    }

    public Point getSelection() {
        return new Point(this.generatedOffset, this.generatedLength);
    }
}

