/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.internal.docker.ui.DockerConnectionWatcher;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerExplorerView
extends CommonNavigator
implements IDockerConnectionManagerListener,
ITabbedPropertySheetPageContributor {
    private static final String NO_CONNECTION_LABEL = "NoConnection.label";
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerExplorerView";
    private Control connectionsPane;
    private Control explanationsPane;
    private Control currentPane;
    private PageBook pageBook;
    private Map<IDockerConnection, ContainersRefresher> containersRefreshers = new HashMap<IDockerConnection, ContainersRefresher>();
    private Map<IDockerConnection, ImagesRefresher> imagesRefreshers = new HashMap<IDockerConnection, ImagesRefresher>();
    private Text search;
    private ViewerFilter containersAndImagesSearchFilter;

    public DockerExplorerView() {
        DockerConnectionWatcher.getInstance();
    }

    protected Object getInitialInput() {
        return DockerConnectionManager.getInstance();
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        this.setLinkingEnabled(false);
        return viewer;
    }

    public String getContributorId() {
        return "org.eclipse.linuxtools.docker.ui.propertiesViewContributor";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IPropertySheetPage.class.isAssignableFrom(adapter)) {
            return (T)new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return (T)super.getAdapter(adapter);
    }

    public void dispose() {
        Map.Entry<IDockerConnection, Object> entry;
        Iterator<Map.Entry<IDockerConnection, Object>> iterator = this.containersRefreshers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getKey().removeContainerListener((IDockerContainerListener)entry.getValue());
            iterator.remove();
        }
        iterator = this.imagesRefreshers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getKey().removeImageListener((IDockerImageListener)entry.getValue());
            iterator.remove();
        }
        DockerConnectionManager.getInstance().removeConnectionManagerListener((IDockerConnectionManagerListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        this.connectionsPane = this.createConnectionsPane(this.pageBook, toolkit);
        this.explanationsPane = this.createExplanationPane(this.pageBook, toolkit);
        this.showConnectionsOrExplanations();
        this.containersAndImagesSearchFilter = this.getContainersAndImagesSearchFilter();
        this.getCommonViewer().addFilter(this.containersAndImagesSearchFilter);
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
        if (DockerConnectionManager.getInstance().getConnections().length > 0) {
            IDockerConnection conn = DockerConnectionManager.getInstance().getConnections()[0];
            this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)conn));
        }
    }

    private ViewerFilter getContainersAndImagesSearchFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDockerContainer || element instanceof IDockerImage) {
                    return element.toString().contains(DockerExplorerView.this.search.getText());
                }
                return true;
            }
        };
    }

    private Control createConnectionsPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        super.createPartControl(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.getCommonViewer().getControl());
        if (DockerConnectionManager.getInstance().hasConnections()) {
            IDockerConnection connection = DockerConnectionManager.getInstance().getFirstConnection();
            this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)connection));
        }
        return form;
    }

    private ModifyListener onSearch() {
        return e -> {
            TreePath[] treePaths;
            CommonViewer viewer = this.getCommonViewer();
            TreePath[] treePathArray = treePaths = viewer.getExpandedTreePaths();
            int n = treePaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                Object lastSegment = treePath.getLastSegment();
                if (lastSegment instanceof DockerExplorerContentProvider.DockerContainersCategory || lastSegment instanceof DockerExplorerContentProvider.DockerImagesCategory) {
                    viewer.refresh(lastSegment);
                    viewer.expandToLevel((Object)treePath, -1);
                }
                ++n2;
            }
        };
    }

    private Control createExplanationPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        Link link = new Link(container, 0);
        link.setText(DVMessages.getString(NO_CONNECTION_LABEL));
        link.setBackground(pageBook.getDisplay().getSystemColor(25));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)link);
        link.addSelectionListener(this.onExplanationClicked());
        return form;
    }

    private SelectionListener onExplanationClicked() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = CommandUtils.openWizard((IWizard)new NewDockerConnection(), PlatformUI.getWorkbench().getModalDialogShellProvider().getShell());
        });
    }

    public void showConnectionsOrExplanations() {
        if (!DockerConnectionManager.getInstance().hasConnections() && this.pageBook != this.explanationsPane) {
            this.pageBook.showPage(this.explanationsPane);
            this.currentPane = this.explanationsPane;
        } else if (this.pageBook != this.connectionsPane) {
            this.pageBook.showPage(this.connectionsPane);
            this.currentPane = this.connectionsPane;
            this.registerListeners();
        }
    }

    public boolean isShowingConnectionsPane() {
        return this.currentPane == this.connectionsPane;
    }

    public void changeEvent(IDockerConnection connection, int type) {
        Display.getDefault().asyncExec(() -> {
            this.showConnectionsOrExplanations();
            switch (type) {
                case 0: {
                    this.registerListeners(connection);
                    this.getCommonViewer().refresh();
                    this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)connection));
                    break;
                }
                case 2: {
                    this.getCommonViewer().refresh((Object)connection);
                    break;
                }
                case 3: {
                    this.getCommonViewer().refresh();
                    break;
                }
                case 1: {
                    this.unregisterListeners(connection);
                    this.getCommonViewer().refresh();
                    if (DockerConnectionManager.getInstance().hasConnections()) {
                        this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)DockerConnectionManager.getInstance().getFirstConnection()), true);
                        break;
                    }
                    this.getCommonViewer().setSelection(null);
                }
            }
        });
    }

    private void registerListeners() {
        DockerConnectionManager.getInstance().getAllConnections().stream().forEach(connection -> this.registerListeners((IDockerConnection)connection));
    }

    private void registerListeners(IDockerConnection connection) {
        Object refresher;
        if (connection == null) {
            return;
        }
        if (!this.containersRefreshers.containsKey(connection)) {
            refresher = new ContainersRefresher();
            connection.addContainerListener((IDockerContainerListener)refresher);
            this.containersRefreshers.put(connection, (ContainersRefresher)refresher);
        }
        if (!this.imagesRefreshers.containsKey(connection)) {
            refresher = new ImagesRefresher();
            connection.addImageListener((IDockerImageListener)refresher);
            this.imagesRefreshers.put(connection, (ImagesRefresher)refresher);
        }
    }

    private void unregisterListeners(IDockerConnection connection) {
        Object refresher;
        if (this.containersRefreshers.containsKey(connection)) {
            refresher = this.containersRefreshers.get(connection);
            connection.removeContainerListener((IDockerContainerListener)refresher);
            this.containersRefreshers.remove(connection);
        }
        if (this.imagesRefreshers.containsKey(connection)) {
            refresher = this.imagesRefreshers.get(connection);
            connection.removeImageListener((IDockerImageListener)refresher);
            this.imagesRefreshers.remove(connection);
        }
    }

    private void refresh(IDockerConnection connection) {
        Display.getDefault().asyncExec(() -> {
            if (this.getCommonViewer().getTree() != null && !this.getCommonViewer().getTree().isDisposed()) {
                ITreeSelection old = (ITreeSelection)this.getCommonViewer().getSelection();
                this.getCommonViewer().refresh((Object)connection, true);
                ITreeSelection current = (ITreeSelection)this.getCommonViewer().getSelection();
                if (!old.isEmpty() && current.isEmpty()) {
                    this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)connection));
                }
            }
        });
    }

    class ContainersRefresher
    implements IDockerContainerListener {
        ContainersRefresher() {
        }

        public void listChanged(IDockerConnection connection, List<IDockerContainer> containers) {
            DockerExplorerView.this.refresh(connection);
        }
    }

    class ImagesRefresher
    implements IDockerImageListener {
        ImagesRefresher() {
        }

        public void listChanged(IDockerConnection connection, List<IDockerImage> images) {
            DockerExplorerView.this.refresh(connection);
        }
    }
}

